/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jagg.Aggregator;

public abstract class MultiPropAggregator
extends Aggregator {
    private List<String> myProperties;

    protected MultiPropAggregator() {
    }

    protected void setProperty(String property) {
        String[] fields = property.split(",", 0);
        if (fields != null) {
            this.myProperties = Arrays.asList(fields);
            if (fields.length >= 1) {
                super.setProperty(fields[0]);
            }
        } else {
            this.myProperties = new ArrayList<String>();
        }
    }

    public String getProperty(int index) {
        return this.myProperties.get(index);
    }

    public int getNumProperties() {
        return this.myProperties.size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append("(");
        int size = this.myProperties.size();
        for (int i = 0; i < size; ++i) {
            String property = this.myProperties.get(i);
            if (i > 0) {
                buf.append(",");
            }
            buf.append(property);
        }
        buf.append(")");
        return buf.toString();
    }
}

