/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.TreeMap;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.exception.ExpectedComparableException;
import net.sf.jagg.model.WindowClause;
import net.sf.jagg.util.FrequencyMapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeAggregator
extends Aggregator
implements AnalyticFunction {
    private TreeMap<Comparable<?>, Integer> myIteratedElements;

    public ModeAggregator(String property) {
        this.setProperty(property);
    }

    @Override
    public ModeAggregator replicate() {
        return new ModeAggregator(this.getProperty());
    }

    @Override
    public void init() {
        this.myIteratedElements = new TreeMap();
    }

    @Override
    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable comp = (Comparable)ModeAggregator.getValueFromProperty(value, property);
                if (comp != null) {
                    FrequencyMapUtil.add(this.myIteratedElements, comp);
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    @Override
    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable comp = (Comparable)ModeAggregator.getValueFromProperty(value, property);
                if (comp != null) {
                    FrequencyMapUtil.remove(this.myIteratedElements, comp);
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    @Override
    public boolean takesWindowClause() {
        return true;
    }

    @Override
    public WindowClause getWindowClause() {
        return null;
    }

    @Override
    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof ModeAggregator) {
            ModeAggregator otherAgg = (ModeAggregator)agg;
            FrequencyMapUtil.combine(otherAgg.myIteratedElements, this.myIteratedElements);
        }
    }

    @Override
    public Comparable<?> terminate() {
        int numItems = this.myIteratedElements.size();
        if (numItems == 0) {
            return null;
        }
        Comparable<?> mode = null;
        int maxFrequency = 0;
        for (Comparable<?> c : this.myIteratedElements.keySet()) {
            int frequency = this.myIteratedElements.get(c);
            if (frequency <= maxFrequency) continue;
            maxFrequency = frequency;
            mode = c;
        }
        return mode;
    }
}

