/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.TreeMap;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.MinAggregator;
import net.sf.jagg.exception.ExpectedComparableException;
import net.sf.jagg.model.WindowClause;
import net.sf.jagg.util.FrequencyMapUtil;

public class MinAnalyticAggregator
extends MinAggregator
implements AnalyticFunction {
    private TreeMap<Comparable, Integer> myIteratedElements = new TreeMap();

    public MinAnalyticAggregator(String property) {
        super(property);
    }

    public MinAnalyticAggregator replicate() {
        return new MinAnalyticAggregator(this.getProperty());
    }

    public void init() {
        super.init();
        this.myIteratedElements.clear();
    }

    public void iterate(Object value) {
        super.iterate(value);
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable obj = (Comparable)MinAnalyticAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    Integer frequency = this.myIteratedElements.get(obj);
                    if (frequency != null) {
                        this.myIteratedElements.put(obj, frequency + 1);
                    } else {
                        this.myIteratedElements.put(obj, 1);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable currMin;
                Integer frequency;
                Comparable obj = (Comparable)MinAnalyticAggregator.getValueFromProperty(value, property);
                if (obj != null && (frequency = this.myIteratedElements.get(obj)) != null && !FrequencyMapUtil.remove(this.myIteratedElements, obj) && (currMin = this.getMin()) != null && currMin.compareTo(obj) == 0) {
                    if (this.myIteratedElements.isEmpty()) {
                        this.setMin(null);
                    } else {
                        this.setMin(this.myIteratedElements.firstKey());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        super.merge(agg);
        if (agg != null && agg instanceof MinAnalyticAggregator) {
            MinAnalyticAggregator otherAgg = (MinAnalyticAggregator)agg;
            FrequencyMapUtil.combine(otherAgg.myIteratedElements, this.myIteratedElements);
        }
    }
}

