/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.TreeMap;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.MaxAggregator;
import net.sf.jagg.exception.ExpectedComparableException;
import net.sf.jagg.model.WindowClause;
import net.sf.jagg.util.FrequencyMapUtil;

public class MaxAnalyticAggregator
extends MaxAggregator
implements AnalyticFunction {
    private TreeMap<Comparable, Integer> myIteratedElements = new TreeMap();

    public MaxAnalyticAggregator(String property) {
        super(property);
    }

    public MaxAnalyticAggregator replicate() {
        return new MaxAnalyticAggregator(this.getProperty());
    }

    public void init() {
        super.init();
        this.myIteratedElements.clear();
    }

    public void iterate(Object value) {
        super.iterate(value);
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable obj = (Comparable)MaxAnalyticAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    FrequencyMapUtil.add(this.myIteratedElements, obj);
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable currMax;
                Integer frequency;
                Comparable obj = (Comparable)MaxAnalyticAggregator.getValueFromProperty(value, property);
                if (obj != null && (frequency = this.myIteratedElements.get(obj)) != null && !FrequencyMapUtil.remove(this.myIteratedElements, obj) && (currMax = this.getMax()) != null && currMax.compareTo(obj) == 0) {
                    if (this.myIteratedElements.isEmpty()) {
                        this.setMax(null);
                    } else {
                        this.setMax(this.myIteratedElements.lastKey());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        super.merge(agg);
        if (agg != null && agg instanceof MaxAnalyticAggregator) {
            MaxAnalyticAggregator otherAgg = (MaxAnalyticAggregator)agg;
            FrequencyMapUtil.combine(otherAgg.myIteratedElements, this.myIteratedElements);
        }
    }
}

