/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.exception.ExpectedComparableException;

public class MaxAggregator
extends Aggregator {
    private Comparable myMax;

    public MaxAggregator(String property) {
        this.setProperty(property);
    }

    public MaxAggregator replicate() {
        return new MaxAggregator(this.getProperty());
    }

    public void init() {
        this.myMax = null;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable obj = (Comparable)MaxAggregator.getValueFromProperty(value, property);
                if (obj != null && (this.myMax == null || obj.compareTo(this.myMax) > 0)) {
                    this.myMax = obj;
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof MaxAggregator) {
            MaxAggregator otherAgg = (MaxAggregator)agg;
            if (otherAgg.myMax != null && (this.myMax == null || otherAgg.myMax.compareTo(this.myMax) > 0)) {
                this.myMax = otherAgg.myMax;
            }
        }
    }

    public Comparable terminate() {
        return this.myMax;
    }

    protected final Comparable getMax() {
        return this.myMax;
    }

    protected final void setMax(Comparable max) {
        this.myMax = max;
    }
}

