/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.AvgAggregator;
import net.sf.jagg.CovariancePopAggregator;
import net.sf.jagg.TwoPropAggregator;
import net.sf.jagg.VariancePopAggregator;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.model.LinearRegressionStats;
import net.sf.jagg.model.WindowClause;

public class LinearRegressionAggregator
extends TwoPropAggregator
implements AnalyticFunction {
    private CovariancePopAggregator myCovarianceAgg = null;
    private VariancePopAggregator myFirstVarAgg = null;
    private VariancePopAggregator mySecondVarAgg = null;
    private AvgAggregator myFirstAvgAgg = null;
    private AvgAggregator mySecondAvgAgg = null;
    private long myCount;

    public LinearRegressionAggregator(String properties) {
        this.setProperty(properties);
    }

    public LinearRegressionAggregator(String property, String property2) {
        this.setProperty(property + "," + property2);
    }

    public LinearRegressionAggregator replicate() {
        return new LinearRegressionAggregator(this.getProperty(), this.getProperty2());
    }

    public void init() {
        if (this.myCovarianceAgg == null) {
            this.myCovarianceAgg = new CovariancePopAggregator(this.getProperty(), this.getProperty2());
        }
        if (this.myFirstVarAgg == null) {
            this.myFirstVarAgg = new VariancePopAggregator(this.getProperty());
        }
        if (this.mySecondVarAgg == null) {
            this.mySecondVarAgg = new VariancePopAggregator(this.getProperty2());
        }
        if (this.myFirstAvgAgg == null) {
            this.myFirstAvgAgg = new AvgAggregator(this.getProperty());
        }
        if (this.mySecondAvgAgg == null) {
            this.mySecondAvgAgg = new AvgAggregator(this.getProperty2());
        }
        this.myCovarianceAgg.init();
        this.myFirstVarAgg.init();
        this.mySecondVarAgg.init();
        this.myFirstAvgAgg.init();
        this.mySecondAvgAgg.init();
        this.myCount = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property1 = this.getProperty();
            String property2 = this.getProperty2();
            Object obj1 = LinearRegressionAggregator.getValueFromProperty(value, property1);
            Object obj2 = LinearRegressionAggregator.getValueFromProperty(value, property2);
            if (obj1 != null && obj2 != null) {
                ++this.myCount;
                this.myCovarianceAgg.iterate(value);
                this.myFirstVarAgg.iterate(value);
                this.mySecondVarAgg.iterate(value);
                this.myFirstAvgAgg.iterate(value);
                this.mySecondAvgAgg.iterate(value);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property1 = this.getProperty();
            String property2 = this.getProperty2();
            Object obj1 = LinearRegressionAggregator.getValueFromProperty(value, property1);
            Object obj2 = LinearRegressionAggregator.getValueFromProperty(value, property2);
            if (obj1 != null && obj2 != null) {
                --this.myCount;
                this.myCovarianceAgg.delete(value);
                this.myFirstVarAgg.delete(value);
                this.mySecondVarAgg.delete(value);
                this.myFirstAvgAgg.delete(value);
                this.mySecondAvgAgg.delete(value);
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof LinearRegressionAggregator) {
            LinearRegressionAggregator otherAgg = (LinearRegressionAggregator)agg;
            this.myCovarianceAgg.merge(otherAgg.myCovarianceAgg);
            this.myFirstVarAgg.merge(otherAgg.myFirstVarAgg);
            this.mySecondVarAgg.merge(otherAgg.mySecondVarAgg);
            this.myFirstAvgAgg.merge(otherAgg.myFirstAvgAgg);
            this.mySecondAvgAgg.merge(otherAgg.mySecondAvgAgg);
            this.myCount += otherAgg.myCount;
        }
    }

    public LinearRegressionStats terminate() {
        double rSquared;
        double intercept;
        double slope;
        DoubleDouble correlation;
        DoubleDouble covariance = this.myCovarianceAgg.terminateDoubleDouble();
        DoubleDouble variance1 = this.myFirstVarAgg.terminateDoubleDouble();
        DoubleDouble variance2 = this.mySecondVarAgg.terminateDoubleDouble();
        DoubleDouble avg1 = this.myFirstAvgAgg.terminateDoubleDouble();
        DoubleDouble avg2 = this.mySecondAvgAgg.terminateDoubleDouble();
        if (this.myCount <= 0L) {
            return new LinearRegressionStats(Double.NaN, Double.NaN, 0L, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        if (variance1.compareTo(DoubleDouble.ZERO) == 0 || variance2.compareTo(DoubleDouble.ZERO) == 0) {
            correlation = DoubleDouble.NaN;
        } else {
            correlation = new DoubleDouble(covariance);
            DoubleDouble temp = new DoubleDouble(variance1);
            temp.multiplySelfBy(variance2);
            temp.sqrtSelf();
            correlation.divideSelfBy(temp);
        }
        if (variance2.compareTo(DoubleDouble.ZERO) == 0) {
            slope = Double.NaN;
            intercept = Double.NaN;
            rSquared = Double.NaN;
        } else if (variance1.compareTo(DoubleDouble.ZERO) == 0) {
            slope = 0.0;
            intercept = avg1.doubleValue();
            rSquared = 1.0;
        } else {
            DoubleDouble temp = new DoubleDouble(covariance);
            temp.divideSelfBy(variance2);
            slope = temp.doubleValue();
            temp.multiplySelfBy(avg2);
            temp.negateSelf();
            temp.addToSelf(avg1);
            intercept = temp.doubleValue();
            temp = new DoubleDouble(correlation);
            temp.squareSelf();
            rSquared = temp.doubleValue();
        }
        return new LinearRegressionStats(slope, intercept, this.myCount, rSquared, correlation.doubleValue(), avg1.doubleValue(), avg2.doubleValue());
    }
}

