/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.exception.ExpectedNumberException;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.model.WindowClause;

public class HarmonicMeanAggregator
extends Aggregator
implements AnalyticFunction {
    private DoubleDouble mySum = new DoubleDouble();
    private long myCount;
    private long myNumZeroes;

    public HarmonicMeanAggregator(String property) {
        this.setProperty(property);
    }

    public HarmonicMeanAggregator replicate() {
        return new HarmonicMeanAggregator(this.getProperty());
    }

    public void init() {
        this.mySum.reset();
        this.myCount = 0L;
        this.myNumZeroes = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)HarmonicMeanAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    ++this.myCount;
                    double d = obj.doubleValue();
                    if (d == 0.0) {
                        ++this.myNumZeroes;
                    } else {
                        DoubleDouble temp = new DoubleDouble(1.0);
                        temp.divideSelfBy(obj.doubleValue());
                        this.mySum.addToSelf(temp);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)HarmonicMeanAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    --this.myCount;
                    double d = obj.doubleValue();
                    if (d == 0.0) {
                        --this.myNumZeroes;
                    } else {
                        DoubleDouble temp = new DoubleDouble(1.0);
                        temp.divideSelfBy(obj.doubleValue());
                        this.mySum.subtractFromSelf(temp);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof HarmonicMeanAggregator) {
            HarmonicMeanAggregator otherAgg = (HarmonicMeanAggregator)agg;
            this.mySum.addToSelf(otherAgg.mySum);
            this.myCount += otherAgg.myCount;
            this.myNumZeroes += otherAgg.myNumZeroes;
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        if (this.myCount <= 0L || this.myNumZeroes > 0L || this.mySum.compareTo(DoubleDouble.ZERO) == 0) {
            return new DoubleDouble(DoubleDouble.NaN);
        }
        DoubleDouble result = new DoubleDouble(this.myCount);
        result.divideSelfBy(this.mySum);
        return result;
    }
}

