/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.exception.ExpectedNumberException;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.model.WindowClause;

public class GeometricMeanAggregator
extends Aggregator
implements AnalyticFunction {
    private DoubleDouble myProduct = new DoubleDouble();
    private long myCount;
    private int myNumZeroes;

    public GeometricMeanAggregator(String property) {
        this.setProperty(property);
    }

    public GeometricMeanAggregator replicate() {
        return new GeometricMeanAggregator(this.getProperty());
    }

    public void init() {
        this.myProduct.reset();
        this.myProduct.addToSelf(1.0);
        this.myCount = 0L;
        this.myNumZeroes = 0;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)GeometricMeanAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    ++this.myCount;
                    if (obj.doubleValue() == 0.0) {
                        ++this.myNumZeroes;
                    } else {
                        this.myProduct.multiplySelfBy(obj.doubleValue());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)GeometricMeanAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    --this.myCount;
                    double d = obj.doubleValue();
                    if (d == 0.0) {
                        --this.myNumZeroes;
                    } else {
                        this.myProduct.divideSelfBy(d);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof GeometricMeanAggregator) {
            GeometricMeanAggregator otherAgg = (GeometricMeanAggregator)agg;
            this.myProduct.multiplySelfBy(otherAgg.myProduct);
            this.myCount += otherAgg.myCount;
            this.myNumZeroes += otherAgg.myNumZeroes;
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        if (this.myCount > 0L) {
            if (this.myNumZeroes > 0) {
                return new DoubleDouble(0.0);
            }
            DoubleDouble result = new DoubleDouble(this.myProduct);
            result.nthRootSelf(this.myCount);
            return result;
        }
        return new DoubleDouble(DoubleDouble.NaN);
    }
}

