/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.NoPropAnalytic;
import net.sf.jagg.model.WindowClause;

public class DenseRankAnalytic
extends NoPropAnalytic {
    private long myCount;
    private boolean doIStartRunOver;

    public DenseRankAnalytic(String property) {
        this.setProperty(property);
    }

    public DenseRankAnalytic() {
        this.setProperty(null);
    }

    public DenseRankAnalytic replicate() {
        return new DenseRankAnalytic();
    }

    public void init() {
        this.myCount = 0L;
        this.doIStartRunOver = true;
    }

    public void iterate(Object value) {
        if (value != null) {
            if (this.doIStartRunOver) {
                ++this.myCount;
            }
            this.doIStartRunOver = false;
        }
    }

    public void delete(Object value) {
        if (value != null) {
            this.doIStartRunOver = true;
        }
    }

    public boolean takesWindowClause() {
        return false;
    }

    public WindowClause getWindowClause() {
        return new WindowClause(WindowClause.Type.RANGE, 0, 0);
    }

    public void merge(AggregateFunction agg) {
        throw new UnsupportedOperationException("Merge not implemented!");
    }

    public Long terminate() {
        return this.myCount;
    }
}

