/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.model.WindowClause;

public class CountAggregator
extends Aggregator
implements AnalyticFunction {
    public static final String COUNT_ALL = "*";
    private long myCount;

    public CountAggregator(String property) {
        this.setProperty(property);
    }

    public CountAggregator replicate() {
        return new CountAggregator(this.getProperty());
    }

    public void init() {
        this.myCount = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            if (property.equals(COUNT_ALL)) {
                ++this.myCount;
            } else {
                Object obj = CountAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    ++this.myCount;
                }
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            if (property.equals(COUNT_ALL)) {
                --this.myCount;
            } else {
                Object obj = CountAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    --this.myCount;
                }
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof CountAggregator) {
            CountAggregator otherAgg = (CountAggregator)agg;
            this.myCount += otherAgg.myCount;
        }
    }

    public Long terminate() {
        return this.myCount;
    }
}

