/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.model.WindowClause;

public class ConcatAggregator
extends Aggregator
implements AnalyticFunction {
    private StringBuilder myBuf;
    private String mySeparator;
    private boolean hasContent;

    public ConcatAggregator(String property) {
        this.setProperty(property);
    }

    public ConcatAggregator(String property, String separator) {
        this.setProperty(property);
        this.mySeparator = separator;
    }

    public ConcatAggregator replicate() {
        return new ConcatAggregator(this.getProperty(), this.mySeparator);
    }

    protected void setProperty(String property) {
        String[] fields = property.split(",", 2);
        if (fields.length == 1) {
            super.setProperty(property);
            this.mySeparator = "";
        } else if (fields.length >= 2) {
            super.setProperty(fields[0]);
            String sepExpression = fields[1].trim();
            if (sepExpression.startsWith("\"") && sepExpression.endsWith("\"")) {
                sepExpression = sepExpression.length() == 1 ? "\"" : sepExpression.substring(1, sepExpression.length() - 1);
            }
            this.mySeparator = sepExpression;
        }
    }

    public void init() {
        this.myBuf = new StringBuilder();
        this.hasContent = false;
    }

    public void iterate(Object value) {
        String property;
        Object obj;
        if (value != null && (obj = ConcatAggregator.getValueFromProperty(value, property = this.getProperty())) != null) {
            if (this.hasContent && this.mySeparator != null && this.mySeparator.length() > 0) {
                this.myBuf.append(this.mySeparator);
            } else {
                this.hasContent = true;
            }
            this.myBuf.append(obj.toString());
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            Object obj = ConcatAggregator.getValueFromProperty(value, property);
            if (obj != null) {
                String strObj = obj.toString();
                String ifAtBeginning = strObj + this.mySeparator;
                int startsWithIndex = this.myBuf.indexOf(ifAtBeginning);
                if (startsWithIndex == 0) {
                    this.myBuf.replace(0, ifAtBeginning.length(), "");
                } else {
                    String ifInInterior = this.mySeparator + ifAtBeginning;
                    int interiorIndex = this.myBuf.indexOf(ifInInterior);
                    if (interiorIndex != -1) {
                        this.myBuf.replace(interiorIndex, interiorIndex + ifInInterior.length(), this.mySeparator);
                    } else if (this.myBuf.toString().equals(strObj)) {
                        this.myBuf.setLength(0);
                    }
                }
            }
            this.hasContent = this.myBuf.length() > 0;
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof ConcatAggregator) {
            ConcatAggregator otherAgg = (ConcatAggregator)agg;
            if (otherAgg.hasContent) {
                if (!this.hasContent) {
                    this.hasContent = true;
                } else {
                    this.myBuf.append(this.mySeparator);
                }
                this.myBuf.append((CharSequence)otherAgg.myBuf);
            }
        }
    }

    public String terminate() {
        return this.myBuf.toString();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getProperty() + (this.mySeparator.length() > 0 ? ",\"" + this.mySeparator + "\"" : "") + ")";
    }
}

