/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.exception.ExpectedNumberException;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.model.WindowClause;

public class AvgAggregator
extends Aggregator
implements AnalyticFunction {
    private DoubleDouble mySum = new DoubleDouble();
    private long myCount;

    public AvgAggregator(String property) {
        this.setProperty(property);
    }

    public AvgAggregator replicate() {
        return new AvgAggregator(this.getProperty());
    }

    public void init() {
        this.mySum.reset();
        this.myCount = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)AvgAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    ++this.myCount;
                    this.mySum.addToSelf(obj.doubleValue());
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)AvgAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    --this.myCount;
                    this.mySum.subtractFromSelf(obj.doubleValue());
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof AvgAggregator) {
            AvgAggregator otherAgg = (AvgAggregator)agg;
            this.mySum.addToSelf(otherAgg.mySum);
            this.myCount += otherAgg.myCount;
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        if (this.myCount > 0L) {
            DoubleDouble result = new DoubleDouble(this.mySum);
            result.divideSelfBy(this.myCount);
            return result;
        }
        return DoubleDouble.NaN;
    }
}

