/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.DependentAnalyticFunction;
import net.sf.jagg.exception.AnalyticCreationException;
import net.sf.jagg.exception.ParseException;
import net.sf.jagg.model.AnalyticContext;
import net.sf.jagg.model.AnalyticValue;
import net.sf.jagg.model.OrderByClause;
import net.sf.jagg.model.OrderByElement;
import net.sf.jagg.model.PartitionClause;
import net.sf.jagg.model.WindowClause;
import net.sf.jagg.util.AnalyticCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticAggregator
implements AnalyticFunction {
    private static final boolean DEBUG = false;
    private static final AnalyticCache myAnalyticCache = new AnalyticCache();
    public static final String PARTITION_CLAUSE_IND = "partitionBy";
    public static final String ORDER_BY_CLAUSE_IND = "orderBy";
    public static final String WINDOW_CLAUSE_IND_ROWS = "rows";
    public static final String WINDOW_CLAUSE_IND_RANGE = "range";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String NULLS = "NULLS";
    public static final String FIRST = "FIRST";
    public static final String LAST = "LAST";
    public static final String WINDOW_THROUGH = ",";
    private static final List<String> ANALYTIC_SUFFIXES = Arrays.asList("AnalyticAggregator", "Aggregator", "Analytic");
    private AnalyticFunction myAnalyticFunction;
    private PartitionClause myPartition;
    private OrderByClause myOrderBy;
    private WindowClause myWindow;

    private AnalyticAggregator(Builder builder) {
        if (builder.myAnalyticFunction == null) {
            throw new IllegalArgumentException("Analytic function not supplied!");
        }
        this.myAnalyticFunction = builder.myAnalyticFunction;
        this.myPartition = builder.myPartition;
        this.myOrderBy = builder.myOrderBy;
        this.myWindow = builder.myWindow;
    }

    private AnalyticAggregator(AnalyticAggregator agg) {
        this.myAnalyticFunction = agg.replicate();
        this.myPartition = agg.myPartition;
        this.myOrderBy = agg.myOrderBy;
        this.myWindow = agg.myWindow;
    }

    public static AnalyticAggregator getAnalytic(String anaSpec) {
        int partitionIdx = anaSpec.indexOf(PARTITION_CLAUSE_IND);
        int orderByIdx = anaSpec.indexOf(ORDER_BY_CLAUSE_IND);
        int windowRowsIdx = anaSpec.indexOf(WINDOW_CLAUSE_IND_ROWS);
        int windowRangeIdx = anaSpec.indexOf(WINDOW_CLAUSE_IND_RANGE);
        if (windowRowsIdx != -1 && windowRangeIdx != -1) {
            throw new ParseException("Can't specify both rows and range in an analytic function.");
        }
        int minAnalyticIdx = -1;
        if (partitionIdx != -1) {
            minAnalyticIdx = partitionIdx;
        }
        if (orderByIdx != -1 && (minAnalyticIdx == -1 || orderByIdx < minAnalyticIdx)) {
            minAnalyticIdx = orderByIdx;
        }
        if (windowRowsIdx != -1 && (minAnalyticIdx == -1 || windowRowsIdx < minAnalyticIdx)) {
            minAnalyticIdx = windowRowsIdx;
        }
        if (windowRangeIdx != -1 && (minAnalyticIdx == -1 || windowRangeIdx < minAnalyticIdx)) {
            minAnalyticIdx = windowRangeIdx;
        }
        String aggSpecPart = minAnalyticIdx != -1 ? anaSpec.substring(0, minAnalyticIdx).trim() : anaSpec;
        int leftParenIdx = aggSpecPart.indexOf("(");
        int rightParenIdx = aggSpecPart.lastIndexOf(")");
        if (leftParenIdx == -1 || rightParenIdx == -1 || leftParenIdx > rightParenIdx) {
            throw new ParseException("Malformed Analytic specification: " + anaSpec);
        }
        String aggName = aggSpecPart.substring(0, leftParenIdx);
        int dotIndex = aggSpecPart.indexOf(".");
        if (dotIndex == -1 || dotIndex > leftParenIdx) {
            aggName = AnalyticFunction.class.getPackage().getName() + "." + aggName;
        }
        AnalyticFunction anaFunc = null;
        for (String suffix : ANALYTIC_SUFFIXES) {
            String aggNameWithSuffix = aggName;
            if (!aggName.endsWith(suffix)) {
                aggNameWithSuffix = aggName + suffix;
            }
            String property = aggSpecPart.substring(leftParenIdx + 1, rightParenIdx);
            try {
                Class<?> aggClass = Class.forName(aggNameWithSuffix);
                Constructor<?> ctor = aggClass.getConstructor(String.class);
                anaFunc = (AnalyticFunction)ctor.newInstance(property);
                break;
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException e) {
                throw new AnalyticCreationException("Can't find constructor for AnalyticFunction class \"" + aggName + "\" that contains exactly one String parameter.", e);
            }
            catch (InstantiationException e) {
                throw new AnalyticCreationException("AnalyticFunction specified is not a concrete class: \"" + aggName + "\".", e);
            }
            catch (IllegalAccessException e) {
                throw new AnalyticCreationException("Unable to construct AnalyticFunction \"" + aggName + "\".", e);
            }
            catch (InvocationTargetException e) {
                throw new AnalyticCreationException("Exception caught instantiating AnalyticFunction \"" + aggName + "\": " + e.getCause().getClass().getName(), e);
            }
            catch (ClassCastException e) {
                throw new AnalyticCreationException("Class found is not an AnalyticFunction: \"" + aggName + "\".", e);
            }
        }
        if (anaFunc == null) {
            throw new AnalyticCreationException("Unknown AnalyticFunction class \"" + aggName + "\".");
        }
        Builder builder = new Builder();
        builder.setAnalyticFunction(anaFunc).setPartition(AnalyticAggregator.getPartitionClause(anaSpec, partitionIdx, orderByIdx, windowRowsIdx, windowRangeIdx)).setOrderBy(AnalyticAggregator.getOrderByClause(anaSpec, partitionIdx, orderByIdx, windowRowsIdx, windowRangeIdx)).setWindow(AnalyticAggregator.getWindowClause(anaSpec, partitionIdx, orderByIdx, windowRowsIdx, windowRangeIdx));
        return builder.build();
    }

    public static AnalyticAggregator getAnalyticAggregator(AnalyticAggregator archetype) {
        return myAnalyticCache.getFunction(archetype);
    }

    private static PartitionClause getPartitionClause(String anaSpec, int partitionIdx, int orderByIdx, int windowRowsIdx, int windowRangeIdx) {
        if (partitionIdx == -1) {
            return null;
        }
        int endOfPartitionByClause = -1;
        if (orderByIdx > partitionIdx) {
            endOfPartitionByClause = orderByIdx;
        }
        if (windowRowsIdx > partitionIdx && windowRowsIdx < endOfPartitionByClause) {
            endOfPartitionByClause = windowRowsIdx;
        }
        if (windowRangeIdx > partitionIdx && windowRangeIdx < endOfPartitionByClause) {
            endOfPartitionByClause = windowRangeIdx;
        }
        String partitionByClause = endOfPartitionByClause != -1 ? anaSpec.substring(partitionIdx, endOfPartitionByClause).trim() : anaSpec.substring(partitionIdx).trim();
        int leftParenIdx = partitionByClause.indexOf("(");
        int rightParenIdx = partitionByClause.lastIndexOf(")");
        if (leftParenIdx == -1 || rightParenIdx == -1 || leftParenIdx > rightParenIdx) {
            throw new ParseException("Malformed Analytic partitionBy clause: " + anaSpec);
        }
        String inParens = partitionByClause.substring(leftParenIdx + 1, rightParenIdx);
        ArrayList<String> propsList = new ArrayList<String>();
        if (inParens.trim().length() > 0) {
            String[] properties;
            for (String prop : properties = inParens.split(WINDOW_THROUGH)) {
                propsList.add(prop.trim());
            }
        }
        return new PartitionClause(propsList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OrderByClause getOrderByClause(String anaSpec, int partitionIdx, int orderByIdx, int windowRowsIdx, int windowRangeIdx) {
        String[] orderBySpecs;
        if (orderByIdx == -1) {
            return null;
        }
        int endOfOrderByClause = -1;
        if (partitionIdx > orderByIdx) {
            endOfOrderByClause = partitionIdx;
        }
        if (windowRowsIdx > orderByIdx && (windowRowsIdx < endOfOrderByClause || endOfOrderByClause == -1)) {
            endOfOrderByClause = windowRowsIdx;
        }
        if (windowRangeIdx > orderByIdx && (windowRangeIdx < endOfOrderByClause || endOfOrderByClause == -1)) {
            endOfOrderByClause = windowRangeIdx;
        }
        String orderByClause = endOfOrderByClause != -1 ? anaSpec.substring(orderByIdx, endOfOrderByClause).trim() : anaSpec.substring(orderByIdx).trim();
        int leftParenIdx = orderByClause.indexOf("(");
        int rightParenIdx = orderByClause.lastIndexOf(")");
        if (leftParenIdx == -1 || rightParenIdx == -1 || leftParenIdx > rightParenIdx) {
            throw new ParseException("Malformed Analytic orderBy clause: " + anaSpec);
        }
        String inParens = orderByClause.substring(leftParenIdx + 1, rightParenIdx);
        ArrayList<OrderByElement> elementsList = new ArrayList<OrderByElement>();
        if (inParens.trim().length() <= 0) return new OrderByClause(elementsList);
        for (String orderBySpec : orderBySpecs = inParens.split(WINDOW_THROUGH)) {
            String[] parts = orderBySpec.trim().split("\\s+");
            if (parts.length <= 0 || parts.length >= 5) throw new ParseException("OrderBy: Expected \"property\" [ASC|DESC] [NULLS ]FIRST|LAST: " + orderBySpec);
            String property = parts[0];
            OrderByElement.SortDir ordering = OrderByElement.SortDir.ASC;
            OrderByElement.NullSort nullOrdering = OrderByElement.NullSort.LAST;
            if (parts.length == 2 || parts.length == 4) {
                if (ASC.equalsIgnoreCase(parts[1])) {
                    ordering = OrderByElement.SortDir.ASC;
                    nullOrdering = OrderByElement.NullSort.LAST;
                } else if (DESC.equalsIgnoreCase(parts[1])) {
                    ordering = OrderByElement.SortDir.DESC;
                    nullOrdering = OrderByElement.NullSort.FIRST;
                } else {
                    if (!NULLS.equalsIgnoreCase(parts[1])) throw new ParseException("OrderBy: Expected \"ASC\" or \"DESC: " + orderBySpec);
                    throw new ParseException("OrderBy: Expected \"FIRST\" or \"LAST after NULLS: " + orderBySpec);
                }
            }
            if (parts.length == 3 || parts.length == 4) {
                if (!NULLS.equalsIgnoreCase(parts[parts.length - 2])) {
                    throw new ParseException("OrderBy: Expected \"NULLS FIRST|LAST: " + orderBySpec);
                }
                if (LAST.equalsIgnoreCase(parts[parts.length - 1])) {
                    nullOrdering = OrderByElement.NullSort.LAST;
                } else {
                    if (!FIRST.equalsIgnoreCase(parts[parts.length - 1])) throw new ParseException("OrderBy: Expected \"FIRST\" or \"LAST: " + orderBySpec);
                    nullOrdering = OrderByElement.NullSort.FIRST;
                }
            }
            elementsList.add(new OrderByElement(property, ordering, nullOrdering));
        }
        return new OrderByClause(elementsList);
    }

    private static WindowClause getWindowClause(String anaSpec, int partitionIdx, int orderByIdx, int windowRowsIdx, int windowRangeIdx) {
        int endOfWindowClause;
        int startOfWindowClause;
        WindowClause.Type windowType;
        if (windowRowsIdx == -1 && windowRangeIdx == -1) {
            return null;
        }
        if (windowRowsIdx != -1 && windowRangeIdx != -1) {
            throw new ParseException("Can't have range and rows at the same time: " + anaSpec);
        }
        if (windowRowsIdx != -1) {
            windowType = WindowClause.Type.ROWS;
            startOfWindowClause = windowRowsIdx;
            endOfWindowClause = -1;
            if (orderByIdx > windowRowsIdx) {
                endOfWindowClause = orderByIdx;
            }
            if (partitionIdx > windowRowsIdx && partitionIdx < endOfWindowClause) {
                endOfWindowClause = partitionIdx;
            }
        } else {
            windowType = WindowClause.Type.RANGE;
            startOfWindowClause = windowRangeIdx;
            endOfWindowClause = -1;
            if (orderByIdx > windowRangeIdx) {
                endOfWindowClause = orderByIdx;
            }
            if (partitionIdx > windowRangeIdx && partitionIdx < endOfWindowClause) {
                endOfWindowClause = partitionIdx;
            }
        }
        String windowClause = endOfWindowClause != -1 ? anaSpec.substring(startOfWindowClause, endOfWindowClause).trim() : anaSpec.substring(startOfWindowClause).trim();
        int leftParenIdx = windowClause.indexOf("(");
        int rightParenIdx = windowClause.lastIndexOf(")");
        if (leftParenIdx == -1 || rightParenIdx == -1 || leftParenIdx > rightParenIdx) {
            throw new ParseException("Malformed Analytic window clause: " + anaSpec);
        }
        String inParens = windowClause.substring(leftParenIdx + 1, rightParenIdx).trim();
        if (inParens.length() == 0) {
            return new WindowClause(windowType, null, null);
        }
        try {
            int index = inParens.indexOf(WINDOW_THROUGH);
            if (index != -1) {
                String before = inParens.substring(0, index).trim();
                String after = inParens.substring(index + 1).trim();
                Double dBefore = before.equals("") ? null : Double.valueOf(before);
                Double dAfter = after.equals("") ? null : Double.valueOf(after);
                return new WindowClause(windowType, dBefore, dAfter);
            }
            if (inParens.trim().equals("")) {
                return new WindowClause(windowType, null, null);
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Window clause arguments must be numbers: " + anaSpec, e);
        }
        throw new ParseException("Window clause arguments must be ([value] , [value]) or ():" + anaSpec);
    }

    @Override
    public String getProperty() {
        return this.myAnalyticFunction.getProperty();
    }

    @Override
    public void init() {
        this.myAnalyticFunction.init();
    }

    @Override
    public void iterate(Object value) {
        this.myAnalyticFunction.iterate(value);
    }

    @Override
    public void merge(AggregateFunction func) {
        this.myAnalyticFunction.merge(func);
    }

    @Override
    public void delete(Object value) {
        this.myAnalyticFunction.delete(value);
    }

    @Override
    public boolean takesWindowClause() {
        return this.myAnalyticFunction.takesWindowClause();
    }

    @Override
    public WindowClause getWindowClause() {
        return this.myAnalyticFunction.getWindowClause();
    }

    @Override
    public Object terminate() {
        return this.myAnalyticFunction.terminate();
    }

    @Override
    public void setInUse(boolean inUse) {
        this.myAnalyticFunction.setInUse(inUse);
    }

    @Override
    public boolean isInUse() {
        return this.myAnalyticFunction.isInUse();
    }

    @Override
    public AnalyticAggregator replicate() {
        return new AnalyticAggregator(this);
    }

    public PartitionClause getPartition() {
        return this.myPartition;
    }

    public OrderByClause getOrderBy() {
        return this.myOrderBy;
    }

    public WindowClause getWindow() {
        return this.myWindow;
    }

    public List<AnalyticAggregator> getDependentAnalyticAggregators() {
        ArrayList<AnalyticAggregator> dependents = new ArrayList<AnalyticAggregator>();
        if (this.myAnalyticFunction instanceof DependentAnalyticFunction) {
            DependentAnalyticFunction depFunc = (DependentAnalyticFunction)this.myAnalyticFunction;
            int numFuncs = depFunc.getNumDependentFunctions();
            for (int i = 0; i < numFuncs; ++i) {
                AnalyticAggregator depAna = new Builder().setAnalyticFunction(depFunc.getAnalyticFunction(i)).setPartition(this.getPartition()).setOrderBy(this.getOrderBy()).setWindow(depFunc.getWindowClause(i)).build();
                if (depAna.myAnalyticFunction.getClass().equals(this.myAnalyticFunction.getClass())) {
                    throw new ParseException("A DependentAnalyticFunction can't depend on itself: " + this.myAnalyticFunction);
                }
                dependents.add(depAna);
            }
        }
        return dependents;
    }

    public void setValuesForDependentAnalytics(AnalyticValue<?> anaValue, AnalyticContext<?> context) {
        if (this.myAnalyticFunction instanceof DependentAnalyticFunction) {
            DependentAnalyticFunction depFunc = (DependentAnalyticFunction)this.myAnalyticFunction;
            List<Integer> dependencies = context.getDependencies();
            if (dependencies != null) {
                for (int i = 0; i < dependencies.size(); ++i) {
                    depFunc.setValue(i, anaValue.getAnalyzedValue(dependencies.get(i)));
                }
            }
        }
    }

    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass()) && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getAnalyticFunctionClassName() {
        return this.myAnalyticFunction.getClass().getName();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.myAnalyticFunction.toString());
        if (this.myPartition != null) {
            buf.append(" ");
            buf.append(this.myPartition.toString());
        }
        if (this.myOrderBy != null) {
            buf.append(" ");
            buf.append(this.myOrderBy.toString());
        }
        if (this.myWindow != null) {
            buf.append(" ");
            buf.append(this.myWindow.toString());
        }
        return buf.toString();
    }

    public static class Builder {
        private AnalyticFunction myAnalyticFunction = null;
        private PartitionClause myPartition = null;
        private OrderByClause myOrderBy = null;
        private WindowClause myWindow = null;

        public Builder setAnalyticFunction(AnalyticFunction func) {
            if (func == null) {
                throw new IllegalArgumentException("func must not be null!");
            }
            this.myAnalyticFunction = func;
            return this;
        }

        public Builder setPartition(PartitionClause partition) {
            this.myPartition = partition;
            return this;
        }

        public Builder setOrderBy(OrderByClause orderBy) {
            this.myOrderBy = orderBy;
            return this;
        }

        public Builder setWindow(WindowClause window) {
            this.myWindow = window;
            return this;
        }

        public AnalyticAggregator build() {
            if (this.myWindow == null) {
                this.myWindow = WindowClause.DEFAULT;
            }
            this.validate();
            if (!this.myAnalyticFunction.takesWindowClause()) {
                this.myWindow = this.myAnalyticFunction.getWindowClause();
            }
            return new AnalyticAggregator(this);
        }

        private void validate() {
            if (this.myAnalyticFunction == null) {
                throw new IllegalStateException("Must set an AnalyticFunction!");
            }
            Number startValue = this.myWindow.getStartValue();
            Number endValue = this.myWindow.getEndValue();
            if (this.myWindow.getWindowType() == WindowClause.Type.RANGE && (startValue != null && startValue.doubleValue() != 0.0 || endValue != null && endValue.doubleValue() != 0.0) && (this.myOrderBy == null || this.myOrderBy.getElements().size() != 1)) {
                throw new ParseException("Range window with bounds that exist and are not 0 must have exactly one element in the order by clause: " + this.myAnalyticFunction + " " + this.myPartition + " " + this.myOrderBy + " " + this.myWindow);
            }
            if (!this.myAnalyticFunction.takesWindowClause() && this.myWindow != WindowClause.DEFAULT) {
                throw new ParseException("Function " + this.myAnalyticFunction + " does not take a window clause.");
            }
        }
    }
}

