/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jagg.Aggregations;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticAggregator;
import net.sf.jagg.model.AnalyticContext;
import net.sf.jagg.model.AnalyticValue;
import net.sf.jagg.model.OrderByElement;
import net.sf.jagg.model.WindowClause;
import net.sf.jagg.util.PartitionAndOrderByComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analytic {
    private static final boolean DEBUG = false;
    private List<AnalyticAggregator> myAnalytics;

    private Analytic(Builder builder) {
        this.myAnalytics = new ArrayList<AnalyticAggregator>(builder.myAnalytics);
    }

    public <T> List<AnalyticValue<T>> analyze(List<T> values) {
        PartitionAndOrderByComparator comparator;
        if (values.size() == 0) {
            return new ArrayList<AnalyticValue<T>>();
        }
        ArrayList<AnalyticValue<T>> analyticValues = new ArrayList<AnalyticValue<T>>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            analyticValues.add(new AnalyticValue<T>(values.get(i)));
        }
        ArrayList<PartitionAndOrderByComparator> sortComparators = new ArrayList<PartitionAndOrderByComparator>(this.myAnalytics.size());
        ArrayList<PartitionAndOrderByComparator> comparators = new ArrayList<PartitionAndOrderByComparator>(this.myAnalytics.size());
        for (int i = 0; i < this.myAnalytics.size(); ++i) {
            PartitionAndOrderByComparator existing;
            int j;
            AnalyticAggregator ana = this.myAnalytics.get(i);
            comparator = new PartitionAndOrderByComparator(ana.getPartition(), ana.getOrderBy());
            comparators.add(comparator);
            for (j = 0; j < sortComparators.size(); ++j) {
                existing = (PartitionAndOrderByComparator)sortComparators.get(j);
                if (!existing.covers(comparator)) continue;
                comparator = existing;
            }
            for (j = 0; j < sortComparators.size(); ++j) {
                existing = (PartitionAndOrderByComparator)sortComparators.get(j);
                if (!comparator.covers(existing)) continue;
                sortComparators.set(j, comparator);
            }
            sortComparators.add(comparator);
        }
        if (this.myAnalytics.isEmpty()) {
            return analyticValues;
        }
        ArrayList<AnalyticContext<T>> contexts = new ArrayList<AnalyticContext<T>>(sortComparators.size());
        for (int i = 0; i < sortComparators.size(); ++i) {
            comparator = (PartitionAndOrderByComparator)comparators.get(i);
            PartitionAndOrderByComparator sortComparator = (PartitionAndOrderByComparator)sortComparators.get(i);
            List<AnalyticValue<T>> sortedValues = null;
            for (int j = 0; j < contexts.size(); ++j) {
                AnalyticContext context = (AnalyticContext)contexts.get(j);
                PartitionAndOrderByComparator previous = context.getComparator();
                if (!previous.equals(sortComparator)) continue;
                sortComparator = previous;
                sortedValues = context.getListOfValues();
                break;
            }
            if (sortedValues == null) {
                sortedValues = new ArrayList<AnalyticValue<T>>(analyticValues);
                Collections.sort(sortedValues, sortComparator);
            }
            AnalyticContext<T> newContext = new AnalyticContext<T>(sortedValues, comparator);
            contexts.add(newContext);
        }
        this.doAnalysis(contexts);
        return analyticValues;
    }

    private <T> List<AnalyticValue<T>> doAnalysis(List<AnalyticContext<T>> contexts) {
        List<AnalyticValue<T>> analyzedList = this.getAnalyzedValues(contexts);
        return analyzedList;
    }

    private <T> List<AnalyticValue<T>> getAnalyzedValues(List<AnalyticContext<T>> contexts) {
        AnalyticAggregator ana;
        AnalyticContext<T> context;
        int a;
        ArrayList<AnalyticValue<T>> aggValues = new ArrayList<AnalyticValue<T>>();
        List<AnalyticAggregator> anaList = this.getAnalyticAggregatorsList();
        int anaSize = this.myAnalytics.size();
        int index = 0;
        int listsize = contexts.get(0).getListOfValues().size();
        for (a = 0; a < anaSize; ++a) {
            context = contexts.get(a);
            context.setEndOfPartitionIndex(Aggregations.indexOfLastMatching(context.getListOfValues(), context.getComparator().getPartitionComparator(), index));
            ana = anaList.get(a);
            anaList.addAll(ana.getDependentAnalyticAggregators());
            if (anaSize != anaList.size()) {
                ArrayList<Integer> dependencies = new ArrayList<Integer>();
                for (int i = anaSize; i < anaList.size(); ++i) {
                    dependencies.add(i);
                    AnalyticContext<T> newContext = new AnalyticContext<T>(context.getListOfValues(), context.getComparator());
                    contexts.add(newContext);
                }
                context.setDependencies(dependencies);
            }
            anaSize = anaList.size();
            ana.init();
        }
        while (index < listsize) {
            for (a = anaSize - 1; a >= 0; --a) {
                context = contexts.get(a);
                ana = anaList.get(a);
                if (index > context.getEndOfPartitionIndex()) {
                    this.betweenPartitionsProcessing(a, ana, context);
                    context.setEndOfPartitionIndex(Aggregations.indexOfLastMatching(context.getListOfValues(), context.getComparator().getPartitionComparator(), index));
                    ana.init();
                }
                this.processItem(a, ana, index, context);
            }
            ++index;
        }
        for (a = anaSize - 1; a >= 0; --a) {
            context = contexts.get(a);
            ana = anaList.get(a);
            if (index <= context.getEndOfPartitionIndex()) continue;
            this.betweenPartitionsProcessing(a, ana, context);
        }
        return aggValues;
    }

    private void betweenPartitionsProcessing(int anaIndex, AnalyticAggregator ana, AnalyticContext<?> context) {
        int endOfPartitionIndex = context.getEndOfPartitionIndex();
        while (context.getTerminatedThroughIndex() < endOfPartitionIndex) {
            if (context.getWindowStartIndex() > context.getEndOfPartitionIndex() || this.isInWindow(context, ana, context.getWindowStartIndex())) {
                this.terminate(anaIndex, ana, context);
                continue;
            }
            this.delete(ana, context);
        }
        context.advanceWindowStartPastLastTerminated();
    }

    private void processItem(int anaIndex, AnalyticAggregator ana, int index, AnalyticContext<?> context) {
        while (context.getTerminatedThroughIndex() < context.getEndOfPartitionIndex() && !this.isInWindow(context, ana, index, false)) {
            this.terminate(anaIndex, ana, context);
            while (context.getWindowEndIndex() >= context.getWindowStartIndex() && !this.isInWindow(context, ana, context.getWindowStartIndex())) {
                this.delete(ana, context);
            }
        }
        AnalyticValue<?> iterValue = context.getListOfValues().get(index);
        Object valueToIterate = iterValue.getObject();
        ana.iterate(valueToIterate);
        context.incrementWindowEndIndex();
    }

    private <T> boolean isInWindow(AnalyticContext<T> context, AnalyticAggregator ana, int index) {
        return this.isInWindow(context, ana, index, true);
    }

    private <T> boolean isInWindow(AnalyticContext<T> context, AnalyticAggregator ana, int index, boolean considerStart) {
        WindowClause window = ana.getWindow();
        int nextTerminationIndex = context.getTerminatedThroughIndex() + 1;
        switch (window.getWindowType()) {
            case ROWS: {
                int endWindow;
                int startWindow;
                if (considerStart && window.getStartValue() != null && (startWindow = nextTerminationIndex - window.getStartValue().intValue()) > index) {
                    return false;
                }
                return window.getEndValue() == null || index <= (endWindow = nextTerminationIndex + window.getEndValue().intValue());
            }
            case RANGE: {
                double dIndexValue;
                double dNextTerminatedValue;
                Number indexPropValue;
                Number nextTerminatedPropValue;
                String property;
                OrderByElement only;
                PartitionAndOrderByComparator<T> comparator = context.getComparator();
                AnalyticValue<T> nextTerminatedValue = context.getListOfValues().get(nextTerminationIndex);
                AnalyticValue<T> indexValue = context.getListOfValues().get(index);
                T objNextTerminatedValue = nextTerminatedValue.getObject();
                T objIndexPropValue = indexValue.getObject();
                if (considerStart && window.getStartValue() != null) {
                    if (window.getStartValue().doubleValue() == 0.0) {
                        if (index < nextTerminationIndex && comparator.compare(nextTerminatedValue, indexValue) != 0) {
                            return false;
                        }
                    } else {
                        only = comparator.getOrderByElements().get(0);
                        property = only.getProperty();
                        nextTerminatedPropValue = (Number)Aggregator.getValueFromProperty(objNextTerminatedValue, property);
                        indexPropValue = (Number)Aggregator.getValueFromProperty(objIndexPropValue, property);
                        if (nextTerminatedPropValue == null || indexPropValue == null) {
                            return false;
                        }
                        dNextTerminatedValue = nextTerminatedPropValue.doubleValue();
                        dIndexValue = indexPropValue.doubleValue();
                        switch (only.getSortDir()) {
                            case ASC: {
                                double startWindow = dNextTerminatedValue - window.getStartValue().doubleValue();
                                if (!(startWindow > dIndexValue)) break;
                                return false;
                            }
                            case DESC: {
                                double startWindow = dNextTerminatedValue + window.getStartValue().doubleValue();
                                if (!(startWindow < dIndexValue)) break;
                                return false;
                            }
                        }
                    }
                }
                if (window.getEndValue() != null) {
                    if (window.getEndValue().doubleValue() == 0.0) {
                        if (index > nextTerminationIndex && comparator.compare(nextTerminatedValue, indexValue) != 0) {
                            return false;
                        }
                    } else {
                        only = comparator.getOrderByElements().get(0);
                        property = only.getProperty();
                        nextTerminatedPropValue = (Number)Aggregator.getValueFromProperty(objNextTerminatedValue, property);
                        indexPropValue = (Number)Aggregator.getValueFromProperty(objIndexPropValue, property);
                        if (nextTerminatedPropValue == null || indexPropValue == null) {
                            return false;
                        }
                        dNextTerminatedValue = nextTerminatedPropValue.doubleValue();
                        dIndexValue = indexPropValue.doubleValue();
                        switch (only.getSortDir()) {
                            case ASC: {
                                double endWindow = dNextTerminatedValue + window.getEndValue().doubleValue();
                                if (!(dIndexValue > endWindow)) break;
                                return false;
                            }
                            case DESC: {
                                double endWindow = dNextTerminatedValue - window.getEndValue().doubleValue();
                                if (!(dIndexValue < endWindow)) break;
                                return false;
                            }
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void terminate(int anaIndex, AnalyticAggregator ana, AnalyticContext<?> context) {
        int nextTerminationIndex = context.getTerminatedThroughIndex() + 1;
        AnalyticValue<?> valueToTerminate = context.getListOfValues().get(nextTerminationIndex);
        ana.setValuesForDependentAnalytics(valueToTerminate, context);
        valueToTerminate.setAnalyzedValue(anaIndex, ana, ana.terminate());
        context.incrementTerminatedThroughIndex();
    }

    private void delete(AnalyticAggregator ana, AnalyticContext<?> context) {
        AnalyticValue<?> deleteValue = context.getListOfValues().get(context.getWindowStartIndex());
        Object valueToDelete = deleteValue.getObject();
        ana.delete(valueToDelete);
        context.incrementWindowStartIndex();
    }

    private List<AnalyticAggregator> getAnalyticAggregatorsList() {
        int anaSize = this.myAnalytics.size();
        ArrayList<AnalyticAggregator> aggList = new ArrayList<AnalyticAggregator>(anaSize);
        for (int a = 0; a < anaSize; ++a) {
            AnalyticAggregator archetype = this.myAnalytics.get(a);
            aggList.add((AnalyticAggregator)Aggregator.getAggregator(archetype));
        }
        return aggList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private List<AnalyticAggregator> myAnalytics = null;

        public Builder setAnalytics(List<AnalyticAggregator> analytics) {
            this.myAnalytics = analytics;
            return this;
        }

        public Analytic build() {
            if (this.myAnalytics == null || this.myAnalytics.isEmpty()) {
                throw new IllegalArgumentException("Analytic.Builder: Must supply at least one AnalyticFunction.");
            }
            return new Analytic(this);
        }
    }
}

