/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.exception.AggregatorCreationException;
import net.sf.jagg.exception.ParseException;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.util.AggregatorCache;
import net.sf.jagg.util.MethodCache;

public abstract class Aggregator
implements AggregateFunction {
    public static final String PROP_SELF = ".";
    private static final MethodCache myMethodCache = MethodCache.getMethodCache();
    private static final AggregatorCache myAggregatorCache = new AggregatorCache();
    private String myProperty;
    private boolean amIInUse = false;

    protected Aggregator() {
    }

    public static AggregateFunction getAggregator(AggregateFunction archetype) {
        return myAggregatorCache.getFunction(archetype);
    }

    public static AggregateFunction getAggregator(String aggSpec) {
        int leftParenIdx = aggSpec.indexOf("(");
        int rightParenIdx = aggSpec.lastIndexOf(")");
        if (leftParenIdx == -1 || rightParenIdx == -1 || leftParenIdx > rightParenIdx) {
            throw new ParseException("Malformed Aggregator specification: " + aggSpec);
        }
        String aggName = aggSpec.substring(0, leftParenIdx);
        if (aggName.indexOf(PROP_SELF) == -1) {
            aggName = Aggregator.class.getPackage().getName() + PROP_SELF + aggName;
        }
        if (!aggName.endsWith("Aggregator")) {
            aggName = aggName + "Aggregator";
        }
        String property = aggSpec.substring(leftParenIdx + 1, rightParenIdx);
        try {
            Class<?> aggClass = Class.forName(aggName);
            Constructor<?> ctor = aggClass.getConstructor(String.class);
            return (AggregateFunction)ctor.newInstance(property);
        }
        catch (ClassNotFoundException e) {
            throw new AggregatorCreationException("Unknown AggregateFunction class \"" + aggName + "\".", e);
        }
        catch (NoSuchMethodException e) {
            throw new AggregatorCreationException("Can't find constructor for AggregateFunction class \"" + aggName + "\" that contains exactly one String parameter.", e);
        }
        catch (InstantiationException e) {
            throw new AggregatorCreationException("AggregateFunction specified is not a concrete class: \"" + aggName + "\".", e);
        }
        catch (IllegalAccessException e) {
            throw new AggregatorCreationException("Unable to construct AggregateFunction \"" + aggName + "\".", e);
        }
        catch (InvocationTargetException e) {
            throw new AggregatorCreationException("Exception caught instantiating AggregateFunction \"" + aggName + "\": " + e.getCause().getClass().getName(), e);
        }
        catch (ClassCastException e) {
            throw new AggregatorCreationException("Class found is not an AggregateFunction: \"" + aggName + "\".", e);
        }
    }

    public static Object getValueFromProperty(Object value, String property) {
        return myMethodCache.getValueFromProperty(value, property);
    }

    protected void setProperty(String property) {
        this.myProperty = property;
    }

    public final boolean isInUse() {
        return this.amIInUse;
    }

    public final void setInUse(boolean inUse) {
        this.amIInUse = inUse;
    }

    public abstract AggregateFunction replicate();

    public abstract void init();

    public abstract void iterate(Object var1);

    public abstract void merge(AggregateFunction var1);

    public abstract Object terminate();

    public DoubleDouble terminateDoubleDouble() {
        return DoubleDouble.NaN;
    }

    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass()) && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getProperty() {
        return this.myProperty;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getProperty() + ")";
    }
}

