/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.AggregateRunner;
import net.sf.jagg.Aggregations;
import net.sf.jagg.Aggregator;
import net.sf.jagg.exception.JaggException;
import net.sf.jagg.model.AggregateValue;
import net.sf.jagg.model.PositionedAggregatorList;
import net.sf.jagg.msd.Discriminators;
import net.sf.jagg.msd.MsdWorkspace;
import net.sf.jagg.msd.PropertiesDiscriminator;
import net.sf.jagg.util.AggregateValuePropertiesComparator;
import net.sf.jagg.util.ComparableComparator;
import net.sf.jagg.util.PropertiesComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregation {
    private static final boolean DEBUG = false;
    private static ThreadPoolExecutor theThreadPool = null;
    private List<AggregateFunction> myAggregators;
    private List<String> myProperties;
    private int myParallelism;
    private boolean amIUsingMsd;
    private MsdWorkspace myWorkspace;
    private List<List<Integer>> myGroupingSets;
    private boolean amIUsingSuperAggregation;

    private Aggregation(Builder builder) {
        this.myAggregators = builder.myAggregators;
        this.myProperties = builder.myProperties;
        this.myParallelism = builder.myParallelism;
        this.amIUsingMsd = builder.amIUsingMsd;
        this.myGroupingSets = builder.myGroupingSets;
        this.amIUsingSuperAggregation = builder.amIUsingSuperAggregation;
    }

    public <T extends Comparable<? super T>> List<AggregateValue<T>> groupByComparable(List<T> values) {
        ArrayList<T> listCopy = new ArrayList<T>(values);
        ComparableComparator comparator = new ComparableComparator();
        Collections.sort(listCopy, comparator);
        return this.doAggregation(listCopy, comparator);
    }

    public <T> List<AggregateValue<T>> groupBy(List<T> values) {
        if (values.size() == 0 && this.myProperties.size() == 0) {
            return this.getEmptyAggregateValues();
        }
        PropertiesDiscriminator<T> disc = new PropertiesDiscriminator<T>(this.myProperties);
        PropertiesComparator comparator = new PropertiesComparator(this.myProperties);
        List<T> listCopy = null;
        if (this.myProperties.size() > 0) {
            if (this.amIUsingMsd) {
                List<List<T>> listOfLists;
                if (this.myWorkspace == null) {
                    this.myWorkspace = new MsdWorkspace();
                }
                if ((listOfLists = disc.discriminate(values, this.myWorkspace)) != null) {
                    listCopy = Discriminators.getFlattenedList(listOfLists);
                }
            }
            if (listCopy == null) {
                listCopy = new ArrayList<T>(values);
                Collections.sort(listCopy, comparator);
            }
        } else {
            listCopy = values;
        }
        return this.doAggregation(listCopy, comparator);
    }

    private <T> List<AggregateValue<T>> doAggregation(List<T> listCopy, Comparator<? super T> comparator) {
        int size = listCopy.size();
        int minParallelism = this.myParallelism > size ? size : this.myParallelism;
        List<AggregateValue<T>> aggregatedList = minParallelism > 1 ? this.getAggregateValues(listCopy, comparator, this.myParallelism) : this.getAggregateValues(listCopy, comparator);
        if (this.amIUsingSuperAggregation) {
            this.getSuperAggregateValues(aggregatedList);
        }
        return aggregatedList;
    }

    private static <T> ExecutorCompletionService<PositionedAggregatorList<T>> initializeService() {
        if (theThreadPool == null) {
            int numProcessors = Runtime.getRuntime().availableProcessors();
            theThreadPool = new ThreadPoolExecutor(0, numProcessors, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        }
        return new ExecutorCompletionService<PositionedAggregatorList<T>>(theThreadPool);
    }

    private <T> List<AggregateValue<T>> getAggregateValues(List<T> list, Comparator<? super T> comparator, int parallelism) {
        ArrayList listOfPals = new ArrayList(parallelism);
        for (int p = 0; p < parallelism; ++p) {
            listOfPals.add(null);
        }
        ExecutorCompletionService<PositionedAggregatorList<T>> service = Aggregation.initializeService();
        int size = list.size();
        for (int p = 0; p < parallelism; ++p) {
            int startIndex = size * p / parallelism;
            int endIndex = size * (p + 1) / parallelism - 1;
            service.submit(new AggregateRunner<T>(this.myAggregators, list, p, comparator, startIndex, endIndex, this.amIUsingSuperAggregation, this.myProperties));
        }
        int numPALs = 0;
        while (numPALs < parallelism) {
            try {
                Future<PositionedAggregatorList<T>> future = service.poll(1L, TimeUnit.SECONDS);
                if (future == null) continue;
                PositionedAggregatorList<T> pal = future.get();
                listOfPals.set(pal.getPosition(), pal);
                ++numPALs;
            }
            catch (InterruptedException ignored) {
            }
            catch (ExecutionException e) {
                throw new JaggException(e.getClass().getName() + " caught while aggregating.", e);
            }
        }
        return Aggregations.mergeLists(listOfPals, comparator, this.amIUsingSuperAggregation, this.myProperties);
    }

    private <T> List<AggregateValue<T>> getAggregateValues(List<T> list, Comparator<? super T> comparator) {
        ArrayList<AggregateValue<T>> aggValues = new ArrayList<AggregateValue<T>>();
        List<AggregateFunction> aggList = this.getAggregatorsList();
        int aggSize = this.myAggregators.size();
        int startIndex = 0;
        int listsize = list.size();
        int numProperties = this.myProperties != null ? this.myProperties.size() : 0;
        ArrayList<Integer> defaultGroupingSet = new ArrayList<Integer>(numProperties);
        for (int i = 0; i < numProperties; ++i) {
            defaultGroupingSet.add(i);
        }
        while (startIndex < listsize) {
            AggregateFunction agg;
            int a;
            AggregateValue<T> aggValue = new AggregateValue<T>(list.get(startIndex));
            int endIndex = Aggregations.indexOfLastMatching(list, comparator, startIndex);
            if (this.amIUsingSuperAggregation && startIndex > 0) {
                aggList = this.getAggregatorsList();
            }
            for (a = 0; a < aggSize; ++a) {
                agg = aggList.get(a);
                agg.init();
            }
            for (int i = startIndex; i <= endIndex; ++i) {
                T value = list.get(i);
                for (int a2 = 0; a2 < aggSize; ++a2) {
                    AggregateFunction agg2 = aggList.get(a2);
                    agg2.iterate(value);
                }
            }
            for (a = 0; a < aggSize; ++a) {
                agg = aggList.get(a);
                aggValue.setAggregateValue(agg, agg.terminate());
            }
            if (this.myProperties != null) {
                aggValue.assignPropsAndGroupingSet(this.myProperties, defaultGroupingSet);
            }
            if (this.amIUsingSuperAggregation) {
                aggValue.assignAggregators(aggList);
            }
            aggValues.add(aggValue);
            startIndex = endIndex + 1;
        }
        if (!this.amIUsingSuperAggregation) {
            for (int a = 0; a < aggSize; ++a) {
                AggregateFunction agg = aggList.get(a);
                agg.setInUse(false);
            }
        }
        return aggValues;
    }

    private List<AggregateFunction> getAggregatorsList() {
        int aggSize = this.myAggregators.size();
        ArrayList<AggregateFunction> aggList = new ArrayList<AggregateFunction>(aggSize);
        for (int a = 0; a < aggSize; ++a) {
            AggregateFunction archetype = this.myAggregators.get(a);
            aggList.add(Aggregator.getAggregator(archetype));
        }
        return aggList;
    }

    private <T> List<AggregateValue<T>> getEmptyAggregateValues() {
        ArrayList<AggregateValue<T>> aggValues = new ArrayList<AggregateValue<T>>(1);
        ArrayList<AggregateFunction> aggList = new ArrayList<AggregateFunction>(this.myAggregators.size());
        int aggSize = this.myAggregators.size();
        for (int a = 0; a < aggSize; ++a) {
            AggregateFunction archetype = this.myAggregators.get(a);
            aggList.add(Aggregator.getAggregator(archetype));
        }
        AggregateValue<Object> aggValue = new AggregateValue<Object>((Object)null);
        for (int a = 0; a < aggSize; ++a) {
            AggregateFunction agg = (AggregateFunction)aggList.get(a);
            agg.init();
            aggValue.setAggregateValue(agg, agg.terminate());
            agg.setInUse(false);
        }
        aggValues.add(aggValue);
        return aggValues;
    }

    private <T> void getSuperAggregateValues(List<AggregateValue<T>> aggValues) {
        boolean includeOrigAggValues = false;
        HashMap<Integer, Integer> chainedGroupingSets = new HashMap<Integer, Integer>();
        int numGroupingSets = this.myGroupingSets.size();
        int numProperties = this.myProperties.size();
        for (int i = 0; i < numGroupingSets; ++i) {
            int j;
            List<Integer> groupingSet = this.myGroupingSets.get(i);
            for (j = i - 1; j >= 0; --j) {
                List<Integer> candidateSet = this.myGroupingSets.get(j);
                if (!candidateSet.containsAll(groupingSet)) continue;
                chainedGroupingSets.put(i, j);
                break;
            }
            if (j != -1) continue;
            chainedGroupingSets.put(i, -1);
        }
        int start = 0;
        if (this.myGroupingSets.get(0).size() == numProperties) {
            includeOrigAggValues = true;
            start = 1;
        }
        TreeMap<Integer, List> aggValuesByGroupingSet = new TreeMap<Integer, List>();
        if (includeOrigAggValues) {
            aggValuesByGroupingSet.put(0, aggValues);
        }
        for (int g = start; g < numGroupingSets; ++g) {
            int prevIndex = (Integer)chainedGroupingSets.get(g);
            List useValues = prevIndex == -1 ? aggValues : (List)aggValuesByGroupingSet.get(prevIndex);
            List<Integer> groupingSet = this.myGroupingSets.get(g);
            ArrayList<String> properties = new ArrayList<String>();
            for (int propIndex : groupingSet) {
                properties.add(this.myProperties.get(propIndex));
            }
            AggregateValuePropertiesComparator comparator = new AggregateValuePropertiesComparator(properties);
            Collections.sort(useValues, comparator);
            ArrayList superAggValues = new ArrayList();
            int aggSize = this.myAggregators.size();
            int startIndex = 0;
            int listsize = useValues.size();
            while (startIndex < listsize) {
                AggregateFunction agg;
                int a;
                AggregateValue superAggValue = new AggregateValue((AggregateValue)useValues.get(startIndex));
                int endIndex = Aggregations.indexOfLastMatching(useValues, comparator, startIndex);
                List<AggregateFunction> superAggList = this.getAggregatorsList();
                for (a = 0; a < aggSize; ++a) {
                    agg = superAggList.get(a);
                    agg.init();
                }
                for (int i = startIndex; i <= endIndex; ++i) {
                    AggregateValue baseValue = (AggregateValue)useValues.get(i);
                    List<AggregateFunction> baseAggs = baseValue.retrieveAggregators();
                    for (int a2 = 0; a2 < aggSize; ++a2) {
                        AggregateFunction agg2 = superAggList.get(a2);
                        agg2.merge(baseAggs.get(a2));
                    }
                }
                for (a = 0; a < aggSize; ++a) {
                    agg = superAggList.get(a);
                    superAggValue.setAggregateValue(agg, agg.terminate());
                }
                superAggValue.assignAggregators(superAggList);
                superAggValue.assignPropsAndGroupingSet(this.myProperties, groupingSet);
                superAggValues.add(superAggValue);
                startIndex = endIndex + 1;
            }
            aggValuesByGroupingSet.put(g, superAggValues);
        }
        for (AggregateValue<T> aggValue : aggValues) {
            aggValue.releaseAggregators();
        }
        Iterator<AggregateValue<Object>> i$ = aggValuesByGroupingSet.keySet().iterator();
        while (i$.hasNext()) {
            int groupingSetIndex = (Integer)((Object)i$.next());
            for (AggregateValue superAggValue : (List)aggValuesByGroupingSet.get(groupingSetIndex)) {
                superAggValue.releaseAggregators();
            }
        }
        if (!includeOrigAggValues) {
            aggValues.clear();
        }
        i$ = aggValuesByGroupingSet.keySet().iterator();
        while (i$.hasNext()) {
            int groupingSetIndex = (Integer)((Object)i$.next());
            if (groupingSetIndex == 0 && includeOrigAggValues) continue;
            List groupAggValues = (List)aggValuesByGroupingSet.get(groupingSetIndex);
            aggValues.addAll(groupAggValues);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private List<AggregateFunction> myAggregators = null;
        private List<String> myProperties = null;
        private int myParallelism = 1;
        private boolean amIUsingMsd = false;
        private List<List<Integer>> myGroupingSets = null;
        private boolean amIUsingSuperAggregation = false;

        public Builder setAggregators(List<AggregateFunction> aggregators) {
            this.myAggregators = aggregators;
            return this;
        }

        public Builder setProperties(List<String> properties) {
            this.myProperties = properties;
            this.amIUsingSuperAggregation = false;
            this.createDefaultGroupingSet();
            return this;
        }

        public Builder setParallelism(int parallelism) {
            if (parallelism < 1) {
                parallelism = 1;
            }
            if (parallelism > 1) {
                int numProcessors = Runtime.getRuntime().availableProcessors();
                parallelism = parallelism > numProcessors ? numProcessors : parallelism;
            }
            this.myParallelism = parallelism;
            return this;
        }

        public Builder setUseMsd(boolean useMsd) {
            this.amIUsingMsd = useMsd;
            return this;
        }

        public Builder setGroupingSets(List<List<Integer>> groupingSets) {
            if (this.myProperties == null && groupingSets != null) {
                throw new IllegalArgumentException("Grouping sets without group-by properties.");
            }
            if (groupingSets == null || groupingSets.isEmpty()) {
                this.createDefaultGroupingSet();
                return this;
            }
            this.myGroupingSets = this.validateGroupingSets(groupingSets);
            return this;
        }

        public Builder setRollup(List<Integer> rollup) {
            return this.setRollups(Collections.singletonList(rollup));
        }

        public Builder setRollups(List<List<Integer>> rollups) {
            this.validateSpecialSets(rollups);
            ArrayList<List<Integer>> groupingSets = new ArrayList<List<Integer>>();
            groupingSets.add(this.createDefaultGroupingSet());
            this.findRollups(groupingSets, rollups);
            return this.setGroupingSets(groupingSets);
        }

        public Builder setCube(List<Integer> cube) {
            this.validateSpecialSets(Collections.singletonList(cube));
            ArrayList<List<Integer>> groupingSets = new ArrayList<List<Integer>>();
            groupingSets.add(this.createDefaultGroupingSet());
            this.findCubes(groupingSets, cube);
            return this.setGroupingSets(groupingSets);
        }

        public Aggregation build() {
            if (this.myAggregators == null || this.myAggregators.isEmpty()) {
                throw new IllegalArgumentException("Aggregation.Builder: Must supply at least one AggregateFunction.");
            }
            return new Aggregation(this);
        }

        private void findRollups(List<List<Integer>> groupingSets, List<List<Integer>> rollups) {
            if (rollups.isEmpty()) {
                return;
            }
            List<Integer> rollup = rollups.get(0);
            int rollupSize = rollup.size();
            ArrayList<ArrayList<Integer>> newGroupingSets = new ArrayList<ArrayList<Integer>>();
            for (int i = rollupSize - 1; i >= 0; --i) {
                List<Integer> remove = rollup.subList(i, rollupSize);
                for (List<Integer> groupingSet : groupingSets) {
                    ArrayList<Integer> newGroupingSet = new ArrayList<Integer>(groupingSet);
                    newGroupingSet.removeAll(remove);
                    newGroupingSets.add(newGroupingSet);
                }
            }
            groupingSets.addAll(newGroupingSets);
            this.findRollups(groupingSets, rollups.subList(1, rollups.size()));
        }

        private void findCubes(List<List<Integer>> groupingSets, List<Integer> cube) {
            if (cube.isEmpty()) {
                return;
            }
            int numCubes = cube.size();
            int numCombinations = 1 << numCubes;
            List<Integer> defGroupingSet = groupingSets.get(0);
            ArrayList<Integer> remove = new ArrayList<Integer>();
            for (int i = 1; i < numCombinations; ++i) {
                remove.clear();
                int b = 0;
                int bit = 1;
                while (b < numCubes) {
                    if ((i & bit) > 0) {
                        remove.add(cube.get(b));
                    }
                    ++b;
                    bit <<= 1;
                }
                ArrayList<Integer> combo = new ArrayList<Integer>(defGroupingSet);
                combo.removeAll(remove);
                groupingSets.add(combo);
            }
        }

        private List<Integer> createDefaultGroupingSet() {
            int numProperties = this.myProperties.size();
            ArrayList<Integer> groupingSet = new ArrayList<Integer>(numProperties);
            for (int i = 0; i < numProperties; ++i) {
                groupingSet.add(i);
            }
            return groupingSet;
        }

        private void validateSpecialSets(List<List<Integer>> specials) {
            int numProperties = this.myProperties.size();
            int fieldMask = 0;
            for (List<Integer> special : specials) {
                for (int field : special) {
                    if (field < 0 || field >= numProperties) {
                        throw new IllegalArgumentException("Grouping set field index out of range: " + field);
                    }
                    int bit = 1 << field;
                    if ((fieldMask & bit) != 0) {
                        throw new IllegalArgumentException("Can't specify same field more than once in any cube/rollup set: " + field);
                    }
                    fieldMask |= bit;
                }
            }
        }

        private List<List<Integer>> validateGroupingSets(List<List<Integer>> groupingSets) {
            int numProperties = this.myProperties.size();
            ArrayList<List<Integer>> groupingSetsCopy = new ArrayList<List<Integer>>(groupingSets);
            for (List list : groupingSetsCopy) {
                List otherGroupingSet;
                if (list.size() != numProperties) {
                    this.amIUsingSuperAggregation = true;
                }
                int fieldMask = 0;
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    int field = (Integer)i$.next();
                    if (field < 0 || field >= numProperties) {
                        throw new IllegalArgumentException("Grouping set field index out of range: " + field);
                    }
                    int bit = 1 << field;
                    if ((fieldMask & bit) != 0) {
                        throw new IllegalArgumentException("Can't specify same field more than once in a grouping set: " + field);
                    }
                    fieldMask |= bit;
                }
                i$ = groupingSetsCopy.iterator();
                while (i$.hasNext() && (otherGroupingSet = (List)i$.next()) != list) {
                    int otherField;
                    if (otherGroupingSet.size() != list.size()) continue;
                    HashSet fields = new HashSet(list);
                    Iterator i$2 = otherGroupingSet.iterator();
                    while (i$2.hasNext() && fields.remove(otherField = ((Integer)i$2.next()).intValue())) {
                    }
                    if (!fields.isEmpty()) continue;
                    throw new IllegalArgumentException("Duplicate grouping sets found: " + list.toString() + " and " + otherGroupingSet.toString());
                }
                Collections.sort(list);
            }
            Collections.sort(groupingSetsCopy, new Comparator<List<Integer>>(){

                @Override
                public int compare(List<Integer> list1, List<Integer> list2) {
                    return list2.size() - list1.size();
                }
            });
            return groupingSetsCopy;
        }
    }
}

