/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.MultiPropAggregator;
import net.sf.jagg.exception.ParseException;
import net.sf.jagg.model.WindowClause;
import net.sf.jagg.util.PropertyParser;

public abstract class AbstractOffsetAnalytic
extends MultiPropAggregator
implements AnalyticFunction {
    private int myOffset;
    private Object myDefaultValue;
    private Object myCurrentValue;

    protected AbstractOffsetAnalytic(String properties) {
        this.setProperty(properties);
    }

    protected AbstractOffsetAnalytic(String property, int offset) {
        this(property, offset, null);
    }

    protected AbstractOffsetAnalytic(String property, int offset, Object defaultValue) {
        this(property + ", " + offset + (defaultValue != null ? ", " + defaultValue : ""));
    }

    public void setProperty(String properties) {
        super.setProperty(properties);
        int numProperties = this.getNumProperties();
        switch (numProperties) {
            case 1: {
                this.myOffset = this.getDefaultOffset();
                this.myDefaultValue = null;
                break;
            }
            case 2: {
                this.extractOffset();
                this.myDefaultValue = null;
                break;
            }
            case 3: {
                this.extractOffset();
                this.extractDefaultValue();
                break;
            }
            default: {
                throw new ParseException("Properties must be in the format \"(property [, offset [, defaultValue]])\"");
            }
        }
    }

    protected void extractOffset() {
        try {
            this.myOffset = Integer.parseInt(this.getProperty(1).trim());
        }
        catch (NumberFormatException e) {
            throw new ParseException("Offset must be an integer: " + this.getProperty(1), e);
        }
    }

    protected void extractDefaultValue() {
        String text = this.getProperty(2).trim();
        this.myDefaultValue = text.startsWith("\"") && text.endsWith("\"") ? PropertyParser.getTypedParameter(text.substring(1, text.length() - 1), true) : PropertyParser.getTypedParameter(text, false);
    }

    protected int getDefaultOffset() {
        return 1;
    }

    protected int getOffset() {
        return this.myOffset;
    }

    protected Object getDefaultValue() {
        return this.myDefaultValue;
    }

    public void init() {
        this.myCurrentValue = this.myDefaultValue;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            this.myCurrentValue = AbstractOffsetAnalytic.getValueFromProperty(value, property);
        }
    }

    public void delete(Object value) {
        String property;
        Object obj;
        if (value != null && ((obj = AbstractOffsetAnalytic.getValueFromProperty(value, property = this.getProperty())) == null && this.myCurrentValue == null || obj != null && (obj == this.myCurrentValue || obj.equals(this.myCurrentValue)))) {
            this.myCurrentValue = this.myDefaultValue;
        }
    }

    public boolean takesWindowClause() {
        return false;
    }

    public abstract WindowClause getWindowClause();

    public void merge(AggregateFunction agg) {
        throw new UnsupportedOperationException("Merge not implemented!");
    }

    public Object terminate() {
        return this.myCurrentValue;
    }
}

