/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.threads.TimingPauser;

public abstract class AbstractTSQueueLock
implements Closeable {
    protected static final long UNLOCKED = Long.MIN_VALUE;
    protected final LongValue lock;
    protected final TimingPauser pauser;
    protected final File path;
    protected final TableStore tableStore;

    public AbstractTSQueueLock(String lockKey, TableStore<?> tableStore, Supplier<TimingPauser> pauser) {
        this.tableStore = tableStore;
        this.lock = tableStore.doWithExclusiveLock(ts -> ts.acquireValueFor(lockKey));
        this.pauser = pauser.get();
        this.path = tableStore.file();
    }

    public void close() {
        Closeable.closeQuietly((Object)this.lock);
    }

    protected void closeCheck() {
        if (this.tableStore.isClosed()) {
            throw new IllegalStateException("Underlying TableStore is already closed - was the Queue closed?");
        }
    }

    protected void forceUnlock() {
        Jvm.warn().on(this.getClass(), "Forced unlock for the lock file:" + this.path, (Throwable)new Exception());
        this.lock.setValue(Long.MIN_VALUE);
    }
}

