/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.util.exif.ExifFilterUtils;
import net.coobird.thumbnailator.util.exif.ExifUtils;
import net.coobird.thumbnailator.util.exif.Orientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamImageSource
extends AbstractImageSource<InputStream> {
    private static final int FIRST_IMAGE_INDEX = 0;
    private InputStream is;

    public InputStreamImageSource(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("InputStream cannot be null.");
        }
        this.is = !Boolean.getBoolean("thumbnailator.disableExifWorkaround") ? new ExifCaptureInputStream(inputStream) : inputStream;
    }

    @Override
    public void setThumbnailParameter(ThumbnailParameter thumbnailParameter) {
        super.setThumbnailParameter(thumbnailParameter);
        if ((thumbnailParameter == null || !thumbnailParameter.useExifOrientation()) && this.is instanceof ExifCaptureInputStream) {
            this.is = ((ExifCaptureInputStream)this.is).is;
        }
    }

    @Override
    public BufferedImage read() throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.is);
        if (imageInputStream == null) {
            throw new IOException("Could not open InputStream.");
        }
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            imageInputStream.close();
            throw new UnsupportedFormatException("<unknown>", "No suitable ImageReader found for source data.");
        }
        ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream);
        boolean bl = false;
        try {
            BufferedImage bufferedImage = this.readImage(imageReader);
            BufferedImage bufferedImage2 = this.finishedReading(bufferedImage);
            return bufferedImage2;
        }
        catch (IOException iOException) {
            bl = true;
            throw iOException;
        }
        finally {
            block11: {
                imageReader.dispose();
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {
                    if (bl) break block11;
                    throw iOException;
                }
            }
        }
    }

    private BufferedImage readImage(ImageReader imageReader) throws IOException {
        int n;
        Object object;
        block15: {
            try {
                Object object2;
                if (!this.param.useExifOrientation()) break block15;
                object = null;
                n = 0;
                try {
                    object = ExifUtils.getExifOrientation(imageReader, 0);
                }
                catch (Exception exception) {
                    n = 1;
                }
                if (n != 0 && this.is instanceof ExifCaptureInputStream && (object2 = ((ExifCaptureInputStream)this.is).getExifData()) != null) {
                    object = ExifUtils.getOrientationFromExif((byte[])object2);
                }
                if (object != null && object != Orientation.TOP_LEFT) {
                    object2 = this.param.getImageFilters();
                    object2.add(0, ExifFilterUtils.getFilterForOrientation((Orientation)((Object)object)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inputFormatName = imageReader.getFormatName();
        object = imageReader.getDefaultReadParam();
        n = imageReader.getWidth(0);
        int n2 = imageReader.getHeight(0);
        if (this.param != null && this.param.getSourceRegion() != null) {
            Region region = this.param.getSourceRegion();
            Rectangle rectangle = region.calculate(n, n2);
            ((IIOParam)object).setSourceRegion(rectangle);
        }
        if (this.param != null && Boolean.getBoolean("thumbnailator.conserveMemoryWorkaround") && n > 1800 && n2 > 1800 && (long)(n * n2) * 4L > Runtime.getRuntime().freeMemory() / 4L) {
            int n3 = 1;
            if (this.param.getSize() != null && this.param.getSize().width * 2 < n && this.param.getSize().height * 2 < n2) {
                int n4 = this.param.getSize().width;
                int n5 = this.param.getSize().height;
                n4 = n4 != Integer.MAX_VALUE ? n4 : n5;
                n5 = n5 != Integer.MAX_VALUE ? n5 : n4;
                double d = (double)n / (double)n4;
                double d2 = (double)n2 / (double)n5;
                n3 = (int)Math.floor(Math.min(d, d2));
            } else if (this.param.getSize() == null) {
                n3 = (int)Math.max(1.0, Math.floor(1.0 / Math.max(this.param.getHeightScalingFactor(), this.param.getWidthScalingFactor())));
            }
            while (n / n3 < 600 || n2 / n3 < 600) {
                --n3;
            }
            if (this.param.getSize() == null) {
                try {
                    Class<?> clazz = this.param.getClass();
                    Field field = clazz.getDeclaredField("heightScalingFactor");
                    Field field2 = clazz.getDeclaredField("widthScalingFactor");
                    field.setAccessible(true);
                    field2.setAccessible(true);
                    field.set(this.param, this.param.getHeightScalingFactor() * (double)n3);
                    field2.set(this.param, this.param.getWidthScalingFactor() * (double)n3);
                }
                catch (Exception exception) {
                    n3 = 1;
                }
            }
            ((IIOParam)object).setSourceSubsampling(n3, n3, 0, 0);
        }
        return imageReader.read(0, (ImageReadParam)object);
    }

    @Override
    public InputStream getSource() {
        return this.is;
    }

    private static final class ExifCaptureInputStream
    extends InputStream {
        private final InputStream is;
        private boolean doIntercept = true;
        private static final int INTERCEPT_THRESHOLD = 0x100000;
        private byte[] buffer = new byte[0];
        int position = 0;
        int totalRead = 0;
        int remainingSkip = 0;
        private int startApp1 = Integer.MIN_VALUE;
        private int endApp1 = Integer.MAX_VALUE;
        private boolean doCaptureApp1 = false;
        private boolean hasCapturedExif = false;
        private final boolean isDebug = Boolean.getBoolean("thumbnailator.debugLog.exifWorkaround") || Boolean.getBoolean("thumbnailator.debugLog");

        private byte[] getExifData() {
            return this.hasCapturedExif ? this.buffer : null;
        }

        private ExifCaptureInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        private void terminateIntercept() {
            this.doIntercept = false;
            this.buffer = null;
        }

        private void debugln(String string, Object ... objectArray) {
            if (this.isDebug) {
                System.err.printf("[thumbnailator.exifWorkaround] " + string + "%n", objectArray);
            }
        }

        private void debugln(String string, byte[] byArray) {
            if (this.isDebug) {
                this.debugln(string, Arrays.toString(byArray));
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.is.read(byArray, n, n2);
            if (n3 == -1) {
                return n3;
            }
            if (!this.doIntercept) {
                this.debugln("Skip intercept.", new Object[0]);
                return n3;
            }
            if (n != 0) {
                this.debugln("Offset: %s != 0; terminating intercept.", n);
                this.terminateIntercept();
                return n3;
            }
            this.totalRead += n3;
            if (this.totalRead > 0x100000) {
                this.debugln("Exceeded intercept threshold, terminating intercept. %s > %s", this.totalRead, 0x100000);
                this.terminateIntercept();
                return n3;
            }
            this.debugln("Total read: %s", this.totalRead);
            this.debugln("Bytes read: %s", n3);
            byte[] byArray2 = new byte[this.totalRead];
            System.arraycopy(this.buffer, 0, byArray2, 0, Math.min(byArray2.length, this.buffer.length));
            System.arraycopy(byArray, n, byArray2, this.totalRead - n3, n3);
            this.buffer = byArray2;
            this.debugln("Source: %s", byArray);
            this.debugln("Buffer: %s", this.buffer);
            while (this.position < this.totalRead && this.totalRead - this.position >= 2) {
                this.debugln("Start loop, position: %s", this.position);
                if (this.remainingSkip > 0) {
                    this.position += this.remainingSkip;
                    this.remainingSkip = 0;
                    this.debugln("Skip requested, new position: %s", this.position);
                    continue;
                }
                if (this.doCaptureApp1) {
                    if (this.startApp1 + 8 > this.position) {
                        this.debugln("APP1 shorter than expected, terminating intercept.", new Object[0]);
                        this.terminateIntercept();
                        break;
                    }
                    byte[] byArray3 = new byte[4];
                    System.arraycopy(this.buffer, this.startApp1 + 4, byArray3, 0, byArray3.length);
                    if (new String(byArray3).equals("Exif")) {
                        this.debugln("Found Exif!", new Object[0]);
                        this.hasCapturedExif = true;
                        this.doIntercept = false;
                        byte[] byArray4 = new byte[this.endApp1 - (this.startApp1 + 4)];
                        System.arraycopy(this.buffer, this.startApp1 + 4, byArray4, 0, byArray4.length);
                        this.buffer = byArray4;
                        break;
                    }
                    this.debugln("APP1 was not Exif.", new Object[0]);
                    this.hasCapturedExif = false;
                    this.doIntercept = true;
                    this.doCaptureApp1 = false;
                }
                if (this.position == 0 && this.totalRead >= 2) {
                    this.debugln("Check if JPEG. buffer: %s", this.buffer);
                    if (this.buffer[this.position] != -1 || this.buffer[this.position + 1] != -40) {
                        this.debugln("JFIF SOI not found. Not JPEG.", new Object[0]);
                        this.terminateIntercept();
                        break;
                    }
                    this.position += 2;
                    continue;
                }
                this.debugln("Prior to 2-byte section. position: %s, total read: %s", this.position, this.totalRead);
                if (this.position + 2 <= this.totalRead && this.buffer[this.position] == -1) {
                    if (this.buffer[this.position + 1] >= -48 && this.buffer[this.position + 1] <= -41) {
                        this.debugln("Found RSTn marker.", new Object[0]);
                        this.position += 2;
                        continue;
                    }
                    if (this.buffer[this.position + 1] == -38 || this.buffer[this.position + 1] == -39) {
                        this.debugln("Stop scan for Exif. Found: %s, %s", this.buffer[this.position], this.buffer[this.position + 1]);
                        this.terminateIntercept();
                        break;
                    }
                }
                this.debugln("Prior to 4-byte section. position: %s, total read: %s", this.position, this.totalRead);
                if (this.position + 4 <= this.totalRead) {
                    try {
                        if (this.buffer[this.position] == -1) {
                            int n4;
                            if (this.buffer[this.position + 1] == -31) {
                                this.doCaptureApp1 = true;
                                this.startApp1 = this.position;
                                int n5 = ExifCaptureInputStream.getPayloadLength(this.buffer[this.position + 2], this.buffer[this.position + 3]) + 4;
                                this.debugln("Prior to 2-byte section. position: %s, total read: %s", this.position, this.totalRead);
                                this.endApp1 = n4 = n5 + this.position;
                                this.debugln("Found APP1. position: %s, total read: %s, increment by: %s", this.position, this.totalRead, n5);
                                this.debugln("Found APP1. start: %s, end: %s", this.startApp1, this.endApp1);
                                if (n4 > this.totalRead) {
                                    this.remainingSkip = n4 - this.totalRead;
                                    this.position = this.totalRead;
                                    this.debugln("Skip request; remaining skip: %s", this.remainingSkip);
                                    continue;
                                }
                                this.position = n4;
                                this.debugln("No skip needed; new position: %s", n4);
                                continue;
                            }
                            if (this.buffer[1] == -35) {
                                this.debugln("Found DRI.", new Object[0]);
                                this.position += 4;
                                continue;
                            }
                            int n6 = ExifCaptureInputStream.getPayloadLength(this.buffer[this.position + 2], this.buffer[this.position + 3]) + 4;
                            n4 = n6 + this.position;
                            this.debugln("Other 4-byte. position: %s, total read: %s, increment by: %s", this.position, this.totalRead, n6);
                            this.debugln("Other 4-byte. start: %s, end: %s", this.startApp1, this.endApp1);
                            if (n4 > this.totalRead) {
                                this.remainingSkip = n4 - this.totalRead;
                                this.position = this.totalRead;
                                this.debugln("Skip request; remaining skip: %s", this.remainingSkip);
                                continue;
                            }
                            this.position = n4;
                            this.debugln("No skip needed; new position: %s", n4);
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        this.debugln("[Exception] Exception thrown. Terminating intercept.", new Object[0]);
                        this.debugln("[Exception] %s", exception.toString());
                        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                            this.debugln("[Exception] %s", stackTraceElement.toString());
                        }
                        this.terminateIntercept();
                        break;
                    }
                }
                if (this.totalRead <= 6) {
                    this.debugln("Not enough data read. Attempt one additional read.", new Object[0]);
                    break;
                }
                this.terminateIntercept();
                this.debugln("Shouldn't be here. Terminating intercept.", new Object[0]);
                break;
            }
            return n3;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        private static int getPayloadLength(byte by, byte by2) {
            int n = ByteBuffer.wrap(new byte[]{by, by2}).getShort() - 2;
            if (n <= 0) {
                throw new IllegalStateException("Expected a positive payload length, but was " + n);
            }
            return n;
        }
    }
}

