/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserAuthorizationData {
    @SerializedName(value="userAuthorizationId")
    private String userAuthorizationId = null;
    @SerializedName(value="referenceIds")
    private List referenceIds = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="scopes")
    private List<ScopesEnum> scopes = null;
    @SerializedName(value="expireAt")
    private BigDecimal expireAt = null;
    @SerializedName(value="issuedAt")
    private BigDecimal issuedAt = null;

    public UserAuthorizationData userAuthorizationId(String userAuthorizationId) {
        this.userAuthorizationId = userAuthorizationId;
        return this;
    }

    @ApiModelProperty(value="PayPay user reference id")
    public String getUserAuthorizationId() {
        return this.userAuthorizationId;
    }

    public void setUserAuthorizationId(String userAuthorizationId) {
        this.userAuthorizationId = userAuthorizationId;
    }

    public UserAuthorizationData referenceIds(List referenceIds) {
        this.referenceIds = referenceIds;
        return this;
    }

    @ApiModelProperty(value="The id used to identify the user in merchant system")
    public List getReferenceIds() {
        return this.referenceIds;
    }

    public void setReferenceIds(List referenceIds) {
        this.referenceIds = referenceIds;
    }

    public UserAuthorizationData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="User authorization status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public UserAuthorizationData scopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
        return this;
    }

    public UserAuthorizationData addScopesItem(ScopesEnum scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<ScopesEnum>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(value="Scopes of the user authorization")
    public List<ScopesEnum> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
    }

    public UserAuthorizationData expireAt(BigDecimal expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @ApiModelProperty(value="Expiration time in the number of seconds since January 1, 1970, 00:00:00 GTM.")
    public BigDecimal getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(BigDecimal expireAt) {
        this.expireAt = expireAt;
    }

    public UserAuthorizationData issuedAt(BigDecimal issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    @ApiModelProperty(value="Issuing time in the number of seconds since January 1, 1970, 00:00:00 GTM.")
    public BigDecimal getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(BigDecimal issuedAt) {
        this.issuedAt = issuedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAuthorizationData userAuthorizationData = (UserAuthorizationData)o;
        return Objects.equals(this.userAuthorizationId, userAuthorizationData.userAuthorizationId) && Objects.equals(this.referenceIds, userAuthorizationData.referenceIds) && Objects.equals((Object)this.status, (Object)userAuthorizationData.status) && Objects.equals(this.scopes, userAuthorizationData.scopes) && Objects.equals(this.expireAt, userAuthorizationData.expireAt) && Objects.equals(this.issuedAt, userAuthorizationData.issuedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userAuthorizationId, this.referenceIds, this.status, this.scopes, this.expireAt, this.issuedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAuthorizationData {\n");
        sb.append("    userAuthorizationId: ").append(this.toIndentedString(this.userAuthorizationId)).append("\n");
        sb.append("    referenceIds: ").append(this.toIndentedString(this.referenceIds)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    issuedAt: ").append(this.toIndentedString(this.issuedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScopesEnum {
        DIRECT_DEBIT("direct_debit"),
        SHOW_BALANCE("show_balance"),
        TOPUP("topup");

        private String value;

        private ScopesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScopesEnum fromValue(String text) {
            for (ScopesEnum b : ScopesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ScopesEnum> {
            public void write(JsonWriter jsonWriter, ScopesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ScopesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScopesEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

