/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.Instant;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.ne.paypay.model.MoneyAmount;
import jp.ne.paypay.model.RefundState;

public class Refund
extends RefundState {
    @SerializedName(value="merchantRefundId")
    @NotEmpty(message="merchantRefundId is required")
    @Size(max=64, message="maximum 64 characters are allowed for merchantRefundtId")
    private @NotEmpty(message="merchantRefundId is required") @Size(max=64, message="maximum 64 characters are allowed for merchantRefundtId") String merchantRefundId = null;
    @SerializedName(value="paymentId")
    @NotEmpty(message="paymentId is required")
    @Size(max=64, message="mmaximum 64 characters are allowed for paymentId")
    private @NotEmpty(message="paymentId is required") @Size(max=64, message="mmaximum 64 characters are allowed for paymentId") String paymentId = null;
    @SerializedName(value="amount")
    @NotNull(message="amount is required")
    private @NotNull(message="amount is required") MoneyAmount amount = null;
    @SerializedName(value="requestedAt")
    @NotNull(message="requestedAt is required")
    private @NotNull(message="requestedAt is required") Long requestedAt = Instant.now().getEpochSecond();
    @SerializedName(value="reason")
    @Size(max=255, message="maximum 255 characters allowed for reason")
    private @Size(max=255, message="maximum 255 characters allowed for reason") String reason = null;
    @SerializedName(value="assumeMerchant")
    private String assumeMerchant = null;

    public Refund merchantRefundId(String merchantRefundId) {
        this.merchantRefundId = merchantRefundId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantRefundId() {
        return this.merchantRefundId;
    }

    public void setMerchantRefundId(String merchantRefundId) {
        this.merchantRefundId = merchantRefundId;
    }

    public Refund paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public Refund amount(MoneyAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public MoneyAmount getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyAmount amount) {
        this.amount = amount;
    }

    public Refund requestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getRequestedAt() {
        return this.requestedAt;
    }

    public void setRequestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
    }

    public Refund reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Refund assumeMerchant(String assumeMerchant) {
        this.assumeMerchant = assumeMerchant;
        return this;
    }

    @ApiModelProperty(value="")
    public String getAssumeMerchant() {
        return this.assumeMerchant;
    }

    public void setAssumeMerchant(String assumeMerchant) {
        this.assumeMerchant = assumeMerchant;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Refund refund = (Refund)o;
        return Objects.equals(this.merchantRefundId, refund.merchantRefundId) && Objects.equals(this.paymentId, refund.paymentId) && Objects.equals(this.amount, refund.amount) && Objects.equals(this.requestedAt, refund.requestedAt) && Objects.equals(this.reason, refund.reason) && Objects.equals(this.assumeMerchant, refund.assumeMerchant) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.merchantRefundId, this.paymentId, this.amount, this.requestedAt, this.reason, this.assumeMerchant, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Refund {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    merchantRefundId: ").append(this.toIndentedString(this.merchantRefundId)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    requestedAt: ").append(this.toIndentedString(this.requestedAt)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    assumeMerchant: ").append(this.toIndentedString(this.assumeMerchant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

