/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jp.ne.paypay.model.MerchantOrderItemResponse;
import jp.ne.paypay.model.MoneyAmount;

public class QRCodeResponse {
    @SerializedName(value="codeId")
    private String codeId = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="deeplink")
    private String deeplink = null;
    @SerializedName(value="expiryDate")
    private Integer expiryDate = null;
    @SerializedName(value="merchantPaymentId")
    private String merchantPaymentId = null;
    @SerializedName(value="amount")
    private MoneyAmount amount = null;
    @SerializedName(value="orderDescription")
    private String orderDescription = null;
    @SerializedName(value="orderItems")
    private List<MerchantOrderItemResponse> orderItems = null;
    @SerializedName(value="metadata")
    private Object metadata = null;
    @SerializedName(value="codeType")
    private String codeType = null;
    @SerializedName(value="storeInfo")
    private String storeInfo = null;
    @SerializedName(value="storeId")
    private String storeId = null;
    @SerializedName(value="terminalId")
    private String terminalId = null;
    @SerializedName(value="requestedAt")
    private Long requestedAt = null;
    @SerializedName(value="redirectUrl")
    private String redirectUrl = null;
    @SerializedName(value="redirectType")
    private RedirectTypeEnum redirectType = null;
    @SerializedName(value="isAuthorization")
    private Boolean isAuthorization = null;
    @SerializedName(value="authorizationExpiry")
    private Integer authorizationExpiry = null;
    @SerializedName(value="amountescription")
    private String amountDescription = null;
    @SerializedName(value="userAgent")
    private String userAgent = null;

    public QRCodeResponse codeId(String codeId) {
        this.codeId = codeId;
        return this;
    }

    @ApiModelProperty(value="The Id of the Code")
    public String getCodeId() {
        return this.codeId;
    }

    public void setCodeId(String codeId) {
        this.codeId = codeId;
    }

    public QRCodeResponse url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="The url to open webpage (will open app if app installed)")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public QRCodeResponse deeplink(String deeplink) {
        this.deeplink = deeplink;
        return this;
    }

    @ApiModelProperty(value="App Deeplink to invoke (Not needed in this flow)")
    public String getDeeplink() {
        return this.deeplink;
    }

    public void setDeeplink(String deeplink) {
        this.deeplink = deeplink;
    }

    public QRCodeResponse expiryDate(Integer expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Integer expiryDate) {
        this.expiryDate = expiryDate;
    }

    public QRCodeResponse merchantPaymentId(String merchantPaymentId) {
        this.merchantPaymentId = merchantPaymentId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantPaymentId() {
        return this.merchantPaymentId;
    }

    public void setMerchantPaymentId(String merchantPaymentId) {
        this.merchantPaymentId = merchantPaymentId;
    }

    public QRCodeResponse amount(MoneyAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public MoneyAmount getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyAmount amount) {
        this.amount = amount;
    }

    public QRCodeResponse orderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
        return this;
    }

    @ApiModelProperty(value="Description of the order")
    public String getOrderDescription() {
        return this.orderDescription;
    }

    public void setOrderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
    }

    public QRCodeResponse orderItems(List<MerchantOrderItemResponse> orderItems) {
        this.orderItems = orderItems;
        return this;
    }

    public QRCodeResponse addOrderItemsItem(MerchantOrderItemResponse orderItemsItem) {
        if (this.orderItems == null) {
            this.orderItems = new ArrayList<MerchantOrderItemResponse>();
        }
        this.orderItems.add(orderItemsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<MerchantOrderItemResponse> getOrderItems() {
        return this.orderItems;
    }

    public void setOrderItems(List<MerchantOrderItemResponse> orderItems) {
        this.orderItems = orderItems;
    }

    public QRCodeResponse metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Extra information the merchant want to add")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public QRCodeResponse codeType(String codeType) {
        this.codeType = codeType;
        return this;
    }

    @ApiModelProperty(value="Please pass the fixed string ORDER_QR")
    public String getCodeType() {
        return this.codeType;
    }

    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    public QRCodeResponse storeInfo(String storeInfo) {
        this.storeInfo = storeInfo;
        return this;
    }

    @ApiModelProperty(value="Store info for the merchant")
    public String getStoreInfo() {
        return this.storeInfo;
    }

    public void setStoreInfo(String storeInfo) {
        this.storeInfo = storeInfo;
    }

    public QRCodeResponse storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="Id to identify store under merchant")
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public QRCodeResponse terminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    @ApiModelProperty(value="Id to identify terminal device under store")
    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public QRCodeResponse requestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getRequestedAt() {
        return this.requestedAt;
    }

    public void setRequestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
    }

    public QRCodeResponse redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @ApiModelProperty(value="The url of redirect after complete the payment")
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public QRCodeResponse redirectType(RedirectTypeEnum redirectType) {
        this.redirectType = redirectType;
        return this;
    }

    @ApiModelProperty(value="The type of redirect after complete the payment")
    public RedirectTypeEnum getRedirectType() {
        return this.redirectType;
    }

    public void setRedirectType(RedirectTypeEnum redirectType) {
        this.redirectType = redirectType;
    }

    public QRCodeResponse isAuthorization(Boolean isAuthorization) {
        this.isAuthorization = isAuthorization;
        return this;
    }

    @ApiModelProperty(value="If the payment is an authorization.")
    public Boolean isIsAuthorization() {
        return this.isAuthorization;
    }

    public void setIsAuthorization(Boolean isAuthorization) {
        this.isAuthorization = isAuthorization;
    }

    public QRCodeResponse authorizationExpiry(Integer authorizationExpiry) {
        this.authorizationExpiry = authorizationExpiry;
        return this;
    }

    @ApiModelProperty(value="In case the payment is just an authorization, this defines the expiry of the authorization")
    public Integer getAuthorizationExpiry() {
        return this.authorizationExpiry;
    }

    public void setAuthorizationExpiry(Integer authorizationExpiry) {
        this.authorizationExpiry = authorizationExpiry;
    }

    public QRCodeResponse amountDescription(String amountDescription) {
        this.amountDescription = amountDescription;
        return this;
    }

    @ApiModelProperty(value="Description of the order")
    public String getAmountDescription() {
        return this.amountDescription;
    }

    public void setAmountDescription(String amountDescription) {
        this.amountDescription = amountDescription;
    }

    public QRCodeResponse userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @ApiModelProperty(value="The User agent of the web browser.")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QRCodeResponse qrCodeResponse = (QRCodeResponse)o;
        return Objects.equals(this.codeId, qrCodeResponse.codeId) && Objects.equals(this.url, qrCodeResponse.url) && Objects.equals(this.deeplink, qrCodeResponse.deeplink) && Objects.equals(this.expiryDate, qrCodeResponse.expiryDate) && Objects.equals(this.merchantPaymentId, qrCodeResponse.merchantPaymentId) && Objects.equals(this.amount, qrCodeResponse.amount) && Objects.equals(this.orderDescription, qrCodeResponse.orderDescription) && Objects.equals(this.orderItems, qrCodeResponse.orderItems) && Objects.equals(this.metadata, qrCodeResponse.metadata) && Objects.equals(this.codeType, qrCodeResponse.codeType) && Objects.equals(this.storeInfo, qrCodeResponse.storeInfo) && Objects.equals(this.storeId, qrCodeResponse.storeId) && Objects.equals(this.terminalId, qrCodeResponse.terminalId) && Objects.equals(this.requestedAt, qrCodeResponse.requestedAt) && Objects.equals(this.redirectUrl, qrCodeResponse.redirectUrl) && Objects.equals((Object)this.redirectType, (Object)qrCodeResponse.redirectType) && Objects.equals(this.isAuthorization, qrCodeResponse.isAuthorization) && Objects.equals(this.authorizationExpiry, qrCodeResponse.authorizationExpiry) && Objects.equals(this.amountDescription, qrCodeResponse.amountDescription) && Objects.equals(this.userAgent, qrCodeResponse.userAgent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.codeId, this.url, this.deeplink, this.expiryDate, this.merchantPaymentId, this.amount, this.orderDescription, this.orderItems, this.metadata, this.codeType, this.storeInfo, this.storeId, this.terminalId, this.requestedAt, this.redirectUrl, this.redirectType, this.isAuthorization, this.authorizationExpiry, this.amountDescription, this.userAgent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QRCodeResponse {\n");
        sb.append("    codeId: ").append(this.toIndentedString(this.codeId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    deeplink: ").append(this.toIndentedString(this.deeplink)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    merchantPaymentId: ").append(this.toIndentedString(this.merchantPaymentId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    orderDescription: ").append(this.toIndentedString(this.orderDescription)).append("\n");
        sb.append("    orderItems: ").append(this.toIndentedString(this.orderItems)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    codeType: ").append(this.toIndentedString(this.codeType)).append("\n");
        sb.append("    storeInfo: ").append(this.toIndentedString(this.storeInfo)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    terminalId: ").append(this.toIndentedString(this.terminalId)).append("\n");
        sb.append("    requestedAt: ").append(this.toIndentedString(this.requestedAt)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    redirectType: ").append(this.toIndentedString((Object)this.redirectType)).append("\n");
        sb.append("    isAuthorization: ").append(this.toIndentedString(this.isAuthorization)).append("\n");
        sb.append("    authorizationExpiry: ").append(this.toIndentedString(this.authorizationExpiry)).append("\n");
        sb.append("    amountDescription: ").append(this.toIndentedString(this.amountDescription)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RedirectTypeEnum {
        WEB_LINK("WEB_LINK"),
        APP_DEEP_LINK("APP_DEEP_LINK");

        private String value;

        private RedirectTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RedirectTypeEnum fromValue(String text) {
            for (RedirectTypeEnum b : RedirectTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RedirectTypeEnum> {
            public void write(JsonWriter jsonWriter, RedirectTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RedirectTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RedirectTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

