/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.ne.paypay.model.MerchantOrderItem;
import jp.ne.paypay.model.MoneyAmount;

public class QRCode {
    @SerializedName(value="merchantPaymentId")
    @NotEmpty(message="merchantPaymentId is required")
    @Size(max=64, message="maximum 64 characters are allowed for merchantPaymentId")
    private @NotEmpty(message="merchantPaymentId is required") @Size(max=64, message="maximum 64 characters are allowed for merchantPaymentId") String merchantPaymentId = null;
    @SerializedName(value="amount")
    @NotNull(message="amount is required")
    private @NotNull(message="amount is required") MoneyAmount amount = null;
    @SerializedName(value="orderDescription")
    @Size(max=255, message="maximum 255 characters allowed for orderDescription")
    private @Size(max=255, message="maximum 255 characters allowed for orderDescription") String orderDescription = null;
    @SerializedName(value="orderItems")
    private List<MerchantOrderItem> orderItems = null;
    @SerializedName(value="metadata")
    private Object metadata = null;
    @SerializedName(value="codeType")
    @NotEmpty(message="codeType is required")
    private @NotEmpty(message="codeType is required") String codeType = null;
    @SerializedName(value="storeInfo")
    @Size(max=255, message="maximum 255 characters allowed for storeInfo")
    private @Size(max=255, message="maximum 255 characters allowed for storeInfo") String storeInfo = null;
    @SerializedName(value="storeId")
    @Size(max=255, message="maximum 255 characters allowed for storeId")
    private @Size(max=255, message="maximum 255 characters allowed for storeId") String storeId = null;
    @SerializedName(value="terminalId")
    @Size(max=255, message="maximum 255 characters allowed for terminalId")
    private @Size(max=255, message="maximum 255 characters allowed for terminalId") String terminalId = null;
    @SerializedName(value="requestedAt")
    private Long requestedAt = Instant.now().getEpochSecond();
    @SerializedName(value="isAuthorization")
    private Boolean isAuthorization = null;
    @SerializedName(value="authorizationExpiry")
    private Long authorizationExpiry = null;
    @SerializedName(value="redirectUrl")
    private String redirectUrl = null;
    @SerializedName(value="redirectType")
    private RedirectTypeEnum redirectType = null;
    @SerializedName(value="userAgent")
    private String userAgent = null;

    public QRCode merchantPaymentId(String merchantPaymentId) {
        this.merchantPaymentId = merchantPaymentId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantPaymentId() {
        return this.merchantPaymentId;
    }

    public void setMerchantPaymentId(String merchantPaymentId) {
        this.merchantPaymentId = merchantPaymentId;
    }

    public QRCode amount(MoneyAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public MoneyAmount getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyAmount amount) {
        this.amount = amount;
    }

    public QRCode orderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
        return this;
    }

    @ApiModelProperty(value="Description of the order")
    public String getOrderDescription() {
        return this.orderDescription;
    }

    public void setOrderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
    }

    public QRCode orderItems(List<MerchantOrderItem> orderItems) {
        this.orderItems = orderItems;
        return this;
    }

    public QRCode addOrderItemsItem(MerchantOrderItem orderItemsItem) {
        if (this.orderItems == null) {
            this.orderItems = new ArrayList<MerchantOrderItem>();
        }
        this.orderItems.add(orderItemsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<MerchantOrderItem> getOrderItems() {
        return this.orderItems;
    }

    public void setOrderItems(List<MerchantOrderItem> orderItems) {
        this.orderItems = orderItems;
    }

    public QRCode metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Extra information the merchant want to add")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public QRCode codeType(String codeType) {
        this.codeType = codeType;
        return this;
    }

    @ApiModelProperty(value="Please pass the fixed string ORDER_QR")
    public String getCodeType() {
        return this.codeType;
    }

    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    public QRCode storeInfo(String storeInfo) {
        this.storeInfo = storeInfo;
        return this;
    }

    @ApiModelProperty(value="Store info for the merchant")
    public String getStoreInfo() {
        return this.storeInfo;
    }

    public void setStoreInfo(String storeInfo) {
        this.storeInfo = storeInfo;
    }

    public QRCode storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="Id to identify store under merchant")
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public QRCode terminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    @ApiModelProperty(value="Id to identify terminal device under store")
    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public QRCode requestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getRequestedAt() {
        return this.requestedAt;
    }

    public void setRequestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
    }

    public QRCode isAuthorization(Boolean isAuthorization) {
        this.isAuthorization = isAuthorization;
        return this;
    }

    @ApiModelProperty(value="By default it will be false, please set true if the amount will be captured later")
    public Boolean isIsAuthorization() {
        return this.isAuthorization;
    }

    public void setIsAuthorization(Boolean isAuthorization) {
        this.isAuthorization = isAuthorization;
    }

    public QRCode authorizationExpiry(Long authorizationExpiry) {
        this.authorizationExpiry = authorizationExpiry;
        return this;
    }

    @ApiModelProperty(value="Epoch timestamp in seconds, expiry duration must be less then the expiry granted to the merchant")
    public Long getAuthorizationExpiry() {
        return this.authorizationExpiry;
    }

    public void setAuthorizationExpiry(Long authorizationExpiry) {
        this.authorizationExpiry = authorizationExpiry;
    }

    public QRCode redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @ApiModelProperty(value="The url of the page/app to open after the payment is complete")
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public QRCode redirectType(RedirectTypeEnum redirectType) {
        this.redirectType = redirectType;
        return this;
    }

    @ApiModelProperty(value="The type of redirect url")
    public RedirectTypeEnum getRedirectType() {
        return this.redirectType;
    }

    public void setRedirectType(RedirectTypeEnum redirectType) {
        this.redirectType = redirectType;
    }

    public QRCode userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @ApiModelProperty(value="The User agent of the web browser. When this parameter is provided, on mobile devices PayPay tries to open the browser that the merchant website is using. This can be found by using the javascript function navigator.userAgent")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QRCode qrCode = (QRCode)o;
        return Objects.equals(this.merchantPaymentId, qrCode.merchantPaymentId) && Objects.equals(this.amount, qrCode.amount) && Objects.equals(this.orderDescription, qrCode.orderDescription) && Objects.equals(this.orderItems, qrCode.orderItems) && Objects.equals(this.metadata, qrCode.metadata) && Objects.equals(this.codeType, qrCode.codeType) && Objects.equals(this.storeInfo, qrCode.storeInfo) && Objects.equals(this.storeId, qrCode.storeId) && Objects.equals(this.terminalId, qrCode.terminalId) && Objects.equals(this.requestedAt, qrCode.requestedAt) && Objects.equals(this.isAuthorization, qrCode.isAuthorization) && Objects.equals(this.authorizationExpiry, qrCode.authorizationExpiry) && Objects.equals(this.redirectUrl, qrCode.redirectUrl) && Objects.equals((Object)this.redirectType, (Object)qrCode.redirectType) && Objects.equals(this.userAgent, qrCode.userAgent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.merchantPaymentId, this.amount, this.orderDescription, this.orderItems, this.metadata, this.codeType, this.storeInfo, this.storeId, this.terminalId, this.requestedAt, this.isAuthorization, this.authorizationExpiry, this.redirectUrl, this.redirectType, this.userAgent});
    }

    public String toString() {
        return "QRCode{merchantPaymentId='" + this.merchantPaymentId + '\'' + ", amount=" + this.amount + ", orderDescription='" + this.orderDescription + '\'' + ", orderItems=" + this.orderItems + ", metadata=" + this.metadata + ", codeType='" + this.codeType + '\'' + ", storeInfo='" + this.storeInfo + '\'' + ", storeId='" + this.storeId + '\'' + ", terminalId='" + this.terminalId + '\'' + ", requestedAt=" + this.requestedAt + ", isAuthorization=" + this.isAuthorization + ", authorizationExpiry=" + this.authorizationExpiry + ", redirectUrl='" + this.redirectUrl + '\'' + ", redirectType=" + (Object)((Object)this.redirectType) + ", userAgent='" + this.userAgent + '\'' + '}';
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RedirectTypeEnum {
        WEB_LINK("WEB_LINK"),
        APP_DEEP_LINK("APP_DEEP_LINK");

        private String value;

        private RedirectTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RedirectTypeEnum fromValue(String text) {
            for (RedirectTypeEnum b : RedirectTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RedirectTypeEnum> {
            public void write(JsonWriter jsonWriter, RedirectTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RedirectTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RedirectTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

