/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.Instant;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.ne.paypay.model.MoneyAmount;

public class CaptureObject {
    @SerializedName(value="merchantPaymentId")
    @NotEmpty(message="merchantPaymentId is required")
    @Size(max=64, message="maximum 64 characters are allowed for merchantPaymentId")
    private @NotEmpty(message="merchantPaymentId is required") @Size(max=64, message="maximum 64 characters are allowed for merchantPaymentId") String merchantPaymentId = null;
    @SerializedName(value="amount")
    @NotNull(message="amount is required")
    private @NotNull(message="amount is required") MoneyAmount amount = null;
    @SerializedName(value="merchantCaptureId")
    @NotEmpty(message="merchantCaptureId is required")
    @Size(max=64, message="maximum 64 characters are allowed for merchantCaptureId")
    private @NotEmpty(message="merchantCaptureId is required") @Size(max=64, message="maximum 64 characters are allowed for merchantCaptureId") String merchantCaptureId = null;
    @SerializedName(value="requestedAt")
    @NotNull(message="requestedAt is required")
    private @NotNull(message="requestedAt is required") Long requestedAt = Instant.now().getEpochSecond();
    @SerializedName(value="orderDescription")
    @NotEmpty(message="orderDescription is required")
    @Size(max=255, message="maximum 255 characters allowed for orderDescription")
    private @NotEmpty(message="orderDescription is required") @Size(max=255, message="maximum 255 characters allowed for orderDescription") String orderDescription = null;

    public CaptureObject merchantPaymentId(String merchantPaymentId) {
        this.merchantPaymentId = merchantPaymentId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantPaymentId() {
        return this.merchantPaymentId;
    }

    public void setMerchantPaymentId(String merchantPaymentId) {
        this.merchantPaymentId = merchantPaymentId;
    }

    public CaptureObject amount(MoneyAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MoneyAmount getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyAmount amount) {
        this.amount = amount;
    }

    public CaptureObject merchantCaptureId(String merchantCaptureId) {
        this.merchantCaptureId = merchantCaptureId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getMerchantCaptureId() {
        return this.merchantCaptureId;
    }

    public void setMerchantCaptureId(String merchantCaptureId) {
        this.merchantCaptureId = merchantCaptureId;
    }

    public CaptureObject requestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Long getRequestedAt() {
        return this.requestedAt;
    }

    public void setRequestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
    }

    public CaptureObject orderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
        return this;
    }

    @ApiModelProperty(required=true, value="Description for Capture")
    public String getOrderDescription() {
        return this.orderDescription;
    }

    public void setOrderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaptureObject captureObject = (CaptureObject)o;
        return Objects.equals(this.merchantPaymentId, captureObject.merchantPaymentId) && Objects.equals(this.amount, captureObject.amount) && Objects.equals(this.merchantCaptureId, captureObject.merchantCaptureId) && Objects.equals(this.requestedAt, captureObject.requestedAt) && Objects.equals(this.orderDescription, captureObject.orderDescription);
    }

    public int hashCode() {
        return Objects.hash(this.merchantPaymentId, this.amount, this.merchantCaptureId, this.requestedAt, this.orderDescription);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaptureObject {\n");
        sb.append("    merchantPaymentId: ").append(this.toIndentedString(this.merchantPaymentId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    merchantCaptureId: ").append(this.toIndentedString(this.merchantCaptureId)).append("\n");
        sb.append("    requestedAt: ").append(this.toIndentedString(this.requestedAt)).append("\n");
        sb.append("    orderDescription: ").append(this.toIndentedString(this.orderDescription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

