/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.example;

import java.util.UUID;
import jp.ne.paypay.ApiClient;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.Configuration;
import jp.ne.paypay.api.PaymentApi;
import jp.ne.paypay.api.PendingPaymentApi;
import jp.ne.paypay.example.PaymentApiExample;
import jp.ne.paypay.model.Payment;
import jp.ne.paypay.model.PaymentDetails;
import jp.ne.paypay.model.Refund;
import jp.ne.paypay.model.RefundDetails;

public class PendingPaymentApiExample
extends PaymentApiExample {
    public static void main(String[] args) throws ApiException {
        ApiClient apiClient = new Configuration().getDefaultApiClient();
        apiClient.setProductionMode(false);
        apiClient.setApiKey("API_KEY");
        apiClient.setApiSecretKey("API_SECRET_KEY");
        apiClient.setAssumeMerchant("ASSUME_MERCHANT_ID");
        String userAuthorizationId = "USER_AUTHORIZATION_ID";
        PendingPaymentApi pendingPaymentApi = new PendingPaymentApi(apiClient);
        PaymentApi paymentApi = new PaymentApi(apiClient);
        PaymentDetails paymentDetails = PendingPaymentApiExample.pendingPayment(pendingPaymentApi, userAuthorizationId, 2);
        if (paymentDetails != null && paymentDetails.getData() != null) {
            String merchantPaymentId = paymentDetails.getData().getMerchantPaymentId();
            PendingPaymentApiExample.getPendingPaymentDetails(pendingPaymentApi, merchantPaymentId);
            PendingPaymentApiExample.cancelPendingPayment(pendingPaymentApi, merchantPaymentId);
            PendingPaymentApiExample.refundPendingPayment(paymentApi, pendingPaymentApi, paymentDetails.getData().getPaymentId());
        }
    }

    private static PaymentDetails pendingPayment(PendingPaymentApi paymentApi, String userAuthorizationId, int amount) {
        String merchantPaymentId = UUID.randomUUID().toString();
        Payment payment = PendingPaymentApiExample.getPaymentObject(merchantPaymentId, userAuthorizationId, amount);
        PendingPaymentApiExample.createPendingPayment(paymentApi, payment);
        return PendingPaymentApiExample.getPendingPaymentDetails(paymentApi, merchantPaymentId);
    }

    private static void cancelPendingPayment(PendingPaymentApi pendingPaymentApi, String merchantPaymentId) {
        if (merchantPaymentId != null) {
            PendingPaymentApiExample.cancelPendingOrder(pendingPaymentApi, merchantPaymentId);
            PendingPaymentApiExample.getPendingPaymentDetails(pendingPaymentApi, merchantPaymentId);
        }
    }

    private static void refundPendingPayment(PaymentApi paymentApi, PendingPaymentApi pendingPaymentApi, String paymentId) {
        RefundDetails refundDetails;
        String refundId = UUID.randomUUID().toString();
        if (paymentId != null && (refundDetails = PendingPaymentApiExample.refundPendingPayment(pendingPaymentApi, paymentId, refundId)).getData().getMerchantRefundId() != null) {
            PendingPaymentApiExample.getRefundDetails(paymentApi, refundDetails.getData().getMerchantRefundId());
        }
    }

    private static void createPendingPayment(PendingPaymentApi apiInstance, Payment payment) {
        try {
            PaymentDetails result = apiInstance.createPendingPayment(payment);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result.getResultInfo().getCode());
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
    }

    private static RefundDetails refundPendingPayment(PendingPaymentApi apiInstance, String paymentId, String refundId) {
        RefundDetails result = null;
        try {
            Refund refund = PendingPaymentApiExample.getRefundObject(paymentId, refundId);
            result = apiInstance.refundPayment(refund);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result.getResultInfo().getCode());
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
        return result;
    }

    private static PaymentDetails getPendingPaymentDetails(PendingPaymentApi apiInstance, String merchantPaymentId) {
        PaymentDetails result = null;
        try {
            result = apiInstance.getPaymentDetails(merchantPaymentId);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result.getResultInfo().getCode());
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
        return result;
    }

    private static void cancelPendingOrder(PendingPaymentApi pendingPaymentApi, String merchantPaymentId) {
        try {
            pendingPaymentApi.cancelPendingOrder(merchantPaymentId);
            PaymentDetails cancelledPendingOrder = PendingPaymentApiExample.getPendingPaymentDetails(pendingPaymentApi, merchantPaymentId);
            System.out.println("\n\nCancel Pending Order API RESPONSE\n------------------\n");
            System.out.println(cancelledPendingOrder);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling PaymentApi#cancelPendingOrder" + e.getMessage());
            System.err.println(e.getResponseBody());
        }
    }
}

