/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.example;

import java.util.ArrayList;
import java.util.UUID;
import jp.ne.paypay.ApiClient;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.Configuration;
import jp.ne.paypay.api.PaymentApi;
import jp.ne.paypay.api.WalletApi;
import jp.ne.paypay.model.AccountLinkQRCode;
import jp.ne.paypay.model.AuthorizationScope;
import jp.ne.paypay.model.CaptureObject;
import jp.ne.paypay.model.LinkQRCodeResponse;
import jp.ne.paypay.model.MerchantOrderItem;
import jp.ne.paypay.model.MoneyAmount;
import jp.ne.paypay.model.NotDataResponse;
import jp.ne.paypay.model.Payment;
import jp.ne.paypay.model.PaymentDetails;
import jp.ne.paypay.model.PaymentState;
import jp.ne.paypay.model.PaymentStateRevert;
import jp.ne.paypay.model.QRCode;
import jp.ne.paypay.model.QRCodeDetails;
import jp.ne.paypay.model.Refund;
import jp.ne.paypay.model.RefundDetails;
import jp.ne.paypay.model.RevertAuthResponse;
import jp.ne.paypay.model.WalletBalance;
import org.apache.commons.lang3.RandomStringUtils;

public class PaymentApiExample {
    public static void main(String[] args) throws ApiException {
        ApiClient apiClient = new Configuration().getDefaultApiClient();
        apiClient.setProductionMode(false);
        apiClient.setApiKey("API_KEY");
        apiClient.setApiSecretKey("API_SECRET_KEY");
        apiClient.setAssumeMerchant("ASSUME_MERCHANT_ID");
        String userAuthorizationId = "USER_AUTHORIZATION_ID";
        PaymentApi paymentApi = new PaymentApi(apiClient);
        WalletApi walletApiInstance = new WalletApi(apiClient);
        PaymentApiExample.createAccountLinkQrCode(paymentApi);
        PaymentApiExample.preAuthCaptureFlow(walletApiInstance, paymentApi, userAuthorizationId);
        PaymentApiExample.preAuthRevertAuthFlow(walletApiInstance, paymentApi, userAuthorizationId);
        PaymentApiExample.directDebitFlow(walletApiInstance, paymentApi, userAuthorizationId, false);
        PaymentApiExample.directDebitFlow(walletApiInstance, paymentApi, userAuthorizationId, true);
        PaymentApiExample.appInvokeFlow(paymentApi, walletApiInstance, userAuthorizationId);
    }

    protected static Payment getPaymentObject(String merchantPaymentId, String userAuthorizationId, int amount) {
        Payment payment = new Payment();
        payment.setAmount(new MoneyAmount().amount(amount).currency(MoneyAmount.CurrencyEnum.JPY));
        payment.setMerchantPaymentId(merchantPaymentId);
        payment.setUserAuthorizationId(userAuthorizationId);
        payment.setStoreId(RandomStringUtils.randomAlphabetic((int)8));
        payment.setTerminalId(RandomStringUtils.randomAlphanumeric((int)8));
        payment.setOrderReceiptNumber(RandomStringUtils.randomAlphanumeric((int)8));
        payment.setOrderDescription("Payment for Order ID:" + UUID.randomUUID().toString());
        MerchantOrderItem merchantOrderItem = new MerchantOrderItem().category("Dessert").name("Red Velvet Cake").productId(RandomStringUtils.randomAlphanumeric((int)8)).quantity(1).unitPrice(new MoneyAmount().amount(10).currency(MoneyAmount.CurrencyEnum.JPY));
        ArrayList<MerchantOrderItem> merchantOrderItems = new ArrayList<MerchantOrderItem>();
        merchantOrderItems.add(merchantOrderItem);
        payment.setOrderItems(merchantOrderItems);
        return payment;
    }

    private static void createAccountLinkQrCode(PaymentApi apiInstance) {
        try {
            AccountLinkQRCode accountLinkQRCode = new AccountLinkQRCode();
            ArrayList<AuthorizationScope> scopes = new ArrayList<AuthorizationScope>();
            scopes.add(AuthorizationScope.DIRECT_DEBIT);
            scopes.add(AuthorizationScope.PENDING_PAYMENTS);
            scopes.add(AuthorizationScope.CONTINUOUS_PAYMENTS);
            scopes.add(AuthorizationScope.PREAUTH_CAPTURE_NATIVE);
            accountLinkQRCode.setScopes(scopes);
            accountLinkQRCode.setNonce(RandomStringUtils.randomAlphanumeric((int)8).toLowerCase());
            accountLinkQRCode.setDeviceId("device_id");
            accountLinkQRCode.setRedirectUrl("merchant.domain/test");
            accountLinkQRCode.setPhoneNumber("phone_number");
            accountLinkQRCode.setReferenceId("reference_id");
            accountLinkQRCode.setRedirectType(QRCode.RedirectTypeEnum.WEB_LINK);
            LinkQRCodeResponse response = apiInstance.createAccountLinkQRCode(accountLinkQRCode);
            System.out.println(response.getResultInfo().getCode());
            System.out.println(response.getData());
        }
        catch (ApiException e) {
            e.printStackTrace();
            System.out.println(e.getResponseBody());
        }
    }

    private static void appInvokeFlow(PaymentApi paymentApi, WalletApi walletApiInstance, String userAuthorizationId) {
        int amount = 1;
        QRCodeDetails qrCodeDetails = PaymentApiExample.createQRCode(paymentApi, amount);
        String merchantPaymentId = qrCodeDetails != null ? qrCodeDetails.getData().getMerchantPaymentId() : null;
        WalletBalance walletBalance = PaymentApiExample.getWalletBalance(walletApiInstance, userAuthorizationId);
        if (merchantPaymentId != null && walletBalance != null && walletBalance.getData().isHasEnoughBalance().booleanValue()) {
            System.out.println("The QR Code can be used as a deeplink to invoke PayPay app and receive Payments. The user can makes the payment using PayPay App");
            System.out.println("For this example, we will create payment using the API...");
            Payment payment = PaymentApiExample.getPaymentObject(merchantPaymentId, userAuthorizationId, amount);
            PaymentDetails paymentDetails = PaymentApiExample.createPayment(paymentApi, payment, false);
            if (paymentDetails != null) {
                System.out.println("Payment created successfully, Now calling the API to get payment details for payment ID:" + merchantPaymentId);
                String refundId = UUID.randomUUID().toString();
                paymentDetails = PaymentApiExample.getPaymentDetails(paymentApi, merchantPaymentId);
                if (paymentDetails != null) {
                    System.out.println("Creating Refund for the payment:" + paymentDetails.getData().getPaymentId());
                    PaymentApiExample.createRefund(paymentApi, paymentDetails.getData().getPaymentId(), refundId);
                    System.out.println("Get refund details:" + refundId);
                    PaymentApiExample.getRefundDetails(paymentApi, refundId);
                    System.out.println("Finally cancel the payment");
                    PaymentApiExample.cancelPayment(paymentApi, merchantPaymentId);
                }
            }
        }
        if (qrCodeDetails != null) {
            System.out.println("Delete the QR Code: " + qrCodeDetails.getData().getCodeId());
            PaymentApiExample.deleteQrCode(paymentApi, qrCodeDetails.getData().getCodeId());
        }
    }

    private static void directDebitFlow(WalletApi walletApiInstance, PaymentApi paymentApi, String userAuthorizationId, boolean continuousPayment) {
        String merchantPaymentId = UUID.randomUUID().toString();
        WalletBalance walletBalance = PaymentApiExample.getWalletBalance(walletApiInstance, userAuthorizationId);
        if (walletBalance != null && walletBalance.getData().isHasEnoughBalance().booleanValue()) {
            PaymentDetails paymentDetails;
            System.out.println("There is enough balance, now creating payment...");
            Payment payment = PaymentApiExample.getPaymentObject(merchantPaymentId, userAuthorizationId, 1);
            if (continuousPayment) {
                payment.setAmount(new MoneyAmount().amount(2).currency(MoneyAmount.CurrencyEnum.JPY));
                paymentDetails = PaymentApiExample.createContinuousPayment(paymentApi, payment);
            } else {
                paymentDetails = PaymentApiExample.createPayment(paymentApi, payment, false);
            }
            if (paymentDetails != null) {
                System.out.println("Payment created successfully, Now calling the API to get payment details for payment ID:" + merchantPaymentId);
                String refundId = UUID.randomUUID().toString();
                paymentDetails = PaymentApiExample.getPaymentDetails(paymentApi, merchantPaymentId);
                System.out.println("Creating Refund for the payment:" + paymentDetails.getData().getPaymentId());
                PaymentApiExample.createRefund(paymentApi, paymentDetails.getData().getPaymentId(), refundId);
                System.out.println("Get refund details:" + refundId);
                PaymentApiExample.getRefundDetails(paymentApi, refundId);
                System.out.println("Finally cancel the payment");
                PaymentApiExample.cancelPayment(paymentApi, merchantPaymentId);
            }
        }
    }

    private static void preAuthCaptureFlow(WalletApi walletApiInstance, PaymentApi paymentApi, String userAuthorizationId) {
        String merchantPaymentId = UUID.randomUUID().toString();
        System.out.println("Checking wallet balance...");
        int amount = 1;
        WalletBalance walletBalance = PaymentApiExample.getWalletBalance(walletApiInstance, userAuthorizationId);
        if (walletBalance != null && walletBalance.getData().isHasEnoughBalance().booleanValue()) {
            System.out.println("There is enough balance, now creating payment...");
            Payment payment = PaymentApiExample.getPaymentObject(merchantPaymentId, userAuthorizationId, amount);
            PaymentDetails paymentDetails = PaymentApiExample.createPayment(paymentApi, payment, true);
            if (paymentDetails != null) {
                System.out.println("Now capture the payment authorization for a payment, Don't capture if you need to check cancel payment");
                PaymentApiExample.capturePayment(paymentApi, merchantPaymentId, amount);
                System.out.println("Payment created successfully, Now calling the API to get payment details for payment ID:" + merchantPaymentId);
                paymentDetails = PaymentApiExample.getPaymentDetails(paymentApi, merchantPaymentId);
                if (paymentDetails != null) {
                    if (paymentDetails.getData().getStatus() == PaymentState.StatusEnum.COMPLETED) {
                        String refundId = UUID.randomUUID().toString();
                        System.out.println("Creating Refund for the payment:" + paymentDetails.getData().getPaymentId());
                        PaymentApiExample.createRefund(paymentApi, paymentDetails.getData().getPaymentId(), refundId);
                        System.out.println("Get refund details:" + refundId);
                        PaymentApiExample.getRefundDetails(paymentApi, refundId);
                    } else {
                        System.out.println("Finally cancel the payment");
                        PaymentApiExample.cancelPayment(paymentApi, merchantPaymentId);
                    }
                }
            }
        }
    }

    private static void preAuthRevertAuthFlow(WalletApi walletApiInstance, PaymentApi paymentApi, String userAuthorizationId) {
        String merchantPaymentId = UUID.randomUUID().toString();
        System.out.println("Checking wallet balance...");
        WalletBalance walletBalance = PaymentApiExample.getWalletBalance(walletApiInstance, userAuthorizationId);
        if (walletBalance != null && walletBalance.getData().isHasEnoughBalance().booleanValue()) {
            System.out.println("There is enough balance, now creating payment...");
            Payment payment = PaymentApiExample.getPaymentObject(merchantPaymentId, userAuthorizationId, 1);
            PaymentDetails paymentDetails = PaymentApiExample.createPayment(paymentApi, payment, true);
            if (paymentDetails != null) {
                System.out.println("Payment Authorized successfully, Now calling the API to get payment details for payment ID:" + merchantPaymentId);
                paymentDetails = PaymentApiExample.getPaymentDetails(paymentApi, merchantPaymentId);
                if (paymentDetails != null) {
                    System.out.println("Reverting payment with Payment ID" + paymentDetails.getData().getPaymentId());
                    PaymentApiExample.paymentRevertAuth(paymentApi, paymentDetails.getData().getPaymentId());
                    System.out.println("Check the payment details, the status should be CANCELED");
                    PaymentApiExample.getPaymentDetails(paymentApi, merchantPaymentId);
                }
            }
        }
    }

    private static WalletBalance getWalletBalance(WalletApi apiInstance, String userAuthorizationId) {
        WalletBalance result = null;
        try {
            result = apiInstance.checkWalletBalance(userAuthorizationId, 1, "JPY", null);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            e.printStackTrace();
            System.out.println("--------------------");
            System.out.println(e.getResponseBody());
        }
        return result;
    }

    private static PaymentDetails createPayment(PaymentApi apiInstance, Payment payment, boolean authorization) {
        PaymentDetails result = null;
        try {
            result = authorization ? apiInstance.createPaymentAuthorization(payment, "false") : apiInstance.createPayment(payment, "false");
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
        return result;
    }

    private static PaymentDetails createContinuousPayment(PaymentApi apiInstance, Payment payment) {
        PaymentDetails result = null;
        try {
            result = apiInstance.createContinuousPayment(payment);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result.getResultInfo().getCode());
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
        return result;
    }

    private static void capturePayment(PaymentApi apiInstance, String merchantPaymentId, int amount) {
        try {
            CaptureObject captureObject = new CaptureObject();
            captureObject.setMerchantCaptureId(UUID.randomUUID().toString());
            captureObject.setMerchantPaymentId(merchantPaymentId);
            captureObject.setAmount(new MoneyAmount().amount(amount).currency(MoneyAmount.CurrencyEnum.JPY));
            captureObject.setOrderDescription("new Order");
            PaymentDetails paymentDetails = apiInstance.capturePaymentAuth(captureObject);
            System.out.println(paymentDetails);
        }
        catch (ApiException e) {
            e.printStackTrace();
            System.out.println(e.getResponseBody());
        }
    }

    private static void createRefund(PaymentApi apiInstance, String paymentId, String refundId) {
        try {
            Refund refund = PaymentApiExample.getRefundObject(paymentId, refundId);
            RefundDetails result = apiInstance.refundPayment(refund);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
    }

    protected static Refund getRefundObject(String paymentId, String refundId) {
        Refund refund = new Refund();
        refund.setAmount(new MoneyAmount().amount(1).currency(MoneyAmount.CurrencyEnum.JPY));
        refund.setMerchantRefundId(refundId);
        refund.setPaymentId(paymentId);
        refund.setReason("Testing");
        return refund;
    }

    private static QRCodeDetails createQRCode(PaymentApi apiInstance, int amount) {
        QRCodeDetails result = null;
        try {
            QRCode qrCode = new QRCode();
            qrCode.setAmount(new MoneyAmount().amount(amount).currency(MoneyAmount.CurrencyEnum.JPY));
            qrCode.setMerchantPaymentId(UUID.randomUUID().toString());
            qrCode.setCodeType("ORDER_QR");
            qrCode.setStoreId(RandomStringUtils.randomAlphabetic((int)8));
            qrCode.setStoreInfo("Just Bake");
            qrCode.setTerminalId(RandomStringUtils.randomAlphanumeric((int)8));
            qrCode.setRedirectUrl("https://paypay.ne.jp/");
            qrCode.setRedirectType(QRCode.RedirectTypeEnum.WEB_LINK);
            qrCode.setOrderDescription("Payment for Order ID:" + UUID.randomUUID().toString());
            result = apiInstance.createQRCode(qrCode);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.out.println(e.getResponseHeaders().toString());
            System.err.println(e.getResponseBody());
        }
        return result;
    }

    protected static void getRefundDetails(PaymentApi apiInstance, String merchantRefundId) {
        try {
            RefundDetails result = apiInstance.getRefundDetails(merchantRefundId);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
    }

    private static PaymentDetails getPaymentDetails(PaymentApi apiInstance, String merchantPaymentId) {
        PaymentDetails result = null;
        try {
            result = apiInstance.getPaymentDetails(merchantPaymentId);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
        return result;
    }

    private static void deleteQrCode(PaymentApi apiInstance, String qrCode) {
        try {
            NotDataResponse result = apiInstance.deleteQRCode(qrCode);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
    }

    private static void cancelPayment(PaymentApi apiInstance, String merchantPaymentId) {
        try {
            NotDataResponse result = apiInstance.cancelPayment(merchantPaymentId);
            System.out.println("\n\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println("Exception when calling PaymentApi#cancelPayment" + e.getMessage());
            System.err.println(e.getResponseBody());
        }
    }

    private static void paymentRevertAuth(PaymentApi apiInstance, String paymentId) {
        try {
            PaymentStateRevert payment = new PaymentStateRevert();
            payment.setPaymentId(paymentId);
            payment.setMerchantRevertId(UUID.randomUUID().toString());
            RevertAuthResponse result = apiInstance.revertAuth(payment);
            System.out.println("\nAPI RESPONSE\n------------------\n");
            System.out.println(result);
        }
        catch (ApiException e) {
            System.err.println(e.getResponseBody());
        }
    }
}

