/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import jp.ne.paypay.ApiClient;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.ApiResponse;
import jp.ne.paypay.Configuration;
import jp.ne.paypay.Pair;
import jp.ne.paypay.model.ProductType;
import jp.ne.paypay.model.WalletBalance;

public class WalletApi {
    private ApiClient apiClient;

    public WalletApi() {
        this(new Configuration().getDefaultApiClient());
    }

    public WalletApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call checkWalletBalanceCall(String userAuthorizationId, Integer amount, String currency, ProductType productType) throws ApiException {
        String localVarPath = "/v2/wallet/check_balance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (userAuthorizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("userAuthorizationId", userAuthorizationId));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("amount", amount));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("currency", currency));
        }
        if (productType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("productType", (Object)productType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"HmacAuth"};
        this.apiClient.setReadTimeout(15);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, null, localVarHeaderParams, localVarFormParams, localVarAuthNames);
    }

    private Call checkWalletBalanceValidateBeforeCall(String userAuthorizationId, Integer amount, String currency, ProductType productType) throws ApiException {
        if (userAuthorizationId == null) {
            throw new ApiException("Missing the required parameter 'userAuthorizationId' when calling checkWalletBalance(Async)");
        }
        if (amount == null) {
            throw new ApiException("Missing the required parameter 'amount' when calling checkWalletBalance(Async)");
        }
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling checkWalletBalance(Async)");
        }
        return this.checkWalletBalanceCall(userAuthorizationId, amount, currency, productType);
    }

    public WalletBalance checkWalletBalance(String userAuthorizationId, Integer amount, String currency, @NotNull ProductType productType) throws ApiException {
        ApiResponse<WalletBalance> resp = this.checkWalletBalanceWithHttpInfo(userAuthorizationId, amount, currency, productType);
        return resp.getData();
    }

    protected ApiResponse<WalletBalance> checkWalletBalanceWithHttpInfo(String userAuthorizationId, Integer amount, String currency, ProductType productType) throws ApiException {
        Call call = this.checkWalletBalanceValidateBeforeCall(userAuthorizationId, amount, currency, productType);
        Type localVarReturnType = new TypeToken<WalletBalance>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_checkWalletBalance");
    }
}

