/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import java.lang.reflect.Type;
import jp.ne.paypay.ApiClient;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.ApiResponse;
import jp.ne.paypay.Configuration;
import jp.ne.paypay.Pair;
import jp.ne.paypay.api.ApiUtil;
import jp.ne.paypay.model.MaskedUserProfileResponse;
import jp.ne.paypay.model.NotDataResponse;
import jp.ne.paypay.model.UserAuthorizationStatus;

public class UserApi {
    private ApiClient apiClient;

    public UserApi() {
        this(new Configuration().getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call getMaskedUserProfileValidateBeforeCall(String userAuthorizationId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/user/profile/secure?userAuthorizationId={userAuthorizationId}", new Pair("userAuthorizationId", userAuthorizationId), "GET");
    }

    public MaskedUserProfileResponse getMaskedUserProfile(String userAuthorizationId) throws ApiException {
        ApiResponse<MaskedUserProfileResponse> resp = this.getMaskedUserProfileWithHttpInfo(userAuthorizationId);
        return resp.getData();
    }

    protected ApiResponse<MaskedUserProfileResponse> getMaskedUserProfileWithHttpInfo(String userAuthorizationId) throws ApiException {
        Call call = this.getMaskedUserProfileValidateBeforeCall(userAuthorizationId);
        Type localVarReturnType = new TypeToken<MaskedUserProfileResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_getSecureUserProfile");
    }

    private Call getUserAuthorizationStatusValidateBeforeCall(String userAuthorizationId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/user/authorizations?userAuthorizationId={userAuthorizationId}", new Pair("userAuthorizationId", userAuthorizationId), "GET");
    }

    public UserAuthorizationStatus getUserAuthorizationStatus(String userAuthorizationId) throws ApiException {
        ApiResponse<UserAuthorizationStatus> resp = this.getUserAuthorizationStatusWithHttpInfo(userAuthorizationId);
        return resp.getData();
    }

    protected ApiResponse<UserAuthorizationStatus> getUserAuthorizationStatusWithHttpInfo(String userAuthorizationId) throws ApiException {
        Call call = this.getUserAuthorizationStatusValidateBeforeCall(userAuthorizationId);
        Type localVarReturnType = new TypeToken<UserAuthorizationStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_userAuthStatus");
    }

    private Call unlinkUserValidateBeforeCall(String userAuthorizationId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/user/authorizations/{userAuthorizationId}", new Pair("userAuthorizationId", userAuthorizationId), "DELETE");
    }

    public NotDataResponse unlinkUser(String userAuthorizationId) throws ApiException {
        ApiResponse<NotDataResponse> resp = this.unlinkUserWithHttpInfo(userAuthorizationId);
        return resp.getData();
    }

    protected ApiResponse<NotDataResponse> unlinkUserWithHttpInfo(String userAuthorizationId) throws ApiException {
        Call call = this.unlinkUserValidateBeforeCall(userAuthorizationId);
        Type localVarReturnType = new TypeToken<NotDataResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_unlinkUser");
    }
}

