/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import java.lang.reflect.Type;
import jp.ne.paypay.ApiClient;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.ApiResponse;
import jp.ne.paypay.Configuration;
import jp.ne.paypay.Pair;
import jp.ne.paypay.Validator;
import jp.ne.paypay.api.ApiUtil;
import jp.ne.paypay.api.PaymentApi;
import jp.ne.paypay.model.NotDataResponse;
import jp.ne.paypay.model.Payment;
import jp.ne.paypay.model.PaymentDetails;
import jp.ne.paypay.model.Refund;
import jp.ne.paypay.model.RefundDetails;

public class PendingPaymentApi {
    private ApiClient apiClient;
    private PaymentApi paymentApi;
    private final Validator validator = Validator.getInstance();

    public PendingPaymentApi() {
        this(new Configuration().getDefaultApiClient());
    }

    public PendingPaymentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.paymentApi = new PaymentApi(apiClient);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.paymentApi = new PaymentApi(apiClient);
    }

    public PaymentDetails createPendingPayment(Payment payment) throws ApiException {
        ApiUtil.validateObject(this.validator, payment);
        ApiResponse<PaymentDetails> resp = this.createPendingPaymentWithHttpInfo(payment);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> createPendingPaymentWithHttpInfo(Payment payment) throws ApiException {
        Call call = this.createPendingPaymentCall(payment);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v1_createRequestOrder");
    }

    private Call createPendingPaymentCall(Payment payment) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v1/requestOrder", payment, null);
    }

    public PaymentDetails getPaymentDetails(String merchantPaymentId) throws ApiException {
        ApiResponse<PaymentDetails> resp = this.getPendingPaymentDetailsWithHttpInfo(merchantPaymentId);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> getPendingPaymentDetailsWithHttpInfo(String merchantPaymentId) throws ApiException {
        Call call = this.getPaymentDetailsValidateBeforeCall(merchantPaymentId);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v1_getRequestOrder");
    }

    private Call getPaymentDetailsValidateBeforeCall(String merchantPaymentId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v1/requestOrder/{merchantPaymentId}", new Pair("merchantPaymentId", merchantPaymentId), "GET");
    }

    public NotDataResponse cancelPendingOrder(String merchantPaymentId) throws ApiException {
        ApiResponse<NotDataResponse> resp = this.cancelPendingOrderWithHttpInfo(merchantPaymentId);
        return resp.getData();
    }

    protected ApiResponse<NotDataResponse> cancelPendingOrderWithHttpInfo(String merchantPaymentId) throws ApiException {
        Call call = this.cancelPendingOrderValidateBeforeCall(merchantPaymentId);
        Type localVarReturnType = new TypeToken<NotDataResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v1_cancelRequestOrder");
    }

    private Call cancelPendingOrderValidateBeforeCall(String merchantPaymentId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v1/requestOrder/{merchantPaymentId}", new Pair("merchantPaymentId", merchantPaymentId), "DELETE");
    }

    public RefundDetails refundPayment(Refund refund) throws ApiException {
        ApiUtil.validateObject(this.validator, refund);
        return this.paymentApi.refundPayment(refund);
    }

    public RefundDetails getRefundDetails(String merchantRefundId) throws ApiException {
        return this.paymentApi.getRefundDetails(merchantRefundId);
    }
}

