/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import java.lang.reflect.Type;
import jp.ne.paypay.ApiClient;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.ApiResponse;
import jp.ne.paypay.Configuration;
import jp.ne.paypay.Pair;
import jp.ne.paypay.Validator;
import jp.ne.paypay.api.ApiUtil;
import jp.ne.paypay.model.AccountLinkQRCode;
import jp.ne.paypay.model.CaptureObject;
import jp.ne.paypay.model.LinkQRCodeResponse;
import jp.ne.paypay.model.NotDataResponse;
import jp.ne.paypay.model.Payment;
import jp.ne.paypay.model.PaymentDetails;
import jp.ne.paypay.model.QRCode;
import jp.ne.paypay.model.QRCodeDetails;
import jp.ne.paypay.model.Refund;
import jp.ne.paypay.model.RefundDetails;
import jp.ne.paypay.model.RevertAuthResponse;

public class PaymentApi {
    private ApiClient apiClient;
    private final Validator validator = Validator.getInstance();

    public PaymentApi() {
        this(new Configuration().getDefaultApiClient());
    }

    public PaymentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call cancelPaymentValidateBeforeCall(String merchantPaymentId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/payments/{merchantPaymentId}", new Pair("merchantPaymentId", merchantPaymentId), "DELETE");
    }

    public NotDataResponse cancelPayment(String merchantPaymentId) throws ApiException {
        ApiResponse<NotDataResponse> resp = this.cancelPaymentWithHttpInfo(merchantPaymentId);
        return resp.getData();
    }

    protected ApiResponse<NotDataResponse> cancelPaymentWithHttpInfo(String merchantPaymentId) throws ApiException {
        Call call = this.cancelPaymentValidateBeforeCall(merchantPaymentId);
        Type localVarReturnType = new TypeToken<NotDataResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_cancelPayment");
    }

    public PaymentDetails capturePaymentAuth(CaptureObject body) throws ApiException {
        String message = this.validator.validate(body);
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        ApiResponse<PaymentDetails> resp = this.capturePaymentAuthWithHttpInfo(body);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> capturePaymentAuthWithHttpInfo(Object body) throws ApiException {
        Call call = this.capturePaymentAuthCall(body);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_captureAuthorizedOrder");
    }

    private Call capturePaymentAuthCall(Object body) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v2/payments/capture", body, null);
    }

    private Call createPaymentValidateBeforeCall(Object body, String agreeSimilarTransaction) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v2/payments", body, agreeSimilarTransaction);
    }

    public PaymentDetails createPayment(Payment body, String agreeSimilarTransaction) throws ApiException {
        String message = this.validator.validate(body);
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        ApiResponse<PaymentDetails> resp = this.createPaymentWithHttpInfo(body, agreeSimilarTransaction);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> createPaymentWithHttpInfo(Object body, String agreeSimilarTransaction) throws ApiException {
        Call call = this.createPaymentValidateBeforeCall(body, agreeSimilarTransaction);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_createPayment");
    }

    private Call createQRCodeCall(Object body) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v2/codes", body, null);
    }

    private Call createQRCodeValidateBeforeCall(Object body) throws ApiException {
        return this.createQRCodeCall(body);
    }

    public QRCodeDetails createQRCode(QRCode body) throws ApiException {
        String message = this.validator.validate(body);
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        ApiResponse<QRCodeDetails> resp = this.createQRCodeWithHttpInfo(body);
        return resp.getData();
    }

    protected ApiResponse<QRCodeDetails> createQRCodeWithHttpInfo(Object body) throws ApiException {
        Call call = this.createQRCodeValidateBeforeCall(body);
        Type localVarReturnType = new TypeToken<QRCodeDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_createDynamicQRCode");
    }

    private Call deleteQRCodeValidateBeforeCall(String codeId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/codes/{codeId}", new Pair("codeId", codeId), "DELETE");
    }

    public NotDataResponse deleteQRCode(String codeId) throws ApiException {
        ApiResponse<NotDataResponse> resp = this.deleteQRCodeWithHttpInfo(codeId);
        return resp.getData();
    }

    protected ApiResponse<NotDataResponse> deleteQRCodeWithHttpInfo(String codeId) throws ApiException {
        Call call = this.deleteQRCodeValidateBeforeCall(codeId);
        Type localVarReturnType = new TypeToken<NotDataResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_deleteDynamicQRCode");
    }

    private Call getPaymentDetailsValidateBeforeCall(String merchantPaymentId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/payments/{merchantPaymentId}", new Pair("merchantPaymentId", merchantPaymentId), "GET");
    }

    public PaymentDetails getPaymentDetails(String merchantPaymentId) throws ApiException {
        ApiResponse<PaymentDetails> resp = this.getPaymentDetailsWithHttpInfo(merchantPaymentId);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> getPaymentDetailsWithHttpInfo(String merchantPaymentId) throws ApiException {
        Call call = this.getPaymentDetailsValidateBeforeCall(merchantPaymentId);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_getPaymentDetail");
    }

    private Call getCodesPaymentDetailsValidateBeforeCall(String merchantPaymentId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/codes/payments/{merchantPaymentId}", new Pair("merchantPaymentId", merchantPaymentId), "GET");
    }

    public PaymentDetails getCodesPaymentDetails(String merchantPaymentId) throws ApiException {
        ApiResponse<PaymentDetails> resp = this.getCodesPaymentDetailsWithHttpInfo(merchantPaymentId);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> getCodesPaymentDetailsWithHttpInfo(String merchantPaymentId) throws ApiException {
        Call call = this.getCodesPaymentDetailsValidateBeforeCall(merchantPaymentId);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_getQRPaymentDetails");
    }

    private Call getRefundDetailsValidateBeforeCall(String merchantRefundId) throws ApiException {
        return ApiUtil.getCallObject(this.apiClient, "/v2/refunds/{merchantRefundId}", new Pair("merchantRefundId", merchantRefundId), "GET");
    }

    public RefundDetails getRefundDetails(String merchantRefundId) throws ApiException {
        ApiResponse<RefundDetails> resp = this.getRefundDetailsWithHttpInfo(merchantRefundId);
        return resp.getData();
    }

    protected ApiResponse<RefundDetails> getRefundDetailsWithHttpInfo(String merchantRefundId) throws ApiException {
        Call call = this.getRefundDetailsValidateBeforeCall(merchantRefundId);
        Type localVarReturnType = new TypeToken<RefundDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_getRefundDetails");
    }

    private Call refundPaymentValidateBeforeCall(Object body) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v2/refunds", body, null);
    }

    public RefundDetails refundPayment(Refund body) throws ApiException {
        ApiUtil.validateObject(this.validator, body);
        ApiResponse<RefundDetails> resp = this.refundPaymentWithHttpInfo(body);
        return resp.getData();
    }

    protected ApiResponse<RefundDetails> refundPaymentWithHttpInfo(Object body) throws ApiException {
        Call call = this.refundPaymentValidateBeforeCall(body);
        Type localVarReturnType = new TypeToken<RefundDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_createRefundPayment");
    }

    private Call revertAuthValidateBeforeCall(Object body) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v2/payments/preauthorize/revert", body, null);
    }

    public RevertAuthResponse revertAuth(Object body) throws ApiException {
        ApiResponse<RevertAuthResponse> resp = this.revertAuthWithHttpInfo(body);
        return resp.getData();
    }

    protected ApiResponse<RevertAuthResponse> revertAuthWithHttpInfo(Object body) throws ApiException {
        Call call = this.revertAuthValidateBeforeCall(body);
        Type localVarReturnType = new TypeToken<RevertAuthResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_revertAuthorizedOrder");
    }

    public LinkQRCodeResponse createAccountLinkQRCode(AccountLinkQRCode body) throws ApiException {
        ApiUtil.validateObject(this.validator, body);
        ApiResponse<LinkQRCodeResponse> resp = this.createAccountLinkQRCodeWithHttpInfo(body);
        return resp.getData();
    }

    protected ApiResponse<LinkQRCodeResponse> createAccountLinkQRCodeWithHttpInfo(Object body) throws ApiException {
        Call call = this.createAccountLinkQrCodeCall(body);
        Type localVarReturnType = new TypeToken<LinkQRCodeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v1_qrSession");
    }

    private Call createAccountLinkQrCodeCall(Object body) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v1/qr/sessions", body, null);
    }

    public PaymentDetails createPaymentAuthorization(Payment body, String agreeSimilarTransaction) throws ApiException {
        ApiUtil.validateObject(this.validator, body);
        ApiResponse<PaymentDetails> resp = this.createPaymentAuthorizationWithHttpInfo(body, agreeSimilarTransaction);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> createPaymentAuthorizationWithHttpInfo(Object body, String agreeSimilarTransaction) throws ApiException {
        Call call = ApiUtil.postCallObject(this.apiClient, "/v2/payments/preauthorize", body, agreeSimilarTransaction);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v2_createOrderAndAuthorize");
    }

    public PaymentDetails createContinuousPayment(Payment body) throws ApiException {
        ApiUtil.validateObject(this.validator, body);
        ApiResponse<PaymentDetails> resp = this.createContinuousPaymentWithHttpInfo(body);
        return resp.getData();
    }

    protected ApiResponse<PaymentDetails> createContinuousPaymentWithHttpInfo(Object body) throws ApiException {
        Call call = this.createContinuousPaymentCall(body);
        Type localVarReturnType = new TypeToken<PaymentDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType, "v1_createSubscriptionPayment");
    }

    private Call createContinuousPaymentCall(Object body) throws ApiException {
        return ApiUtil.postCallObject(this.apiClient, "/v1/subscription/payments", body, null);
    }
}

