/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay.api;

import com.squareup.okhttp.Call;
import java.util.ArrayList;
import java.util.HashMap;
import jp.ne.paypay.ApiClient;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.Pair;
import jp.ne.paypay.Validator;
import org.apache.commons.lang3.StringUtils;

public class ApiUtil {
    public static Call getCallObject(ApiClient apiClient, String url, Pair pair, String method) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)pair.getValue())) {
            throw new IllegalArgumentException("Missing the required parameter" + pair.getName());
        }
        String localVarPath = url.replaceAll("\\{" + pair.getName() + "}", apiClient.escapeString(pair.getValue()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"HmacAuth"};
        apiClient.setReadTimeout(15);
        return apiClient.buildCall(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, null, localVarHeaderParams, localVarFormParams, localVarAuthNames);
    }

    public static void validateObject(Validator validator, Object body) {
        String message = validator.validate(body);
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Call postCallObject(ApiClient apiClient, String url, Object body, String agreeSimilarTransaction) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (agreeSimilarTransaction != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("agreeSimilarTransaction", agreeSimilarTransaction));
        }
        String localVarAccept = apiClient.selectHeaderAccept(new String[]{"application/json"});
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String localVarContentType = apiClient.selectHeaderContentType(new String[0]);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"HmacAuth"};
        apiClient.setReadTimeout(30);
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        return apiClient.buildCall(url, "POST", localVarQueryParams, localVarCollectionQueryParams, body, localVarHeaderParams, localVarFormParams, localVarAuthNames);
    }

    public static String buildResolveUrl(String apiName, String code, String codeId) {
        String resolveUrl = "https://developer.paypay.ne.jp/develop/resolve?api_name=%s&code=%s&code_id=%s";
        return String.format(resolveUrl, apiName, code, codeId);
    }
}

