/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.paypay;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.http.HttpMethod;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ne.paypay.ApiException;
import jp.ne.paypay.ApiResponse;
import jp.ne.paypay.JSON;
import jp.ne.paypay.Pair;
import jp.ne.paypay.api.ApiUtil;
import jp.ne.paypay.auth.Authentication;
import jp.ne.paypay.auth.HmacAuth;
import jp.ne.paypay.model.NotDataResponse;
import jp.ne.paypay.model.ResponseParameters;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.lang3.StringUtils;

public class ApiClient {
    private String basePath = "https://stg-api.sandbox.paypay.ne.jp";
    private String basePathProd = "https://api.paypay.ne.jp";
    private String basePathSandbox = "https://stg-api.sandbox.paypay.ne.jp";
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private Map<String, Authentication> authentications;
    private OkHttpClient httpClient = new OkHttpClient();
    private JSON json = new JSON();
    private String assumeMerchant;
    private boolean productionMode;

    public ApiClient() {
        this.setUserAgent("PayPay-SDK/1.0.1/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("HmacAuth", new HmacAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    public String getBasePathProd() {
        return this.basePathProd;
    }

    public ApiClient setBasePathProd(String basePathProd) {
        this.basePathProd = basePathProd;
        return this;
    }

    public String getBasePathSandbox() {
        return this.basePathSandbox;
    }

    public ApiClient setBasePathSandbox(String basePathSandbox) {
        this.basePathSandbox = basePathSandbox;
        return this;
    }

    public Map<String, String> getDefaultHeaderMap() {
        return this.defaultHeaderMap;
    }

    public ApiClient setDefaultHeaderMap(Map<String, String> defaultHeaderMap) {
        this.defaultHeaderMap = defaultHeaderMap;
        return this;
    }

    public ApiClient setAuthentications(Map<String, Authentication> authentications) {
        this.authentications = authentications;
        return this;
    }

    public JSON getJson() {
        return this.json;
    }

    public ApiClient setJson(JSON json) {
        this.json = json;
        return this;
    }

    public ApiClient setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
        this.basePath = productionMode ? this.basePathProd : this.basePathSandbox;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getAssumeMerchant() {
        return this.assumeMerchant;
    }

    public ApiClient setAssumeMerchant(String assumeMerchant) {
        if (StringUtils.isNotBlank((CharSequence)assumeMerchant)) {
            this.assumeMerchant = assumeMerchant;
            this.addDefaultHeader("X-ASSUME-MERCHANT", this.assumeMerchant);
        }
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setApiKey(String apiKey) throws ApiException {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HmacAuth)) continue;
            ((HmacAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new ApiException("HMAC authentication not configured: API key");
    }

    private void setRequestParameters(String requestUrl, String method, Object requestBody, String contentType) {
        String body = requestBody != null ? this.json.serialize(requestBody) : null;
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HmacAuth)) continue;
            ((HmacAuth)auth).setRequestUrl(requestUrl).setHttpMethod(method).setRequestBody(body).setContentType(contentType);
            return;
        }
        throw new RuntimeException("HMAC authentication not configured: API key");
    }

    public void setApiSecretKey(String apiSecret) throws ApiException {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HmacAuth)) continue;
            ((HmacAuth)auth).setApiSecretKey(apiSecret);
            return;
        }
        throw new ApiException("HMAC authentication not configured: API Secret key");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public ApiClient setReadTimeout(int readTimeoutInSeconds) {
        this.httpClient.setReadTimeout((long)readTimeoutInSeconds, TimeUnit.SECONDS);
        return this;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = this.json.serialize(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "");
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return String.join((CharSequence)",", accepts);
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json;charset=UTF-8";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        if (returnType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            return this.json.deserialize(respBody, returnType);
        }
        if (returnType.equals(String.class)) {
            return (T)respBody;
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])((byte[])obj));
        }
        if (obj instanceof File) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)((File)obj));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? this.json.serialize(obj) : null;
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content);
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        BufferedSink sink = null;
        try {
            File file = this.prepareDownloadFile(response);
            sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)response.body().source());
            sink.close();
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        finally {
            if (sink != null) {
                try {
                    sink.close();
                }
                catch (IOException e) {
                    throw new ApiException(e);
                }
            }
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        String prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        return File.createTempFile(prefix, suffix);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType, String apiName) throws ApiException {
        try {
            Response response = call.execute();
            ResponseParameters responseParameters = new ResponseParameters().setResponse(response).setApiName(apiName).setReturnType(returnType);
            T data = this.handleResponse(responseParameters);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public <T> T handleResponse(ResponseParameters params) throws ApiException {
        Response response = params.getResponse();
        if (response.isSuccessful()) {
            if (params.getReturnType() == null || response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (IOException e) {
                        throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                    }
                }
                return null;
            }
            return this.deserialize(response, params.getReturnType());
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody).setResolveUrl(this.getResolveUrl(params.getApiName(), respBody));
    }

    private String getResolveUrl(String apiName, String respBody) {
        NotDataResponse responseBody = (NotDataResponse)this.json.deserialize(respBody, new TypeToken<NotDataResponse>(){}.getType());
        String resolveUrl = null;
        if (StringUtils.isNotEmpty((CharSequence)apiName) && responseBody.getResultInfo() != null) {
            resolveUrl = ApiUtil.buildResolveUrl(apiName, responseBody.getResultInfo().getCode(), responseBody.getResultInfo().getCodeId());
            System.out.println("This link helps you to troubleshoot the issue: " + resolveUrl);
        }
        return resolveUrl;
    }

    public Call buildCall(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames) throws ApiException {
        this.setRequestParameters(path, method, body, headerParams.get("Content-Type"));
        Request request = this.buildRequest(path, method, queryParams, collectionQueryParams, body, headerParams, formParams, authNames);
        System.out.println("\nAPI: " + request.method() + " " + request.url());
        return this.httpClient.newCall(request);
    }

    public Request buildRequest(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames) throws ApiException {
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        String url = this.buildUrl(path, queryParams, collectionQueryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, reqBuilder);
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        Object reqBody = !HttpMethod.permitsRequestBody((String)method) ? null : ("application/x-www-form-urlencoded".equals(contentType) ? this.buildRequestBodyFormEncoding(formParams) : (body == null ? ("DELETE".equals(method) ? null : RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)"")) : this.serialize(body, contentType)));
        return reqBuilder.method(method, reqBody).build();
    }

    public String buildUrl(String path, List<Pair> queryParams, List<Pair> collectionQueryParams) {
        String value;
        String prefix;
        StringBuilder url = new StringBuilder();
        url.append(this.basePath).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Pair param : collectionQueryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) throws ApiException {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new ApiException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }
}

