/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.MultiMap;
import java.util.List;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.core.Handler;
import io.vertx.reactivex.core.net.NetSocket;

/**
 * Represents a client-side HTTP response.
 * <p>
 * Vert.x provides you with one of these via the handler that was provided when creating the {@link io.vertx.reactivex.core.http.HttpClientRequest}
 * or that was set on the {@link io.vertx.reactivex.core.http.HttpClientRequest} instance.
 * <p>
 * It implements {@link io.vertx.reactivex.core.streams.ReadStream} so it can be used with
 * {@link io.vertx.reactivex.core.streams.Pump} to pump data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClientResponse original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.http.HttpClientResponse.class)
public class HttpClientResponse implements ReadStream<Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClientResponse that = (HttpClientResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<HttpClientResponse> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new HttpClientResponse((io.vertx.core.http.HttpClientResponse) obj),
    HttpClientResponse::getDelegate
  );

  private final io.vertx.core.http.HttpClientResponse delegate;
  
  public HttpClientResponse(io.vertx.core.http.HttpClientResponse delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.HttpClientResponse getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<Buffer> observable;
  private io.reactivex.Flowable<Buffer> flowable;

  public synchronized io.reactivex.Observable<Buffer> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<Buffer> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  public HttpClientResponse resume() { 
    delegate.resume();
    return this;
  }

  public HttpClientResponse exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public HttpClientResponse handler(Handler<Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  public HttpClientResponse pause() { 
    delegate.pause();
    return this;
  }

  public HttpClientResponse endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return the version of the response
   */
  public HttpVersion version() { 
    HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the status code of the response
   */
  public int statusCode() { 
    int ret = delegate.statusCode();
    return ret;
  }

  /**
   * @return the status message of the response
   */
  public String statusMessage() { 
    String ret = delegate.statusMessage();
    return ret;
  }

  /**
   * @return the headers
   */
  public MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    MultiMap ret = MultiMap.newInstance(delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(String headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * Return the first trailer value with the specified name
   * @param trailerName the trailer name
   * @return the trailer value
   */
  public String getTrailer(String trailerName) { 
    String ret = delegate.getTrailer(trailerName);
    return ret;
  }

  /**
   * @return the trailers
   */
  public MultiMap trailers() { 
    if (cached_1 != null) {
      return cached_1;
    }
    MultiMap ret = MultiMap.newInstance(delegate.trailers());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public List<String> cookies() { 
    if (cached_2 != null) {
      return cached_2;
    }
    List<String> ret = delegate.cookies();
    cached_2 = ret;
    return ret;
  }

  /**
   * Convenience method for receiving the entire request body in one piece.
   * <p>
   * This saves you having to manually set a dataHandler and an endHandler and append the chunks of the body until
   * the whole body received. Don't use this if your request body is large - you could potentially run out of RAM.
   * @param bodyHandler This handler will be called after all the body has been received
   * @return 
   */
  public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) { 
    delegate.bodyHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        bodyHandler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set an custom frame handler. The handler will get notified when the http stream receives an custom HTTP/2
   * frame. HTTP/2 permits extension of the protocol.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) { 
    delegate.customFrameHandler(new Handler<io.vertx.core.http.HttpFrame>() {
      public void handle(io.vertx.core.http.HttpFrame event) {
        handler.handle(HttpFrame.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Get a net socket for the underlying connection of this request.
   * <p>
   * USE THIS WITH CAUTION! Writing to the socket directly if you don't know what you're doing can easily break the HTTP protocol
   * <p>
   * One valid use-case for calling this is to receive the {@link io.vertx.reactivex.core.net.NetSocket} after a HTTP CONNECT was issued to the
   * remote peer and it responded with a status code of 200.
   * @return the net socket
   */
  public NetSocket netSocket() { 
    if (cached_3 != null) {
      return cached_3;
    }
    NetSocket ret = NetSocket.newInstance(delegate.netSocket());
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the corresponding request
   */
  public HttpClientRequest request() { 
    if (cached_4 != null) {
      return cached_4;
    }
    HttpClientRequest ret = HttpClientRequest.newInstance(delegate.request());
    cached_4 = ret;
    return ret;
  }

  private MultiMap cached_0;
  private MultiMap cached_1;
  private List<String> cached_2;
  private NetSocket cached_3;
  private HttpClientRequest cached_4;

  public static  HttpClientResponse newInstance(io.vertx.core.http.HttpClientResponse arg) {
    return arg != null ? new HttpClientResponse(arg) : null;
  }
}
