/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.core.Handler;

/**
 * A timeout stream is triggered by a timer, the {@link io.vertx.reactivex.core.Handler} will be call when the timer is fired,
 * it can be once or several times depending on the nature of the timer related to this stream. The
 *  will be called after the timer handler has been called.
 * <p>
 * Pausing the timer inhibits the timer shots until the stream is resumed. Setting a null handler callback cancels
 * the timer.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.TimeoutStream original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.TimeoutStream.class)
public class TimeoutStream implements ReadStream<Long> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeoutStream that = (TimeoutStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<TimeoutStream> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new TimeoutStream((io.vertx.core.TimeoutStream) obj),
    TimeoutStream::getDelegate
  );

  private final io.vertx.core.TimeoutStream delegate;
  
  public TimeoutStream(io.vertx.core.TimeoutStream delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.TimeoutStream getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<Long> observable;
  private io.reactivex.Flowable<Long> flowable;

  public synchronized io.reactivex.Observable<Long> toObservable() {
    if (observable == null) {
      observable = io.vertx.reactivex.ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<Long> toFlowable() {
    if (flowable == null) {
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }

  public TimeoutStream exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public TimeoutStream handler(Handler<Long> handler) { 
    delegate.handler(handler);
    return this;
  }

  public TimeoutStream pause() { 
    delegate.pause();
    return this;
  }

  public TimeoutStream resume() { 
    delegate.resume();
    return this;
  }

  public TimeoutStream endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Cancels the timeout. Note this has the same effect as calling {@link io.vertx.reactivex.core.TimeoutStream#handler} with a null
   * argument.
   */
  public void cancel() { 
    delegate.cancel();
  }


  public static  TimeoutStream newInstance(io.vertx.core.TimeoutStream arg) {
    return arg != null ? new TimeoutStream(arg) : null;
  }
}
