/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetSocket;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg<NetClient>(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public NetClient connect(int port, String host, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<NetSocket> connectObservable(int port, String host) {
        ObservableFuture<NetSocket> connectHandler = RxHelper.observableFuture();
        this.connect(port, host, connectHandler.toHandler());
        return connectHandler;
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(port, host, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public NetClient connect(int port, String host, String serverName, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, serverName, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<NetSocket> connectObservable(int port, String host, String serverName) {
        ObservableFuture<NetSocket> connectHandler = RxHelper.observableFuture();
        this.connect(port, host, serverName, connectHandler.toHandler());
        return connectHandler;
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

