/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.Future;
import io.vertx.rxjava.core.metrics.Measured;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor
implements Measured {
    public static final TypeArg<WorkerExecutor> __TYPE_ARG = new TypeArg<WorkerExecutor>(obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor)obj), WorkerExecutor::getDelegate);
    private final io.vertx.core.WorkerExecutor delegate;

    public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.WorkerExecutor getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, boolean ordered, final Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(Future.newInstance(event, TypeArg.unknown()));
            }
        }, ordered, new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler, boolean ordered) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.executeBlocking(blockingCodeHandler, ordered, resultHandler.toHandler());
        return resultHandler;
    }

    public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.executeBlocking(blockingCodeHandler, ordered, (Handler)fut)));
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, final Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(Future.newInstance(event, TypeArg.unknown()));
            }
        }, new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.executeBlocking(blockingCodeHandler, resultHandler.toHandler());
        return resultHandler;
    }

    public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.executeBlocking(blockingCodeHandler, (Handler)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public static WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
        return arg != null ? new WorkerExecutor(arg) : null;
    }
}

