/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.takamaka.wallet.InstanceWalletKeyStoreBCED25519;
import io.takamaka.wallet.InstanceWalletKeyStoreBCQTESLAPSSC1Round1;
import io.takamaka.wallet.InstanceWalletKeyStoreBCQTESLAPSSC1Round2;
import io.takamaka.wallet.InstanceWalletKeystoreInterface;
import io.takamaka.wallet.beans.EncKeyBean;
import io.takamaka.wallet.beans.EncWordsBean;
import io.takamaka.wallet.beans.KeyBean;
import io.takamaka.wallet.beans.PublicKeyBean;
import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.exceptions.InvalidCypherException;
import io.takamaka.wallet.exceptions.InvalidWalletIndexException;
import io.takamaka.wallet.exceptions.PublicKeySerializzationException;
import io.takamaka.wallet.exceptions.UnlockWalletException;
import io.takamaka.wallet.exceptions.WalletException;
import io.takamaka.wallet.utils.DefaultInitParameters;
import io.takamaka.wallet.utils.FileHelper;
import io.takamaka.wallet.utils.FixedParameters;
import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.SeedGenerator;
import io.takamaka.wallet.utils.TkmSignUtils;
import io.takamaka.wallet.utils.TkmTextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletHelper {
    private static final Logger log = LoggerFactory.getLogger(WalletHelper.class);

    public static InstanceWalletKeystoreInterface readWallet(String filename, String password) throws InvalidCypherException, FileNotFoundException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnlockWalletException, WalletException {
        Path pt = Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), filename + DefaultInitParameters.WALLET_EXTENSION);
        return WalletHelper.readWalletInternal(filename, pt, password);
    }

    public static InstanceWalletKeystoreInterface readWalletRecoveryGui(String filename, String password) throws InvalidCypherException, FileNotFoundException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnlockWalletException, WalletException {
        Path pt = Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), filename);
        return WalletHelper.readWalletInternal(filename, pt, password);
    }

    private static InstanceWalletKeystoreInterface readWalletInternal(String filename, Path pt, String password) throws InvalidCypherException, FileNotFoundException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnlockWalletException, WalletException {
        KeyBean key = WalletHelper.readKeyFile(pt, password);
        switch (key.getCypher()) {
            case Ed25519BC: {
                return new InstanceWalletKeyStoreBCED25519(filename, password);
            }
            case BCQTESLA_PS_1: {
                return new InstanceWalletKeyStoreBCQTESLAPSSC1Round1(filename, password);
            }
            case BCQTESLA_PS_1_R2: {
                return new InstanceWalletKeyStoreBCQTESLAPSSC1Round2(filename, password);
            }
        }
        throw new InvalidCypherException();
    }

    public static String getRecoveryWords(String filename, String password) throws InvalidCypherException, FileNotFoundException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnlockWalletException {
        KeyBean key = WalletHelper.readKeyFile(Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), filename + DefaultInitParameters.WALLET_EXTENSION), password);
        return key.getWords();
    }

    public static Path writeKeyFile(Path path, String filename, KeyBean key, String password) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        String json = TkmTextUtils.toJson(key);
        try {
            SecretKeySpec sk = new SecretKeySpec(TkmSignUtils.PWHash(password, "TakamakaWallet", 1, 256), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, sk);
            byte[][] encJson = new byte[][]{cipher.getIV(), cipher.doFinal(json.getBytes(FixedParameters.CHARSET))};
            EncKeyBean ekb = new EncKeyBean("AES", encJson);
            FileHelper.writeStringToFile(path, filename, TkmTextUtils.toJson(ekb), false);
            Path walletPath = Paths.get(path.toString(), filename);
            log.info("WALLET WRITTEN IN " + Paths.get(path.toString(), filename).toString());
            return walletPath;
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | InvalidKeySpecException ex) {
            log.error("writeKeyFile error", (Throwable)ex);
            return null;
        }
    }

    public static KeyBean readKeyFile(Path filename, String password) throws FileNotFoundException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnlockWalletException {
        String encJson;
        try {
            encJson = FileHelper.readStringFromFile(filename);
        }
        catch (IOException ex) {
            log.error("error reading encoded file");
            throw new UnlockWalletException("error reading encoded file", ex);
        }
        byte[][] wallet = TkmTextUtils.enckeyBeanFromJson(encJson).getWallet();
        try {
            byte[] passwordDigest = TkmSignUtils.PWHash(password, "TakamakaWallet", 1, 256);
            SecretKeySpec sk = new SecretKeySpec(passwordDigest, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)sk, new IvParameterSpec(wallet[0]));
            String json = new String(cipher.doFinal(wallet[1]));
            return TkmTextUtils.keyBeanFromJson(json);
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException ex) {
            log.error("key file read error", (Throwable)ex);
            throw new UnlockWalletException();
        }
    }

    public static final KeyBean readEncFile(Path filename, String password) throws FileNotFoundException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnlockWalletException {
        String encJson;
        try {
            encJson = FileHelper.readStringFromFile(filename);
        }
        catch (IOException ex) {
            log.error("error reading encoded file");
            throw new UnlockWalletException("error reading encoded file", ex);
        }
        try {
            EncWordsBean ewb = (EncWordsBean)TkmTextUtils.getJacksonMapper().readValue(encJson, EncWordsBean.class);
            byte[][] wallet = ewb.getEb().getWallet();
            try {
                byte[] passwordDigest = TkmSignUtils.PWHash(password, "TakamakaWallet", 1, 256);
                SecretKeySpec sk = new SecretKeySpec(passwordDigest, "AES");
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(2, (Key)sk, new IvParameterSpec(wallet[0]));
                String json = new String(cipher.doFinal(wallet[1]));
                return TkmTextUtils.keyBeanFromJson(json);
            }
            catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException ex) {
                log.error("decode file exception", (Throwable)ex);
                throw new UnlockWalletException();
            }
        }
        catch (JsonProcessingException ex) {
            log.error("json decode file exception", (Throwable)ex);
            throw new UnlockWalletException(ex);
        }
    }

    public static Path importKeyFromWords(List<String> words, Path path, String filename, KeyContexts.WalletCypher cypher, String newPassword) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, WalletException {
        try {
            String seed = SeedGenerator.generateSeedPWH(words);
            Object concat = words.get(0);
            for (int i = 1; i < words.size(); ++i) {
                concat = (String)concat + " " + words.get(i);
            }
            KeyBean kb = new KeyBean("AES", cypher, seed, (String)concat);
            Path walltePath = WalletHelper.writeKeyFile(path, filename, kb, newPassword);
            return walltePath;
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | IOException | NoSuchProviderException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException ex) {
            log.error("import key error", (Throwable)ex);
            throw new WalletException("import key error", ex);
        }
    }

    public static boolean verifyWordsIntegrity(List<String> words) {
        return SeedGenerator.verifySeedWords(words);
    }

    public static void writePublicKey(String walletname, String password, int keyIndex, KeyContexts.WalletCypher cypher) throws InvalidCypherException, InvalidWalletIndexException, PublicKeySerializzationException, UnlockWalletException, IOException, WalletException {
        switch (cypher) {
            case Ed25519BC: {
                InstanceWalletKeyStoreBCED25519 wallet = new InstanceWalletKeyStoreBCED25519(walletname, password);
                String pk = wallet.getPublicKeyAtIndexURL64(keyIndex);
                PublicKeyBean pkb = new PublicKeyBean(cypher, "0.1", pk);
                FileHelper.writeStringToFile(FileHelper.getPublicKeyDirectoryPath(), walletname + ".public", TkmTextUtils.toJson(pkb), false);
                break;
            }
            case BCQTESLA_PS_1: {
                InstanceWalletKeyStoreBCQTESLAPSSC1Round1 walletQT = new InstanceWalletKeyStoreBCQTESLAPSSC1Round1(walletname, password);
                String pkQT = walletQT.getPublicKeyAtIndexURL64(keyIndex);
                PublicKeyBean pkbQT = new PublicKeyBean(cypher, "0.1", pkQT);
                FileHelper.writeStringToFile(FileHelper.getPublicKeyDirectoryPath(), walletname + ".public", TkmTextUtils.toJson(pkbQT), false);
                break;
            }
            case BCQTESLA_PS_1_R2: {
                InstanceWalletKeyStoreBCQTESLAPSSC1Round2 walletQTr2 = new InstanceWalletKeyStoreBCQTESLAPSSC1Round2(walletname, password);
                String pkQTr2 = walletQTr2.getPublicKeyAtIndexURL64(keyIndex);
                PublicKeyBean pkbQTr2 = new PublicKeyBean(cypher, "0.1", pkQTr2);
                FileHelper.writeStringToFile(FileHelper.getPublicKeyDirectoryPath(), walletname + ".public", TkmTextUtils.toJson(pkbQTr2), false);
                break;
            }
            default: {
                throw new InvalidCypherException();
            }
        }
    }

    public static PublicKeyBean readPublicKey(String publicKeyName) throws WalletException {
        try {
            String json = FileHelper.readStringFromFile(Paths.get(FileHelper.getPublicKeyDirectoryPath().toString(), publicKeyName + ".public"));
            return TkmTextUtils.publicKeyBeanFromJson(json);
        }
        catch (IOException ex) {
            log.error(FixedParameters.WalletError.PKEY_READ.name(), (Throwable)ex);
            throw new WalletException("error reading public key bean", ex);
        }
    }

    public static Map<String, PublicKeyBean> listPublicKeys() throws WalletException {
        File[] listOfFiles;
        LinkedHashMap<String, PublicKeyBean> ret = new LinkedHashMap<String, PublicKeyBean>();
        File folder = new File(FileHelper.getPublicKeyDirectoryPath().toString());
        for (File f : listOfFiles = folder.listFiles()) {
            if (!f.isFile()) continue;
            String p = f.getName().substring(0, f.getName().length() - ".public".length());
            ret.put(p, WalletHelper.readPublicKey(p));
        }
        return ret;
    }
}

