/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.beans.ExtendedTransactionBox;
import io.takamaka.wallet.beans.InternalTransactionBean;
import io.takamaka.wallet.beans.InternalTransactionSyntaxBean;
import io.takamaka.wallet.beans.TransactionBean;
import io.takamaka.wallet.beans.TransactionBox;
import io.takamaka.wallet.beans.TransactionSyntaxBean;
import io.takamaka.wallet.utils.DefaultInitParameters;
import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.TkmSignUtils;
import io.takamaka.wallet.utils.TkmTK;
import io.takamaka.wallet.utils.TkmTextUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionUtils {
    private static final Logger log = LoggerFactory.getLogger(TransactionUtils.class);

    public static TransactionSyntaxBean isTransactionBeanValid(TransactionBean input) {
        TransactionSyntaxBean result = new TransactionSyntaxBean();
        result.setItsv(KeyContexts.TransactionSyntaxValidity.NULL_TB);
        result.setValidSyntax(false);
        if (input == null) {
            return result;
        }
        result.setItsv(KeyContexts.TransactionSyntaxValidity.INVALID_FIELD_VALUE);
        if (TkmTextUtils.isNullOrBlank(input.getPublicKey()) || TkmTextUtils.isNullOrBlank(input.getMessage()) || TkmTextUtils.isNullOrBlank(input.getRandomSeed()) || TkmTextUtils.isNullOrBlank(input.getSignature())) {
            result.setValidSyntax(false);
            return result;
        }
        boolean itbValid = false;
        try {
            InternalTransactionBean itb = TkmTextUtils.internalTransactionBeanFromJson(input.getMessage());
            InternalTransactionSyntaxBean internalTransactionBeanValid = TransactionUtils.isInternalTransactionBeanValid(itb);
            itbValid = internalTransactionBeanValid.isValidSyntax();
        }
        catch (Exception e) {
            log.error("Invalid json " + e.getLocalizedMessage());
            return result;
        }
        result.setValidSyntax(true & itbValid);
        return result;
    }

    public static InternalTransactionSyntaxBean isInternalTransactionBeanValid(InternalTransactionBean input) {
        InternalTransactionSyntaxBean result = new InternalTransactionSyntaxBean();
        result.setItsv(KeyContexts.InternalTransactionSyntaxValidity.NULL_ITB);
        result.setValidSyntax(false);
        if (input == null) {
            return result;
        }
        result.setItsv(KeyContexts.InternalTransactionSyntaxValidity.INVALID_FIELD_VALUE);
        if (input.getTransactionType() == null || input.getNotBefore() == null || TkmTextUtils.isNullOrBlank(input.getTransactionHash())) {
            return result;
        }
        switch (input.getTransactionType()) {
            case ASSIGN_OVERFLOW: {
                if (TkmTextUtils.isNullOrBlank(input.getTo()) || TkmTextUtils.isNullOrBlank(input.getFrom())) {
                    return result;
                }
                if (!ArrayUtils.contains((int[])DefaultInitParameters.TO_DATA_LENGTH_WHITELIST, (int)input.getTo().length())) {
                    return result;
                }
                String toB64String = TkmSignUtils.fromB64UrlToHEX(input.getTo());
                if (!TkmTextUtils.isNullOrBlank(toB64String)) break;
                log.error("MORTE!!!!! " + input.getTo());
                return result;
            }
            case UNASSIGN_OVERFLOW: {
                if (TkmTextUtils.isNullOrBlank(input.getTo()) || TkmTextUtils.isNullOrBlank(input.getFrom())) {
                    return result;
                }
                if (!ArrayUtils.contains((int[])DefaultInitParameters.TO_DATA_LENGTH_WHITELIST, (int)input.getTo().length())) {
                    return result;
                }
                String toB64String = TkmSignUtils.fromB64UrlToHEX(input.getTo());
                if (!TkmTextUtils.isNullOrBlank(toB64String)) break;
                log.error("MORTE!!!!! " + input.getTo());
                return result;
            }
            case BLOB: {
                if (!TkmTextUtils.isNullOrBlank(input.getMessage()) && !TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case BLOCK: {
                result.setExtendedMessage("Found incompatible transaction type for an InternalTransactionBean: BLOCK");
                return result;
            }
            case BLOCK_HASH: {
                if (!TkmTextUtils.isNullOrBlank(input.getMessage()) && !TkmTextUtils.isNullOrBlank(input.getFrom()) && input.getEpoch() != null && input.getSlot() != null) break;
                return result;
            }
            case COINBASE: {
                if (TkmTextUtils.isNullOrBlank(input.getTo()) || input.getEpoch() == null || input.getSlot() == null || input.getGreenValue() == null) {
                    return result;
                }
                if (!ArrayUtils.contains((int[])DefaultInitParameters.TO_DATA_LENGTH_WHITELIST, (int)input.getTo().length())) {
                    return result;
                }
                String toB64String = TkmSignUtils.fromB64UrlToHEX(input.getTo());
                if (!TkmTextUtils.isNullOrBlank(toB64String)) break;
                log.error("MORTE!!!!! " + input.getTo());
                return result;
            }
            case S_CONTRACT_DEPLOY: {
                if (!TkmTextUtils.isNullOrBlank(input.getMessage()) && !TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case S_CONTRACT_CALL: 
            case S_CONTRACT_INSTANCE: {
                if (!TkmTextUtils.isNullOrBlank(input.getMessage()) && !TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case DECLARATION: {
                if (TkmTextUtils.isNullOrBlank(input.getTo()) || input.getGreenValue() == null && input.getRedValue() == null || input.getGreenValue() != null && input.getGreenValue().compareTo(BigInteger.ZERO) <= 0 && input.getRedValue() != null && input.getRedValue().compareTo(BigInteger.ZERO) <= 0) {
                    return result;
                }
                if (!ArrayUtils.contains((int[])DefaultInitParameters.TO_DATA_LENGTH_WHITELIST, (int)input.getTo().length())) {
                    return result;
                }
                String toB64String = TkmSignUtils.fromB64UrlToHEX(input.getTo());
                if (!TkmTextUtils.isNullOrBlank(toB64String)) break;
                log.error("MORTE!!!!! " + input.getTo());
                return result;
            }
            case DEREGISTER_MAIN: {
                if (!TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case DEREGISTER_OVERFLOW: {
                if (!TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case PAY: {
                if (input.getGreenValue() != null && input.getGreenValue().compareTo(BigInteger.ZERO) < 0 || input.getRedValue() != null && input.getRedValue().compareTo(BigInteger.ZERO) < 0 || input.getRedValue() == null && input.getGreenValue() == null || input.getRedValue() == null && input.getGreenValue() != null && input.getGreenValue().compareTo(BigInteger.ZERO) == 0 || input.getGreenValue() == null && input.getRedValue() != null && input.getRedValue().compareTo(BigInteger.ZERO) == 0 || input.getRedValue() != null && input.getGreenValue() != null && input.getGreenValue().compareTo(BigInteger.ZERO) == 0 && input.getRedValue().compareTo(BigInteger.ZERO) == 0) {
                    BigInteger green = input.getGreenValue();
                    BigInteger red = input.getRedValue();
                    boolean a = input.getGreenValue() != null && input.getGreenValue().compareTo(BigInteger.ZERO) < 0;
                    boolean b = input.getRedValue() != null && input.getRedValue().compareTo(BigInteger.ZERO) < 0;
                    boolean c = input.getRedValue() == null && input.getGreenValue() == null;
                    boolean d = input.getRedValue() == null && input.getGreenValue() != null && input.getGreenValue().compareTo(BigInteger.ZERO) == 0;
                    boolean e = input.getGreenValue() == null && input.getRedValue() != null && input.getRedValue().compareTo(BigInteger.ZERO) == 0;
                    boolean f = input.getRedValue() != null && input.getGreenValue() != null && input.getGreenValue().compareTo(BigInteger.ZERO) == 0 && input.getRedValue().compareTo(BigInteger.ZERO) == 0;
                    return result;
                }
                String toB64String = TkmSignUtils.fromB64UrlToHEX(input.getTo());
                if (!TkmTextUtils.isNullOrBlank(toB64String)) break;
                return result;
            }
            case PREVIOUS_BLOCK: {
                if (!TkmTextUtils.isNullOrBlank(input.getMessage()) && !TkmTextUtils.isNullOrBlank(input.getFrom()) && input.getEpoch() != null && input.getSlot() != null) break;
                return result;
            }
            case REGISTER_MAIN: {
                if (!TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case REGISTER_OVERFLOW: {
                if (!TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case STAKE: {
                if (TkmTextUtils.isNullOrBlank(input.getTo()) || TkmTextUtils.isNullOrBlank(input.getFrom()) || input.getGreenValue() == null || input.getGreenValue().compareTo(BigInteger.ZERO) <= 0 | input.getGreenValue().compareTo(TkmTK.unitTK(DefaultInitParameters.MINIMUM_STAKE_BET_UNIT)) < 0) {
                    return result;
                }
                if (!ArrayUtils.contains((int[])DefaultInitParameters.TO_DATA_LENGTH_WHITELIST, (int)input.getTo().length())) {
                    return result;
                }
                String toB64String = TkmSignUtils.fromB64UrlToHEX(input.getTo());
                if (!TkmTextUtils.isNullOrBlank(toB64String)) break;
                log.error("MORTE!!!!! " + input.getTo());
                return result;
            }
            case STAKE_UNDO: {
                if (!TkmTextUtils.isNullOrBlank(input.getFrom())) break;
                return result;
            }
            case STATE_POINTER_TRANSACTION: {
                if (!TkmTextUtils.isNullOrBlank(input.getMessage()) && !TkmTextUtils.isNullOrBlank(input.getFrom()) && !TkmTextUtils.isNullOrBlank(input.getTo()) && input.getEpoch() != null && input.getSlot() != null) break;
                return result;
            }
            default: {
                return result;
            }
        }
        result.setValidSyntax(true);
        return result;
    }

    public static ConcurrentSkipListMap<KeyContexts.TransactionType, ConcurrentSkipListSet<TransactionBox>> splitByType(TransactionBox[] transactions) {
        ConcurrentSkipListMap<KeyContexts.TransactionType, ConcurrentSkipListSet<TransactionBox>> res = new ConcurrentSkipListMap<KeyContexts.TransactionType, ConcurrentSkipListSet<TransactionBox>>();
        ((Stream)Arrays.stream(KeyContexts.TransactionType.values()).parallel()).forEach(type -> res.put((KeyContexts.TransactionType)((Object)type), new ConcurrentSkipListSet()));
        if (transactions != null) {
            ((Stream)Arrays.stream(transactions).parallel()).filter(tbox -> tbox != null).filter(tbox -> tbox.isValid()).forEach(tbox -> ((ConcurrentSkipListSet)res.get((Object)tbox.type())).add(tbox));
        }
        return res;
    }

    public static ConcurrentSkipListMap<KeyContexts.TransactionType, ConcurrentSkipListSet<ExtendedTransactionBox>> splitByType(ExtendedTransactionBox[] transactions) {
        ConcurrentSkipListMap<KeyContexts.TransactionType, ConcurrentSkipListSet<ExtendedTransactionBox>> res = new ConcurrentSkipListMap<KeyContexts.TransactionType, ConcurrentSkipListSet<ExtendedTransactionBox>>();
        ((Stream)((Stream)Arrays.stream(KeyContexts.TransactionType.values()).unordered()).parallel()).forEach(type -> res.put((KeyContexts.TransactionType)((Object)type), new ConcurrentSkipListSet()));
        if (transactions != null) {
            ((Stream)((Stream)Arrays.stream(transactions).unordered()).parallel()).filter(tbox -> tbox != null).filter(tbox -> tbox.isValid()).forEach(tbox -> ((ConcurrentSkipListSet)res.get((Object)tbox.type())).add(tbox));
        }
        return res;
    }
}

