/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.beans.FeeBean;
import io.takamaka.wallet.beans.TransactionBox;
import io.takamaka.wallet.exceptions.WalletException;
import io.takamaka.wallet.utils.DefaultInitParameters;
import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.TkmSignUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionFeeCalculator {
    private static final Logger log = LoggerFactory.getLogger(TransactionFeeCalculator.class);

    public static FeeBean getFeeBean(TransactionBox tbox) throws WalletException {
        FeeBean ret;
        block6: {
            block4: {
                block5: {
                    ret = new FeeBean();
                    if (tbox == null) break block4;
                    if (!tbox.isValid()) break block5;
                    ret.setSith(tbox.getSingleInclusionTransactionHash());
                    ret.setAddr(tbox.from());
                    ret.setHexAddr(TkmSignUtils.fromB64UrlToHEX(tbox.from()));
                    switch (tbox.type()) {
                        case ASSIGN_OVERFLOW: 
                        case BLOB: 
                        case DEREGISTER_OVERFLOW: 
                        case PAY: 
                        case STAKE: 
                        case STAKE_UNDO: 
                        case UNASSIGN_OVERFLOW: 
                        case REGISTER_MAIN: 
                        case REGISTER_OVERFLOW: 
                        case S_CONTRACT_DEPLOY: 
                        case DEREGISTER_MAIN: 
                        case S_CREATE_ACCOUNT: 
                        case S_CONTRACT_CALL: {
                            ret.setCpu(BigInteger.ZERO);
                            ret.setMemory(BigInteger.ZERO);
                            ret.setDisk(new BigInteger("" + tbox.getTransactionJson().length()).multiply(DefaultInitParameters.DISK_SCALE).multiply(DefaultInitParameters.TARGET_CLIENT_NUMBER_MAX_BI).multiply(DefaultInitParameters.YEARS_MOORE_LAW).multiply(DefaultInitParameters.FEE_SCALE_MULT).divide(DefaultInitParameters.FEE_SCALE_DIV));
                            break block6;
                        }
                        case S_CONTRACT_INSTANCE: {
                            log.error("not yet implemented");
                            throw new WalletException("not implemented " + KeyContexts.TransactionType.S_CONTRACT_INSTANCE.name());
                        }
                        default: {
                            log.error("not yet implemented " + tbox.type().name());
                            throw new WalletException("not implemented " + tbox.type().name());
                        }
                    }
                }
                throw new WalletException("invalid tbox " + tbox.getTransactionJson());
            }
            throw new WalletException("null tbox");
        }
        return ret;
    }

    public static final BigDecimal getCostInTK(BigInteger cpuCost, BigInteger memCost, BigInteger diskCost) {
        return new BigDecimal(cpuCost.add(memCost.add(diskCost))).movePointLeft(DefaultInitParameters.NUMBER_OF_ZEROS);
    }

    public static final BigDecimal getCostInTK(FeeBean fb) {
        return TransactionFeeCalculator.getCostInTK(fb.getCpu(), fb.getMemory(), fb.getDisk());
    }
}

