/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.InstanceWalletKeystoreInterface;
import io.takamaka.wallet.TkmCypherProviderBCED25519;
import io.takamaka.wallet.TkmCypherProviderBCQTESLAPSSC1Round1;
import io.takamaka.wallet.TkmCypherProviderBCQTESLAPSSC1Round2;
import io.takamaka.wallet.beans.InternalBlockBean;
import io.takamaka.wallet.beans.InternalTransactionBean;
import io.takamaka.wallet.beans.TkmCypherBean;
import io.takamaka.wallet.beans.TransactionBean;
import io.takamaka.wallet.beans.TransactionBox;
import io.takamaka.wallet.beans.TransactionSyntaxBean;
import io.takamaka.wallet.exceptions.HashCompositionException;
import io.takamaka.wallet.exceptions.InclusionHashCreationException;
import io.takamaka.wallet.exceptions.NullInternalTransactionBeanException;
import io.takamaka.wallet.exceptions.TransactionCanNotBeCreatedException;
import io.takamaka.wallet.exceptions.TransactionCanNotBeSignedException;
import io.takamaka.wallet.exceptions.WalletException;
import io.takamaka.wallet.utils.TkmTextUtils;
import io.takamaka.wallet.utils.TransactionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkmWallet {
    private static final Logger log = LoggerFactory.getLogger(TkmWallet.class);

    public static TransactionBean createGenericTransaction(InternalTransactionBean itb, InstanceWalletKeystoreInterface iwk, int signKey) throws TransactionCanNotBeCreatedException {
        try {
            itb.setTransactionHash(TkmTextUtils.internalTransactionBeanHash(itb));
            TransactionBean tb = new TransactionBean();
            tb.setRandomSeed(TkmTextUtils.generateWalletRandomString());
            tb.setPublicKey(iwk.getPublicKeyAtIndexURL64(signKey));
            tb.setMessage(TkmTextUtils.toJson(itb));
            tb.setWalletCypher(iwk.getWalletCypher());
            TkmCypherBean signatureBean = new TkmCypherBean();
            switch (tb.getWalletCypher()) {
                case Ed25519BC: {
                    signatureBean = TkmCypherProviderBCED25519.sign(iwk.getKeyPairAtIndex(signKey), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                    if (signatureBean.isValid()) break;
                    throw new TransactionCanNotBeSignedException(signatureBean.getEx());
                }
                case BCQTESLA_PS_1: {
                    signatureBean = TkmCypherProviderBCQTESLAPSSC1Round1.sign(iwk.getKeyPairAtIndex(signKey), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                    if (signatureBean.isValid()) break;
                    throw new TransactionCanNotBeSignedException(signatureBean.getEx());
                }
                case BCQTESLA_PS_1_R2: {
                    signatureBean = TkmCypherProviderBCQTESLAPSSC1Round2.sign(iwk.getKeyPairAtIndex(signKey), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                    if (signatureBean.isValid()) break;
                    throw new TransactionCanNotBeSignedException(signatureBean.getEx());
                }
                default: {
                    signatureBean.setValid(false);
                    log.error("UNKNOWN CYPHER");
                }
            }
            tb.setSignature(signatureBean.getSignature());
            TransactionSyntaxBean transactionBeanValid = TransactionUtils.isTransactionBeanValid(tb);
            if (!transactionBeanValid.isValidSyntax()) {
                throw new TransactionCanNotBeCreatedException("invalid internal parameter " + transactionBeanValid.getExtendedMessage());
            }
            return tb;
        }
        catch (HashCompositionException | NullInternalTransactionBeanException | WalletException ex) {
            log.error("Error generating transaction", (Throwable)ex);
            throw new TransactionCanNotBeCreatedException(ex);
        }
    }

    public static TransactionBean createGenericTransaction(InternalBlockBean ibb, InstanceWalletKeystoreInterface iwk, int signKey) throws TransactionCanNotBeCreatedException {
        try {
            TransactionBean tb = new TransactionBean();
            tb.setRandomSeed(TkmTextUtils.generateWalletRandomString());
            tb.setPublicKey(iwk.getPublicKeyAtIndexURL64(signKey));
            tb.setMessage(TkmTextUtils.toJson(ibb));
            tb.setWalletCypher(iwk.getWalletCypher());
            TkmCypherBean signatureBean = new TkmCypherBean();
            switch (tb.getWalletCypher()) {
                case Ed25519BC: {
                    signatureBean = TkmCypherProviderBCED25519.sign(iwk.getKeyPairAtIndex(signKey), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                    if (signatureBean.isValid()) break;
                    throw new TransactionCanNotBeSignedException(signatureBean.getEx());
                }
                case BCQTESLA_PS_1: {
                    signatureBean = TkmCypherProviderBCQTESLAPSSC1Round1.sign(iwk.getKeyPairAtIndex(signKey), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                    if (signatureBean.isValid()) break;
                    throw new TransactionCanNotBeSignedException(signatureBean.getEx());
                }
                case BCQTESLA_PS_1_R2: {
                    signatureBean = TkmCypherProviderBCQTESLAPSSC1Round2.sign(iwk.getKeyPairAtIndex(signKey), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                    if (signatureBean.isValid()) break;
                    throw new TransactionCanNotBeSignedException(signatureBean.getEx());
                }
                default: {
                    signatureBean.setValid(false);
                    log.error("UNKNOWN CYPHER");
                }
            }
            tb.setSignature(signatureBean.getSignature());
            return tb;
        }
        catch (WalletException ex) {
            log.error("Error creating transaction", (Throwable)ex);
            throw new TransactionCanNotBeCreatedException(ex);
        }
    }

    public static TkmCypherBean verifySign(TransactionBean tb) {
        TkmCypherBean tcb = null;
        switch (tb.getWalletCypher()) {
            case Ed25519BC: {
                tcb = TkmCypherProviderBCED25519.verify(tb.getPublicKey(), tb.getSignature(), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                break;
            }
            case BCQTESLA_PS_1: {
                tcb = TkmCypherProviderBCQTESLAPSSC1Round1.verify(tb.getPublicKey(), tb.getSignature(), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                break;
            }
            case BCQTESLA_PS_1_R2: {
                tcb = TkmCypherProviderBCQTESLAPSSC1Round2.verify(tb.getPublicKey(), tb.getSignature(), tb.getMessage() + tb.getRandomSeed() + tb.getWalletCypher().name());
                break;
            }
            default: {
                tcb = new TkmCypherBean();
                tcb.setValid(false);
                log.error("CYPHER NOT IMPLEMENTED");
            }
        }
        if (!tcb.isValid()) {
            log.error("" + tb.getWalletCypher());
        }
        return tcb;
    }

    public static TransactionBox verifyTransactionIntegrity(String transactionJson) {
        TransactionBean tb = TkmTextUtils.transactionBeanFromJson(transactionJson);
        TransactionBox veriTransactionIntegrity = TkmWallet.verifyTransactionIntegrity(tb, transactionJson);
        return veriTransactionIntegrity;
    }

    public static TransactionBox verifyTransactionIntegrity(TransactionBean tb, String transactionJson) {
        TransactionBox result = new TransactionBox();
        boolean inclusionHashCreation = false;
        if (tb != null) {
            TkmCypherBean cyBean = TkmWallet.verifySign(tb);
            if (cyBean != null && cyBean.isValid()) {
                TransactionSyntaxBean transactionBeanValid = TransactionUtils.isTransactionBeanValid(tb);
                InternalTransactionBean itb = TkmTextUtils.internalTransactionBeanFromJson(tb.getMessage());
                boolean signerFieldsVerification = TkmWallet.verifySigner(tb, itb);
                if (!signerFieldsVerification) {
                    // empty if block
                }
                if (itb != null & signerFieldsVerification & transactionBeanValid.isValidSyntax()) {
                    try {
                        String sith = TkmTextUtils.singleTransactionInclusionHash(itb.getTransactionHash(), tb.getPublicKey(), tb.getSignature(), tb.getRandomSeed(), tb.getWalletCypher().name());
                        result.setSingleInclusionTransactionHash(sith);
                        result.setTb(tb);
                        result.setItb(itb);
                        result.setTransactionJson(transactionJson);
                        result.setValid(true);
                        inclusionHashCreation = true;
                    }
                    catch (InclusionHashCreationException ex) {
                        log.error("Transaction verification error", (Throwable)ex);
                        inclusionHashCreation = false;
                    }
                }
                cyBean = TkmWallet.verifyHashIntegrity(itb, cyBean);
                result.setValid(cyBean.isValid() & signerFieldsVerification & transactionBeanValid.isValidSyntax() & inclusionHashCreation);
                if (cyBean.getEx() != null) {
                    cyBean.getEx().printStackTrace();
                    log.error("INVALID!!");
                }
            } else {
                if (cyBean != null && cyBean.getEx() != null) {
                    cyBean.getEx().printStackTrace();
                }
                log.error("INVALID!!");
            }
        }
        return result;
    }

    public static final TkmCypherBean verifyHashIntegrity(InternalTransactionBean itb, TkmCypherBean cyBean) {
        if (cyBean == null) {
            cyBean = new TkmCypherBean();
            cyBean.setValid(false);
            cyBean.setEx(new Exception("TkmCypherBean must be not null"));
        }
        try {
            String internalTransactionBeanHash = TkmTextUtils.internalTransactionBeanHash(itb);
            if (itb.getNotBefore().getTime() > 1659534306000L && !itb.getTransactionHash().equals(internalTransactionBeanHash)) {
                cyBean.setValid(false);
                cyBean.setEx(new Exception("transaction not pass mandatory hash check"));
            }
        }
        catch (HashCompositionException | NullInternalTransactionBeanException ex) {
            cyBean.setEx(ex);
            log.error("Hash verification error", (Throwable)ex);
        }
        return cyBean;
    }

    public static TransactionBox verifyTransactionIntegrity(TransactionBean tb) {
        return TkmWallet.verifyTransactionIntegrity(tb, TkmTextUtils.toJson(tb));
    }

    private static boolean verifySigner(TransactionBean tb, InternalTransactionBean itb) {
        if (itb == null | tb == null) {
            return false;
        }
        switch (itb.getTransactionType()) {
            case ASSIGN_OVERFLOW: 
            case BLOB: 
            case BLOCK_HASH: 
            case S_CONTRACT_CALL: 
            case S_CONTRACT_DEPLOY: 
            case S_CONTRACT_INSTANCE: 
            case S_CREATE_ACCOUNT: 
            case PREVIOUS_BLOCK: 
            case DEREGISTER_MAIN: 
            case DEREGISTER_OVERFLOW: 
            case REGISTER_MAIN: 
            case REGISTER_OVERFLOW: 
            case STAKE: 
            case STAKE_UNDO: 
            case STATE_POINTER_TRANSACTION: 
            case UNASSIGN_OVERFLOW: 
            case PAY: {
                return itb.getFrom().equals(tb.getPublicKey());
            }
            case DECLARATION: {
                return true;
            }
            case COINBASE: {
                return itb.getTo().equals(tb.getPublicKey());
            }
            case BLOCK: {
                log.error("NOT IMPLEMENTED");
            }
        }
        log.error("NOT YET IMPLEMENTED");
        return false;
    }
}

