/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.takamaka.wallet.beans.EncKeyBean;
import io.takamaka.wallet.beans.InternalBlockBean;
import io.takamaka.wallet.beans.InternalTransactionBean;
import io.takamaka.wallet.beans.KeyBean;
import io.takamaka.wallet.beans.PublicKeyBean;
import io.takamaka.wallet.beans.TransactionBean;
import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashCompositionException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.exceptions.InclusionHashCreationException;
import io.takamaka.wallet.exceptions.NullInternalTransactionBeanException;
import io.takamaka.wallet.utils.FixedParameters;
import io.takamaka.wallet.utils.TkmSignUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkmTextUtils {
    private static final Logger log = LoggerFactory.getLogger(TkmTextUtils.class);
    public static final TypeReference<ArrayList<TransactionBean>> type_ArrayList_TransactionBean = new TypeReference<ArrayList<TransactionBean>>(){};

    private static final SimpleModule getSM() {
        SimpleModule simpleModule = new SimpleModule();
        return simpleModule;
    }

    public static final ObjectMapper getJacksonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)TkmTextUtils.getSM());
        return mapper;
    }

    public static final boolean isNullOrBlank(String text) {
        return text == null || "".equals(text.trim()) || StringUtils.isBlank((CharSequence)text) || text.isBlank() || text.isEmpty();
    }

    public static final String toJson(KeyBean key) {
        try {
            return TkmTextUtils.getJacksonMapper().writeValueAsString((Object)key);
        }
        catch (JsonProcessingException ex) {
            log.error("KeyBean serialization error", (Throwable)ex);
            return null;
        }
    }

    public static final KeyBean keyBeanFromJson(String keyBeanJson) {
        try {
            return (KeyBean)TkmTextUtils.getJacksonMapper().readValue(keyBeanJson, KeyBean.class);
        }
        catch (JsonProcessingException ex) {
            log.error("KeyBean deserialization error", (Throwable)ex);
            return null;
        }
    }

    public static final String toJson(EncKeyBean key) {
        try {
            return TkmTextUtils.getJacksonMapper().writeValueAsString((Object)key);
        }
        catch (JsonProcessingException ex) {
            log.error("EncKeyBean serialization error", (Throwable)ex);
            return null;
        }
    }

    public static final EncKeyBean enckeyBeanFromJson(String encKeyBeanJson) {
        try {
            return (EncKeyBean)TkmTextUtils.getJacksonMapper().readValue(encKeyBeanJson, EncKeyBean.class);
        }
        catch (JsonProcessingException ex) {
            log.error("EncKeyBean deserialization error", (Throwable)ex);
            return null;
        }
    }

    public static final String toJson(PublicKeyBean key) {
        try {
            return TkmTextUtils.getJacksonMapper().writeValueAsString((Object)key);
        }
        catch (JsonProcessingException ex) {
            log.error("PublicKeyBean serialization error", (Throwable)ex);
            return null;
        }
    }

    public static final PublicKeyBean publicKeyBeanFromJson(String publickeyBeanJson) {
        try {
            return (PublicKeyBean)TkmTextUtils.getJacksonMapper().readValue(publickeyBeanJson, PublicKeyBean.class);
        }
        catch (JsonProcessingException ex) {
            log.error("PublicKeyBean deserialization error", (Throwable)ex);
            return null;
        }
    }

    public static final String toJson(InternalTransactionBean itb) {
        try {
            return TkmTextUtils.getJacksonMapper().writeValueAsString((Object)itb);
        }
        catch (JsonProcessingException ex) {
            log.error("InternalTransactionBean serialization error", (Throwable)ex);
            return null;
        }
    }

    public static final InternalTransactionBean internalTransactionBeanFromJson(String jsonString) {
        try {
            return (InternalTransactionBean)TkmTextUtils.getJacksonMapper().readValue(jsonString, InternalTransactionBean.class);
        }
        catch (JsonProcessingException ex) {
            log.error("InternalTransactionBean deserialization error", (Throwable)ex);
            return null;
        }
    }

    public static final String toJson(InternalBlockBean itb) {
        try {
            return TkmTextUtils.getJacksonMapper().writeValueAsString((Object)itb);
        }
        catch (JsonProcessingException ex) {
            log.error("InternalTransactionBean serialization error", (Throwable)ex);
            return null;
        }
    }

    public static final InternalBlockBean internalBlockBeanFromJson(String jsonString) {
        try {
            return (InternalBlockBean)TkmTextUtils.getJacksonMapper().readValue(jsonString, InternalBlockBean.class);
        }
        catch (JsonProcessingException ex) {
            log.error("InternalTransactionBean deserialization error", (Throwable)ex);
            return null;
        }
    }

    public static final String toJson(ArrayList<TransactionBean> listTB) {
        try {
            return TkmTextUtils.getJacksonMapper().writeValueAsString(listTB);
        }
        catch (JsonProcessingException ex) {
            log.error("TransactionBean list serialization error.");
            return null;
        }
    }

    public static final ArrayList<TransactionBean> getTransactionBeanListFromJson(String jsonString) {
        try {
            return (ArrayList)TkmTextUtils.getJacksonMapper().readValue(jsonString, type_ArrayList_TransactionBean);
        }
        catch (JsonProcessingException ex) {
            log.error("TransactionBean list deserialization error.");
            return null;
        }
    }

    public static final String toJson(TransactionBean tb) {
        try {
            return TkmTextUtils.getJacksonMapper().writeValueAsString((Object)tb);
        }
        catch (JsonProcessingException ex) {
            log.error("TransactionBean serialization error.");
            return null;
        }
    }

    public static final TransactionBean transactionBeanFromJson(String transactionBeanJson) {
        try {
            return (TransactionBean)TkmTextUtils.getJacksonMapper().readValue(transactionBeanJson, TransactionBean.class);
        }
        catch (JsonProcessingException ex) {
            log.error("TransactionBean deserialization error.");
            return null;
        }
    }

    public static final String getSortingString(String input) {
        return new BigInteger(1, input.getBytes(FixedParameters.CHARSET)).toString();
    }

    public static final String internalTransactionBeanHash(InternalTransactionBean itb) throws NullInternalTransactionBeanException, HashCompositionException {
        try {
            if (itb == null) {
                throw new NullInternalTransactionBeanException("null itb");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(itb.getFrom());
            sb.append(itb.getTo());
            sb.append(itb.getMessage());
            sb.append(itb.getNotBefore().getTime());
            sb.append(itb.getRedValue());
            sb.append(itb.getGreenValue());
            sb.append(itb.getTransactionType().name());
            sb.append(itb.getEpoch());
            sb.append(itb.getSlot());
            String hash = TkmSignUtils.Hash256(sb.toString());
            return hash;
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("internal transaction bean hash generation exception", (Throwable)ex);
            throw new HashCompositionException(ex);
        }
    }

    public static final String generateWalletRandomString() {
        return RandomStringUtils.randomAlphanumeric((int)4);
    }

    public static final String singleTransactionInclusionHash(String itbHash, String addr, String sig, String random, String walletCypher) throws InclusionHashCreationException {
        try {
            return TkmSignUtils.Hash256(itbHash + addr + sig + random + walletCypher);
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("Error creating SITH", (Throwable)ex);
            throw new InclusionHashCreationException(ex);
        }
    }
}

