/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.exceptions.KeyDecodeException;
import io.takamaka.wallet.utils.FixedParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.zip.CRC32;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomUtils;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.encoders.UrlBase64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkmSignUtils {
    private static final Logger log = LoggerFactory.getLogger(TkmSignUtils.class);

    public static final AsymmetricCipherKeyPair stringPublicKeyToKeyPairBCEd25519(String publicKey) throws KeyDecodeException {
        try {
            UrlBase64 b64e = new UrlBase64();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.decode((String)publicKey, (OutputStream)baos);
            Ed25519PublicKeyParameters edPublicKey = new Ed25519PublicKeyParameters(baos.toByteArray(), 0);
            baos.close();
            AsymmetricCipherKeyPair ackp = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)edPublicKey, null);
            return ackp;
        }
        catch (Exception ex) {
            log.warn("error in conversion from string PublicKey To Key Pair BCEd25519", (Throwable)ex);
            throw new KeyDecodeException(ex);
        }
    }

    public static final AsymmetricCipherKeyPair stringPublicKeyToKeyPairBCQTESLAPSSC1(String publicKey) throws KeyDecodeException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.decode((String)publicKey, (OutputStream)baos);
            QTESLAPublicKeyParameters edPublicKey = new QTESLAPublicKeyParameters(5, baos.toByteArray());
            baos.close();
            AsymmetricCipherKeyPair ackp = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)edPublicKey, null);
            return ackp;
        }
        catch (Exception ex) {
            log.warn("error in conversion from string Public Key To Key Pair BCQTESLAPSSC1", (Throwable)ex);
            throw new KeyDecodeException(ex);
        }
    }

    public static final String Hash128(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.Hash(input, "SHA3-256");
    }

    public static final String Hash256(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.Hash(input, "SHA3-256");
    }

    public static final String Hash256B64URL(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.Hash256(input);
    }

    public static final String Hash384(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.Hash(input, "SHA3-384");
    }

    public static final String Hash384B64URL(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.Hash384(input);
    }

    public static final String Hash512(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.Hash(input, "SHA3-512");
    }

    public static final String Hash512B64URL(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.Hash512(input);
    }

    public static final byte[] Hash256byte(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.HashByte(input, "SHA3-256");
    }

    public static final byte[] Hash384byte(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.HashByte(input, "SHA3-384");
    }

    public static final String getShortenedAddr(String input) {
        try {
            byte[] HashByte = TkmSignUtils.Hash256byte(input);
            return TkmSignUtils.fromByteArrayToHexString(HashByte);
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("error in conversion to shortened address", (Throwable)ex);
            return null;
        }
    }

    public static final byte[] Hash512byte(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.HashByte(input, "SHA3-512");
    }

    public static final String PWHashB64(String input, String salt, int iterations, int bitLegnthKey) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException, InvalidKeySpecException, NoSuchAlgorithmException {
        try {
            PBEKeySpec spec = new PBEKeySpec(input.toCharArray(), salt.getBytes(), iterations, bitLegnthKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            byte[] hash = skf.generateSecret(spec).getEncoded();
            ByteBuffer bb = ByteBuffer.wrap(hash);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.encode((byte[])bb.array(), (OutputStream)baos);
            bb.clear();
            String out = baos.toString(FixedParameters.CHARSET.name());
            baos.close();
            return out;
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(TkmSignUtils.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static final byte[] PWHash(String input, String salt, int iterations, int bitLegnthKey) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException, InvalidKeySpecException, NoSuchAlgorithmException {
        PBEKeySpec spec = new PBEKeySpec(input.toCharArray(), salt.getBytes(), iterations, bitLegnthKey);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        return skf.generateSecret(spec).getEncoded();
    }

    private static final String Hash(String input, String hashType) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] inputBytes = input.getBytes(FixedParameters.CHARSET);
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            MessageDigest digest = MessageDigest.getInstance(hashType, "BC");
            digest.reset();
            ByteBuffer bb = ByteBuffer.wrap(inputBytes);
            digest.update(bb);
            UrlBase64.encode((byte[])digest.digest(), (OutputStream)baos);
            bb.clear();
            String out = baos.toString(FixedParameters.CHARSET.name());
            baos.close();
            return out;
        }
        catch (Exception ex) {
            log.error("hash funcion error", (Throwable)ex);
            throw new HashEncodeException(ex);
        }
    }

    public static final byte[] Hash256Byte(byte[] input, String hashType) throws NoSuchAlgorithmException, NoSuchProviderException {
        byte[] result = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        MessageDigest digest = MessageDigest.getInstance(hashType, "BC");
        digest.reset();
        ByteBuffer bb = ByteBuffer.wrap(input);
        digest.update(bb);
        result = digest.digest();
        digest.reset();
        bb.clear();
        return result;
    }

    private static byte[] HashByte(String input, String hashType) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] inputBytes = input.getBytes(FixedParameters.CHARSET);
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            MessageDigest digest = MessageDigest.getInstance(hashType, "BC");
            digest.reset();
            ByteBuffer bb = ByteBuffer.wrap(inputBytes);
            digest.update(bb);
            UrlBase64.encode((byte[])digest.digest(), (OutputStream)baos);
            bb.clear();
            byte[] out = baos.toByteArray();
            baos.close();
            return out;
        }
        catch (Exception ex) {
            log.error("hash to byte error", (Throwable)ex);
            throw new HashEncodeException(ex);
        }
    }

    public static final String Hash256ToHex(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.HashToHex(input, "SHA3-256");
    }

    public static final String Hash384ToHex(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.HashToHex(input, "SHA3-384");
    }

    public static final String Hash512ToHex(String input) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        return TkmSignUtils.HashToHex(input, "SHA3-512");
    }

    public static final String fromByteArrayToB64URL(byte[] input) {
        String out = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.encode((byte[])input, (OutputStream)baos);
            out = baos.toString(FixedParameters.CHARSET.name());
            baos.close();
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(TkmSignUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return out;
    }

    private static final byte[] streamToHash(InputStream in, String hashType) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        byte[] digestRes;
        byte[] res = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        MessageDigest digestMsg = MessageDigest.getInstance(hashType, "BC");
        res = digestRes = DigestUtils.digest((MessageDigest)digestMsg, (InputStream)in);
        return res;
    }

    public static final byte[] StreamToHash256Byte(InputStream in) {
        try {
            return TkmSignUtils.streamToHash(in, "SHA3-256");
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            log.error("stream to hash error", (Throwable)ex);
            return null;
        }
    }

    public static final byte[] StreamToHash160Byte(InputStream in) {
        try {
            return TkmSignUtils.streamToHash(in, "RipeMD160");
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            log.error("stream to hash 160 error", (Throwable)ex);
            return null;
        }
    }

    public static final byte[] StreamToHash384Byte(InputStream in) {
        try {
            return TkmSignUtils.streamToHash(in, "SHA3-384");
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            log.error("stream to hash 384 error", (Throwable)ex);
            return null;
        }
    }

    public static final byte[] StreamToHash512Byte(InputStream in) {
        try {
            return TkmSignUtils.streamToHash(in, "SHA3-512");
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            log.error("stream to hash 512 error", (Throwable)ex);
            return null;
        }
    }

    public static final String fromByteArrayToB64(byte[] input) {
        String out = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64.encode((byte[])input, (OutputStream)baos);
            out = baos.toString(FixedParameters.CHARSET.name());
            baos.close();
        }
        catch (Exception ex) {
            log.error("byte array to base64 error", (Throwable)ex);
        }
        return out;
    }

    private static String HashToHex(String input, String hashType) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        try {
            Hex henc = new Hex();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] inputBytes = input.getBytes(FixedParameters.CHARSET);
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            MessageDigest digest = MessageDigest.getInstance(hashType, "BC");
            digest.reset();
            ByteBuffer bb = ByteBuffer.wrap(inputBytes);
            digest.update(bb);
            Hex.encode((byte[])digest.digest(), (OutputStream)baos);
            bb.clear();
            return baos.toString(FixedParameters.CHARSET.name());
        }
        catch (Exception ex) {
            log.error("hash to hex", (Throwable)ex);
            throw new HashEncodeException(ex);
        }
    }

    public static final byte[] fromB64URLToByteArray(String input) {
        byte[] res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.decode((String)input, (OutputStream)baos);
            res = baos.toByteArray();
            baos.close();
        }
        catch (Exception ex) {
            log.error("base64url to byte array error", (Throwable)ex);
        }
        return res;
    }

    public static final byte[] fromB64ToByteArray(String input) {
        byte[] res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64.decode((String)input, (OutputStream)baos);
            res = baos.toByteArray();
            baos.close();
        }
        catch (Exception ex) {
            log.error("base64 to byte array error", (Throwable)ex);
        }
        return res;
    }

    public static final String fromB64UrlToHEX(String input) {
        byte[] b64ToByte = TkmSignUtils.fromB64URLToByteArray(input);
        if (b64ToByte != null) {
            return TkmSignUtils.fromByteArrayToHexString(b64ToByte);
        }
        return null;
    }

    public static final String fromB64ToHEX(String input) {
        byte[] b64ToByte = TkmSignUtils.fromB64ToByteArray(input);
        if (b64ToByte != null) {
            return TkmSignUtils.fromByteArrayToHexString(b64ToByte);
        }
        return null;
    }

    public static final String fromB64URLToB64(String b64URLKey) {
        byte[] b64URLToByte = TkmSignUtils.fromB64URLToByteArray(b64URLKey);
        if (b64URLToByte != null) {
            return TkmSignUtils.fromByteArrayToB64(b64URLToByte);
        }
        return null;
    }

    public static final String fromB64ToB64URL(String b64URL) {
        byte[] b64ToByte = TkmSignUtils.fromB64ToByteArray(b64URL);
        if (b64ToByte != null) {
            return TkmSignUtils.fromByteArrayToB64URL(b64ToByte);
        }
        return null;
    }

    public static final String fromHexToB64(String hexMessage) {
        String res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Hex.decode((String)hexMessage, (OutputStream)baos);
            byte[] toByteArray = baos.toByteArray();
            baos.close();
            res = TkmSignUtils.fromByteArrayToB64(toByteArray);
        }
        catch (Exception ex) {
            log.error("hex to base64 error", (Throwable)ex);
        }
        return res;
    }

    public static final String fromByteArrayToHexString(byte[] input) {
        String res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Hex.encode((byte[])input, (OutputStream)baos);
            res = baos.toString(FixedParameters.CHARSET.name());
            baos.close();
        }
        catch (Exception ex) {
            log.error("from byte array to hex string error", (Throwable)ex);
        }
        return res;
    }

    public static final String Hash160ToHex(String publicKey) {
        try {
            return TkmSignUtils.HashToHex(publicKey, "RipeMD160");
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("hash 160 to hex", (Throwable)ex);
            return null;
        }
    }

    public static final String fromStringToHexString(String message) {
        String res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] mBytes = message.getBytes(FixedParameters.CHARSET);
            Hex.encode((byte[])mBytes, (OutputStream)baos);
            res = baos.toString(FixedParameters.CHARSET.name());
            baos.close();
        }
        catch (Exception ex) {
            log.error("string to hex string error", (Throwable)ex);
        }
        return res;
    }

    public static final byte[] fromHexToByteArray(String message) {
        byte[] res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Hex.decode((String)message, (OutputStream)baos);
            res = baos.toByteArray();
            baos.close();
        }
        catch (Exception ex) {
            log.error("hex to byte array error", (Throwable)ex);
        }
        return res;
    }

    public static final String fromHexToString(String hexMessage) {
        String res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Hex.decode((String)hexMessage, (OutputStream)baos);
            res = baos.toString(FixedParameters.CHARSET.name());
            baos.close();
        }
        catch (Exception ex) {
            log.error("from hex to string error", (Throwable)ex);
        }
        return res;
    }

    public static final byte[] fromStringToByteArray(String message) {
        return message.getBytes(FixedParameters.CHARSET);
    }

    public static final char[] fromStringToCharArray(String message) {
        return message.toCharArray();
    }

    public static final String fromCharArrayToString(char[] message) {
        return new String(message);
    }

    public static final String fromStringToBase64URL(String message) {
        return TkmSignUtils.fromByteArrayToB64URL(TkmSignUtils.fromStringToByteArray(message));
    }

    public static final String fromBase64URLToString(String message) {
        try {
            return new String(TkmSignUtils.fromB64URLToByteArray(message), FixedParameters.CHARSET.name());
        }
        catch (UnsupportedEncodingException ex) {
            log.error("from b46url to string error", (Throwable)ex);
            return null;
        }
    }

    private static long textToLongID(String input, int bitLen) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            byte[] byIn = TkmSignUtils.fromStringToByteArray(input);
            SHAKEDigest sh = new SHAKEDigest(bitLen);
            sh.reset();
            sh.update(byIn, 0, byIn.length);
            byte[] byteRes = new byte[bitLen / 8];
            sh.doFinal(byteRes, 0, bitLen / 8);
            ByteBuffer buffer = ByteBuffer.allocate(bitLen / 8);
            buffer.put(byteRes);
            buffer.flip();
            return buffer.getLong();
        }
        catch (Exception ex) {
            log.error("text to longId error", (Throwable)ex);
            throw new HashEncodeException(ex);
        }
    }

    public static final long getRandomPositiveLong() {
        long nextLong = RandomUtils.nextLong((long)1L, (long)Long.MAX_VALUE);
        return nextLong;
    }

    public static final long getLongID(String text) {
        try {
            return TkmSignUtils.textToLongID(text, 256);
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("long id generation error", (Throwable)ex);
            return 0L;
        }
    }

    public static final String getHexCRC(String addressBASE64URL) {
        System.out.println("bytes: " + Arrays.toString(TkmSignUtils.fromB64URLToByteArray(addressBASE64URL)));
        byte[] ba = TkmSignUtils.fromB64URLToByteArray(addressBASE64URL);
        int[] ia = new int[ba.length];
        for (int i = 0; i < ba.length; ++i) {
            byte b = ba[i];
            ia[i] = b & 0xFF;
        }
        System.out.println("AI: " + Arrays.toString(ia));
        return TkmSignUtils.getHexCRC(TkmSignUtils.fromB64URLToByteArray(addressBASE64URL));
    }

    private static final String getHexCRC(byte[] input) {
        CRC32 checksum = new CRC32();
        checksum.reset();
        checksum.update(input);
        Long value = checksum.getValue();
        System.out.println("LONG: " + value);
        return Long.toHexString(value).substring(0, 4);
    }

    public static final void main(String[] args) throws HashEncodeException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        System.out.println(TkmSignUtils.getLongID("gatto"));
    }
}

