/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.TkmTextUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtils.class);

    public static Boolean isNullOrWhiteSpace(String input) {
        Boolean result = false;
        if (TkmTextUtils.isNullOrBlank(input)) {
            result = true;
        }
        return result;
    }

    public static String printList(ArrayList<?> input) {
        Object result = "";
        for (int i = 0; i < input.size(); ++i) {
            result = input.size() == 1 || i == input.size() - 1 ? (String)result + input.get(i).toString() : (String)result + input.get(i).toString() + ",";
        }
        return result;
    }

    public static <T> ArrayList<T> stringToList(String input, Class T, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        String[] temp = input.split(separator);
        for (int i = 0; i < temp.length; ++i) {
            result.add(temp[i]);
        }
        return result;
    }

    public static Integer tryParse(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            log.error("Error parsing text", (Throwable)e);
            return null;
        }
    }

    public static String arrayToString(String[] input) {
        String result = null;
        for (int i = 0; i < input.length; ++i) {
            result = result + input[i] + " ";
        }
        return result;
    }

    public static KeyContexts.TransactionType getTypeFromString(String input) {
        KeyContexts.TransactionType type = KeyContexts.TransactionType.UNDEFINED;
        for (KeyContexts.TransactionType t : KeyContexts.TransactionType.values()) {
            if (!t.name().equals(input)) continue;
            type = t;
        }
        return type;
    }
}

