/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeededRandom
extends SecureRandom {
    private static final Logger log = LoggerFactory.getLogger(SeededRandom.class);
    private String seed;
    private String scope;
    private int keyNumber;

    public SeededRandom(String seed, String scope, int keyNumber) {
        this.seed = seed;
        this.scope = scope;
        this.keyNumber = keyNumber;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        PBEKeySpec spec = new PBEKeySpec(Strings.asCharArray((byte[])Strings.toByteArray((String)this.seed)), Strings.toByteArray((String)this.scope), this.keyNumber, 8 * bytes.length);
        SecretKeyFactory skf = null;
        try {
            skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException ex) {
            log.error("seeded random next bytes error, missing PBKDF2WithHmacSHA512", (Throwable)ex);
            throw new RuntimeException("error in deterministic entropy generation, missing PBKDF2WithHmacSHA512", ex);
        }
        byte[] encoded = null;
        try {
            encoded = skf.generateSecret(spec).getEncoded();
        }
        catch (InvalidKeySpecException ex) {
            log.error("seeded random next bytes error", (Throwable)ex);
            throw new RuntimeException("error in deterministic entropy generation", ex);
        }
        for (int i = 0; i != bytes.length; ++i) {
            bytes[i] = encoded[i];
        }
    }
}

