/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.utils.FixedParameters;
import io.takamaka.wallet.utils.TkmSignUtils;
import io.takamaka.wallet.utils.TkmTextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedGenerator {
    private static final Logger log = LoggerFactory.getLogger(SeedGenerator.class);
    public static String[] words = new String[2048];
    public static boolean inizialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        BufferedReader reader = null;
        try {
            String mLine;
            String fileName = "dictionary.txt";
            ClassLoader classLoader = new SeedGenerator().getClass().getClassLoader();
            reader = new BufferedReader(new StringReader(IOUtils.toString((URL)classLoader.getResource(fileName), (Charset)FixedParameters.CHARSET)));
            for (int i = 0; !TkmTextUtils.isNullOrBlank(mLine = reader.readLine()) && i < 2048; ++i) {
                SeedGenerator.words[i] = mLine;
            }
        }
        catch (IOException e) {
            log.error("io error in seed generation", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("error closing reader in exception handling", (Throwable)e);
                }
            }
        }
    }

    public static List<String> generateWords() throws NoSuchAlgorithmException {
        try {
            ArrayList<String> rndWords = new ArrayList<String>();
            if (!inizialized) {
                SeedGenerator.init();
                inizialized = true;
            }
            Object concat = "";
            SecureRandom rand = new SecureRandom();
            for (int i = 0; i < 23; ++i) {
                int rnd = rand.nextInt(2048);
                rndWords.add(words[rnd]);
                concat = (String)concat + words[rnd];
            }
            int index = new BigInteger(TkmSignUtils.PWHash((String)concat, "TakamakaWalletWords", 1, 4096)).mod(BigInteger.valueOf(2048L)).intValue();
            String secondToLastWord = words[index];
            concat = (String)concat + words[index];
            index = new BigInteger(TkmSignUtils.PWHash((String)concat, "TakamakaWalletWords", 1, 4096)).mod(BigInteger.valueOf(2048L)).intValue();
            String lastWord = words[index];
            rndWords.add(secondToLastWord);
            rndWords.add(lastWord);
            return rndWords;
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | InvalidKeySpecException ex) {
            log.error("error generating words", (Throwable)ex);
            return null;
        }
    }

    public static boolean verifySeedWords(List<String> wordsList) {
        try {
            if (wordsList.size() != 25) {
                return false;
            }
            if (!inizialized) {
                SeedGenerator.init();
                inizialized = true;
            }
            Object concat = "";
            for (int i = 0; i < wordsList.size() - 2; ++i) {
                concat = (String)concat + wordsList.get(i);
            }
            int index = new BigInteger(TkmSignUtils.PWHash((String)concat, "TakamakaWalletWords", 1, 4096)).mod(BigInteger.valueOf(2048L)).intValue();
            String secondToLastWord = words[index];
            String lastWord = words[index = new BigInteger(TkmSignUtils.PWHash((String)(concat = (String)concat + words[index]), "TakamakaWalletWords", 1, 4096)).mod(BigInteger.valueOf(2048L)).intValue()];
            return lastWord.equals(wordsList.get(wordsList.size() - 1)) && secondToLastWord.equals(wordsList.get(wordsList.size() - 2));
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            log.error("seed verification failure", (Throwable)ex);
            return false;
        }
    }

    public static String generateSeedPWH(List<String> rndWords) throws NoSuchAlgorithmException, HashEncodeException, InvalidKeySpecException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        int saltIndex = 0;
        SeedGenerator.init();
        for (int i = 0; i < words.length; ++i) {
            if (!rndWords.get(0).equals(words[i])) continue;
            saltIndex = i;
            break;
        }
        Object salt = String.valueOf(saltIndex);
        String tempWord = "";
        for (String word : rndWords) {
            ArrayList<String> hashTable = new ArrayList<String>();
            tempWord = word;
            for (int i = 0; i < 2048; ++i) {
                tempWord = TkmSignUtils.PWHashB64(tempWord, (String)salt, 1, 768);
                hashTable.add(tempWord);
            }
            int modIndex = new BigInteger(((String)salt).getBytes()).abs().mod(new BigInteger("2048")).intValue();
            salt = (String)salt + (String)hashTable.get(modIndex);
        }
        return tempWord;
    }

    public static synchronized String toStringSeed(List<String> rndWords) {
        return String.join((CharSequence)" ", rndWords);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, HashEncodeException, InvalidKeySpecException, HashAlgorithmNotFoundException, HashProviderNotFoundException {
        List<String> rndWords = SeedGenerator.generateWords();
    }
}

