/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.utils.KeyContexts;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FixedParameters {
    public static final String CURRENT_STATE_FILE = "defaultState";
    public static final String DEFAULT_WALLET_NAME = "default_wallet";
    public static final String DEFAULT_ROGUE_ADDRESS_LIST_FILE_NAME = "rogueAddressList.json";
    public static final String STATE_FILE_EXTENSION = ".state";
    public static final String BLOCK_FILE_EXTENSION = ".block";
    public static final String STRING_ZERO = "ZERO";
    public static final String STRING_SKIPPED = "SKIPPED";
    public static final String WALLET_FOLDER = "wallets";
    public static final String PUBLICKEY_FOLDER = "publickeys";
    public static final String TRANSACTION_FOLDER = "transactions";
    public static final String ADDRESSBOOK_FOLDER = "addressbook";
    public static final String PUBLICKEY_EXTENSION = ".public";
    public static final String WALLET_EPHEMERAL_FOLDER = "ephemeral";
    public static final String WALLET_FILENAME = "_h2twallet.wall";
    public static final String ADDRESS_BOOK_FOLDER = "addressbook";
    public static final String ZERO_BLOCK_FOLDER = "ZeroBlockFolder";
    public static final String LOGS_FOLDER = "logs";
    public static final String REPLICA_NODE_ENABLED = "isReplicaNode.options";
    public static final String CHAIN_FOLDER = "chain";
    public static final String EPOCH_FOLDER_PREFIX = "epoch_";
    public static final String SLOT_FOLDER_PREFIX = "slot_";
    public static final String REFERENCE_QTESLA_ADDR_FOLDER = "reference_qtesla_addresses";
    public static final String REFERENCE_QTESLA_ADDR_PREFIX = "r|";
    public static final String TRANSACTION_BOX_FOLDER = "transactionBoxFolder";
    public static final String CHAIN_LOCK_FILE = "chainLockFile.lock";
    public static final String STATE_SLOT_SEPARATOR = ",";
    public static final String STATE_DB_PREFIX = "STATE_DB_";
    public static final long FORWARD_STATE_TOLLERANCE_MILLS = 30500L;
    public static final String HOLDER_STAKES_BY_TARGET_EXTENSION = ".HSBT";
    public static final String LIST_STAKES_DISTRIBUTION_EXTENSION = ".LSD";
    public static final String VRF_DISTRIBUTION_EXTENSION = ".VRF";
    public static final String EPOCH_WEIGHT_EXTENSION = ".EPOCH_WEIGHT";
    public static final String NODE_NETWORK_SETTINGS_FILE = "node_network_settings.xml";
    public static final String LOG_PREFIX_SEPARATOR = "-";
    public static final int WALLET_DICTIONARY_LENGTH = 2048;
    public static final int WALLET_WORDS_NUMBER = 25;
    public static final String HASH_PWH_ALGORITHM = "PBKDF2WithHmacSHA512";
    public static final String WALLET_DICTIONARY_FILE = "dictionary.txt";
    public static final String TRANSACTION_BOX_CACHING_FOLDER = "tbox_cache_folder";
    public static final String GLOBAL_FOLDER = "global_folder";
    public static final String USER_WALLETS_FOLDER = "user_wallets_folder";
    public static final String USER_WALLETS_FILE_EXTENSION = ".userWallet";
    public static final String USER_WALLETS_PREFIX = "LOCKED_PERSONAL_";
    public static final String USER_WALLETS_RECOVERY_WORDS_EXTENSION = ".words.txt";
    public static final String USER_WALLETS_HINT = "recovery_";
    public static final String CONFIG_FILE_NAME = "main_config_file.json";
    public static final String TEMP_DIR_NAME = "temporary_files_dir";
    public static final int ED25519_B64URL_ADDR_LEN = 44;
    public static final int QTESLA_B64URL_ADDR_LEN = 19840;
    public static final int SHRINKED_ADDR_B64URL_ADDR_LEN = 64;
    public static final String TRANSACTIONS_DUMP_FOLDER = "transactions_dump_folder";
    public static final String SIMULATION_DUMP_FOLDER = "simulation_dump_folder";
    public static final String SETTINGS_FOLDER = "settings_folder";
    public static final String SETTINGS_BOOKMARKS = "bookmarks.json";
    public static final String SETTINGS_TX = "transactions_endpoints.json";
    public static final String API_SETTINGS = "api.json";
    public static final String FAST_SETTINGS = "fast_tag.json";
    public static final String FAVOURITE_TO_BOOKMARKS = "to_addresses.json";
    public static final String MAIN_ALIASES_SETTINGS = "main_aliases.json";
    public static final String CASHBACK_SETTINGS_FILENAME = "cashback.json";
    public static final String CASHBACK_SETTINGS_WALLET_NAME = "CASHBACK_WALLET";
    public static KeyContexts.WalletCypher CASHBACK_SETTINGS_WALLET_TYPE = KeyContexts.WalletCypher.Ed25519BC;
    public static final String BASEURL_SETTINGS_FILENAME_EXPLORER = "explorer_endpoints.json";
    public static final String API_BALANCE_ENDPOINT = "balanceof/";
    public static final String NODE_MANAGEMENT_FOLDER = "node_management_folder";
    public static final String TRANSACTION_HISTORY_FILENAME = "transaction_history.json";
    public static int COMPRESSION_LEVEL = 9;
    public static final String[] HEX_KEY_NUM = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String HASH_128_ALGORITHM = "SHA3-128";
    public static final String HASH_256_ALGORITHM = "SHA3-256";
    public static final String HASH_384_ALGORITHM = "SHA3-384";
    public static final String HASH_160_ALGORITHM = "RipeMD160";
    public static final String HASH_512_ALGORITHM = "SHA3-512";
    public static final KeyContexts.TransactionType[] TRANSACTION_EXECUTION_ORDER = new KeyContexts.TransactionType[]{KeyContexts.TransactionType.DECLARATION, KeyContexts.TransactionType.STAKE_UNDO, KeyContexts.TransactionType.DEREGISTER_OVERFLOW, KeyContexts.TransactionType.DEREGISTER_MAIN, KeyContexts.TransactionType.REGISTER_MAIN, KeyContexts.TransactionType.REGISTER_OVERFLOW, KeyContexts.TransactionType.ASSIGN_OVERFLOW, KeyContexts.TransactionType.UNASSIGN_OVERFLOW, KeyContexts.TransactionType.STAKE, KeyContexts.TransactionType.PAY, KeyContexts.TransactionType.BLOB, KeyContexts.TransactionType.S_CREATE_ACCOUNT, KeyContexts.TransactionType.S_INSTALL_JAR, KeyContexts.TransactionType.S_CONTRACT_DEPLOY, KeyContexts.TransactionType.S_CONTRACT_INSTANCE, KeyContexts.TransactionType.S_CONTRACT_CALL};
    public static final KeyContexts.TransactionType[] FILTER_TRANSACTION_EXPIRATION_BOOTSTRAP_LIST = new KeyContexts.TransactionType[]{KeyContexts.TransactionType.DECLARATION, KeyContexts.TransactionType.STAKE_UNDO, KeyContexts.TransactionType.DEREGISTER_OVERFLOW, KeyContexts.TransactionType.DEREGISTER_MAIN, KeyContexts.TransactionType.REGISTER_MAIN, KeyContexts.TransactionType.REGISTER_OVERFLOW, KeyContexts.TransactionType.ASSIGN_OVERFLOW, KeyContexts.TransactionType.UNASSIGN_OVERFLOW, KeyContexts.TransactionType.STAKE, KeyContexts.TransactionType.PAY, KeyContexts.TransactionType.BLOB, KeyContexts.TransactionType.S_CONTRACT_DEPLOY, KeyContexts.TransactionType.S_CONTRACT_INSTANCE, KeyContexts.TransactionType.S_CONTRACT_CALL, KeyContexts.TransactionType.S_CREATE_ACCOUNT, KeyContexts.TransactionType.S_INSTALL_JAR};
    public static final List<KeyContexts.TransactionType> FILTER_TRANSACTION_EXPIRATION_BOOTSTRAP = new ArrayList<KeyContexts.TransactionType>(Arrays.asList(FILTER_TRANSACTION_EXPIRATION_BOOTSTRAP_LIST));
    public static final KeyContexts.TransactionType[] FILTER_TRANSACTION_EXPIRATION_NORMAL_OPERATION_LIST = new KeyContexts.TransactionType[]{KeyContexts.TransactionType.STAKE_UNDO, KeyContexts.TransactionType.DEREGISTER_OVERFLOW, KeyContexts.TransactionType.DEREGISTER_MAIN, KeyContexts.TransactionType.REGISTER_MAIN, KeyContexts.TransactionType.REGISTER_OVERFLOW, KeyContexts.TransactionType.ASSIGN_OVERFLOW, KeyContexts.TransactionType.UNASSIGN_OVERFLOW, KeyContexts.TransactionType.STAKE, KeyContexts.TransactionType.PAY, KeyContexts.TransactionType.BLOB, KeyContexts.TransactionType.S_CONTRACT_DEPLOY, KeyContexts.TransactionType.S_CONTRACT_INSTANCE, KeyContexts.TransactionType.S_CONTRACT_CALL, KeyContexts.TransactionType.S_CREATE_ACCOUNT, KeyContexts.TransactionType.S_INSTALL_JAR};
    public static final List<KeyContexts.TransactionType> FILTER_TRANSACTION_EXPIRATION_NORMAL_OPERATION = new ArrayList<KeyContexts.TransactionType>(Arrays.asList(FILTER_TRANSACTION_EXPIRATION_NORMAL_OPERATION_LIST));

    public static enum WalletError {
        INIZIALIZE(1, "I can't inizialize wallet files. Check for writing permissions."),
        CRYPTO(2, "Something went wrong with cryptography."),
        PKEY_READ(3, "I can't read the public key."),
        PKEY_UNLOCK(4, "I can't unlock the wallet\\wrong password."),
        WALLET_IO(5, "Wallet I/O problems."),
        RECOVERY_WORDS(6, "Problems with recovery words."),
        SETUP(7, "Setup problems."),
        LOCKED(8, "Wallet is locked."),
        RESTORE(9, "I can't restore wallet.");

        private final int code;
        private final String description;

        private WalletError(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return "\u001b[31mError W" + this.code + ": \u001b[37m" + this.description + "\u001b[0m";
        }
    }

    public static enum LogType {
        LOGGER,
        REST,
        NODE,
        WALLET;

    }

    public static enum HexKeyWriter {
        BALANCE(4),
        NODE(2),
        STAKE_UNDO(3),
        STAKE(4),
        OVER_THE_LIMIT(4),
        BLOCKS(4),
        ACCEPTED_BET(4);

        private final int depth;

        private HexKeyWriter(int depth) {
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }
    }

    public static enum GLOBAL_FOLDER_FILES {
        STORAGE_REFERENCE_JAR(".jarStorageReference"),
        STORAGE_REFERENCE_ACCOUNT(".accountStorageReference");

        private String fileExt;

        private GLOBAL_FOLDER_FILES(String fileExt) {
            this.fileExt = fileExt;
        }

        public String getExtension() {
            return this.fileExt;
        }
    }
}

