/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.utils;

import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.exceptions.ThreadSafeUtilsException;
import io.takamaka.wallet.exceptions.WalletException;
import io.takamaka.wallet.utils.DefaultInitParameters;
import io.takamaka.wallet.utils.FixedParameters;
import io.takamaka.wallet.utils.TkmSignUtils;
import io.takamaka.wallet.utils.TkmTextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);
    public static final Object KEYLOCK = new Object();
    private static String rootDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getRootDir() {
        Object object = KEYLOCK;
        synchronized (object) {
            return rootDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setRootDir(String rootDir) {
        Object object = KEYLOCK;
        synchronized (object) {
            FileHelper.rootDir = rootDir;
        }
    }

    public static final String[] getFileNameList(Path p) {
        if (p == null) {
            return null;
        }
        return (String[])Arrays.stream(p.toFile().listFiles()).map(f -> f.getAbsolutePath()).toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Path getDefaultApplicationDirectoryPath() {
        Object object = KEYLOCK;
        synchronized (object) {
            if (TkmTextUtils.isNullOrBlank(rootDir)) {
                rootDir = System.getProperty("user.home");
            }
            return Paths.get(rootDir, DefaultInitParameters.APPLICATION_ROOT_FOLDER_NAME);
        }
    }

    public static final Path getDeletedWalletFolderPath() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), DefaultInitParameters.DELETED_WALLET_FOLDER);
    }

    public static final Path getReferenceKeysDatabaseFolder() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), DefaultInitParameters.REFERENCE_KEYS_DATABASE_FOLDER);
    }

    public static final Path getMainDatabaseFolder() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), DefaultInitParameters.STATE_DATABASE_FOLDER);
    }

    public static final Path getTkmTempFolderPath() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "temporary_files_dir");
    }

    public static final Path getLiveStateFolter() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), DefaultInitParameters.LIVE_STATE_FOLDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Path getApplicationConfigFile() {
        Object object = KEYLOCK;
        synchronized (object) {
            return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "main_config_file.json");
        }
    }

    public static final Path getThemeConfigFilePath() {
        String userHome = rootDir;
        return Paths.get(userHome, DefaultInitParameters.APPLICATION_ROOT_FOLDER_NAME, "themeConfig.json");
    }

    public static final Path getHotmokaTestDirectoryPath() {
        String userHome = rootDir;
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), DefaultInitParameters.HOTMOKA_TEST_FOLDER_NAME);
    }

    public static final Path getHotmokaFilesDirectoryPath() {
        String userHome = rootDir;
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), DefaultInitParameters.HOTMOKA_FILES_FOLDER_NAME);
    }

    public static final Path getUserWalletsDirectoryPath() {
        String userHome = rootDir;
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "user_wallets_folder");
    }

    public static final Path getDefaultStatePath() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "defaultState.state");
    }

    public static final boolean defaultStatePathExists() {
        return Paths.get(FileHelper.getChainDirectory().toString(), "defaultState.state").toFile().exists();
    }

    public static final boolean homeDirExists() {
        Path applicationDirectoryPath = FileHelper.getDefaultApplicationDirectoryPath();
        File applicationDirectoryFilePointer = applicationDirectoryPath.toFile();
        return applicationDirectoryFilePointer.isDirectory();
    }

    public static final boolean themeConfigFileExists() {
        Path themePath = FileHelper.getThemeConfigFilePath();
        File themeFile = themePath.toFile();
        return themeFile.isFile();
    }

    public static final Path getDefaultWalletDirectoryPath() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "wallets");
    }

    public static final Path getPublicKeyDirectoryPath() {
        return Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), "publickeys");
    }

    public static final Path getTransactionsDirectoryPath() {
        return Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), "transactions");
    }

    public static final Path getEphemeralWalletDirectoryPath() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "ephemeral");
    }

    public static final Path getDefaultAddressBookDirectoryPath() {
        return Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), "addressbook");
    }

    public static final Path getDefaultLogsDirectoryPath() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "logs");
    }

    public static final Path logFile(String pattern) {
        return Paths.get(FileHelper.getDefaultLogsDirectoryPath().toString(), pattern);
    }

    public static final Path getChainDirectory() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "chain");
    }

    public static final Path getChainLockFile() {
        return Paths.get(FileHelper.getChainDirectory().getParent().toString(), "chainLockFile.lock");
    }

    public static final Path getEpochDirectory(int epochNumber) {
        return Paths.get(FileHelper.getChainDirectory().toString(), "epoch_" + epochNumber);
    }

    public static final Path getSlotDirectory(int epochNumber, int slotNumber) {
        return Paths.get(FileHelper.getEpochDirectory(epochNumber).toString(), "slot_" + slotNumber);
    }

    public static final Path getDefaultZeroBlockDirectory() {
        return Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "ZeroBlockFolder");
    }

    public static final Path getDefaultZeroBlockFile() {
        return Paths.get(FileHelper.getDefaultZeroBlockDirectory().toString(), DefaultInitParameters.ZERO_BLOCK_FILE_NUMBER);
    }

    public static final Path getKeyWriterBucketDirectory(int epoch, int slot, String uid, FixedParameters.HexKeyWriter hkw) {
        return Paths.get(FileHelper.getSlotDirectory(epoch, slot).toString(), uid + "." + hkw.name());
    }

    public static final Path initKeyHexWriterDirectoryTree(int epoch, int slot, String uid, FixedParameters.HexKeyWriter hkw) throws IOException {
        Path baseDir = null;
        log.info("init Key Hex Dir for " + hkw.name());
        baseDir = FileHelper.getKeyWriterBucketDirectory(epoch, slot, uid, hkw);
        FileHelper.createDir(baseDir);
        return baseDir;
    }

    public static final boolean defaultZeroBlockDirectoryExists() {
        return FileHelper.getDefaultZeroBlockDirectory().toFile().isDirectory();
    }

    public static final boolean defaultZeroBlockFileExists() {
        return FileHelper.getDefaultZeroBlockFile().toFile().isFile();
    }

    public static final boolean slotDirectoryExists(int epochNumber, int slotNumber) {
        return FileHelper.getSlotDirectory(epochNumber, slotNumber).toFile().isDirectory();
    }

    public static final boolean epochDirectoryExists(int epochNumber) {
        return FileHelper.getEpochDirectory(epochNumber).toFile().isDirectory();
    }

    public static final Path getNodeNetworkSettings() {
        Path settingsPathFolder = FileHelper.getSettingsPathFolder();
        Path nodeNetworkSettingsPath = Paths.get(settingsPathFolder.toString(), "node_network_settings.xml");
        return nodeNetworkSettingsPath;
    }

    public static final boolean chainDirectoryExists() {
        return FileHelper.getChainDirectory().toFile().isDirectory();
    }

    public static final boolean logsDirectoryExists() {
        return FileHelper.getDefaultLogsDirectoryPath().toFile().isDirectory();
    }

    public static final Path createSlotDirectory(int epochNumber, int slotNumber) throws IOException {
        if (!FileHelper.chainDirectoryExists()) {
            FileHelper.createDir(FileHelper.getChainDirectory());
        }
        log.info("chain directory " + FileHelper.getChainDirectory());
        if (!FileHelper.epochDirectoryExists(epochNumber)) {
            FileHelper.createDir(FileHelper.getEpochDirectory(epochNumber));
        }
        log.info("epoch directory " + FileHelper.getEpochDirectory(epochNumber));
        if (!FileHelper.slotDirectoryExists(epochNumber, slotNumber)) {
            FileHelper.createDir(FileHelper.getSlotDirectory(epochNumber, slotNumber));
        }
        log.info("slot directory " + FileHelper.getSlotDirectory(epochNumber, slotNumber));
        return FileHelper.getSlotDirectory(epochNumber, slotNumber);
    }

    public static final void createFolderAtPathIfNoneExist(Path path) throws IOException {
        if (!path.toFile().isDirectory()) {
            FileHelper.createDir(path);
        }
    }

    public static final Path getTransactionBoxFolder(int epoch, int slot) {
        Path result = null;
        result = Paths.get(FileHelper.getSlotDirectory(epoch, slot).toString(), "transactionBoxFolder");
        return result;
    }

    public static final Path getTransactionBoxDateFolder(Date input) {
        Path result = null;
        SimpleDateFormat dateformat = new SimpleDateFormat("dd-MM-yyyy");
        String date = dateformat.format(input);
        result = Paths.get(FileHelper.getDefaultAddressBookDirectoryPath().toString(), date + "_transactionBoxFolder");
        return result;
    }

    public static final String getBlockName(String blockUID) {
        return "STATE_DB_" + blockUID;
    }

    public static final Path getBlockPath(int epochNumber, int slotNumber, String blockHashNumber) {
        return Paths.get(FileHelper.getSlotDirectory(epochNumber, slotNumber).toString(), blockHashNumber);
    }

    public static final Path getBlockPathWithExension(int epochNumber, int slotNumber, String blockHashNumber) {
        return Paths.get(FileHelper.getSlotDirectory(epochNumber, slotNumber).toString(), blockHashNumber + ".block");
    }

    public static final boolean blockExists(int epochNumber, int slotNumber, String blockHashNumber) {
        return FileHelper.chainDirectoryExists() && FileHelper.epochDirectoryExists(epochNumber) && FileHelper.slotDirectoryExists(epochNumber, slotNumber) && FileHelper.getBlockPath(epochNumber, slotNumber, blockHashNumber).toFile().isFile();
    }

    public static final boolean walletDirExists() {
        return FileHelper.getDefaultWalletDirectoryPath().toFile().isDirectory();
    }

    public static final boolean publicKeyDirExists() {
        return FileHelper.getPublicKeyDirectoryPath().toFile().isDirectory();
    }

    public static final boolean transactionsDirExists() {
        return FileHelper.getTransactionsDirectoryPath().toFile().isDirectory();
    }

    public static final boolean walletEphemeralDirExists() {
        return FileHelper.getEphemeralWalletDirectoryPath().toFile().isDirectory();
    }

    public static final boolean addressBookDirExists() {
        return FileHelper.getDefaultAddressBookDirectoryPath().toFile().isDirectory();
    }

    public static final void createDir(Path directoryPathAndName) throws IOException {
        Files.createDirectory(directoryPathAndName, new FileAttribute[0]);
    }

    public static final Path getSettingsPathFolder() {
        Path settingsFolder = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "settings_folder");
        return settingsFolder;
    }

    public static final Path getTransactionsDumpPathFolder() {
        Path settingsFolder = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "transactions_dump_folder");
        return settingsFolder;
    }

    public static final Path getSimulationPathFolder() {
        Path settingsFolder = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "simulation_dump_folder");
        return settingsFolder;
    }

    public static final Path getPSQLFilePath() {
        Path settingsFolder = Paths.get(FileHelper.getSettingsPathFolder().toString(), DefaultInitParameters.psqlSettingsFile);
        return settingsFolder;
    }

    public static final Path getPSQLTablespacesRootFolderPath() {
        Path settingsFolder = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), DefaultInitParameters.psqlTablespacesRootFolder);
        return settingsFolder;
    }

    public static final Path getPSQLTablespacesBlockTable() {
        Path settingsFolder = Paths.get(FileHelper.getPSQLTablespacesRootFolderPath().toString(), DefaultInitParameters.psqlTablespacesBlocksFolderName);
        return settingsFolder;
    }

    public static final Path getTransactionsDumpPathFolder(String pidName) throws IOException {
        Path baseDumpFolder = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "transactions_dump_folder");
        if (!baseDumpFolder.toFile().isDirectory()) {
            FileHelper.createDir(baseDumpFolder);
        }
        if (baseDumpFolder.toFile().isDirectory()) {
            Path inner = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "transactions_dump_folder", pidName);
            FileHelper.createDir(inner);
            if (!inner.toFile().isDirectory()) {
                return null;
            }
            return inner;
        }
        return null;
    }

    public static final void extractFromJar(String resourceName, Path destinationPath) throws IOException {
        InputStream resourceAsStream;
        ClassLoader systemClassLoader;
        Stream<URL> resources;
        Path resourcePath = Paths.get(destinationPath.toString(), resourceName);
        if (FileHelper.fileExists(resourcePath)) {
            FileHelper.delete(resourcePath);
        }
        if ((resources = (systemClassLoader = ClassLoader.getSystemClassLoader()).resources(resourceName)).count() <= 0L) {
            System.out.println("FALLBACK");
            resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        } else {
            resourceAsStream = systemClassLoader.getResourceAsStream(resourceName);
        }
        FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)resourcePath.toFile());
    }

    public static final void initProjectFiles() throws IOException {
        Path userWalletFolder;
        Path globalStorageDir;
        Path tboxCacheDir;
        if (!FileHelper.homeDirExists()) {
            FileHelper.createDir(FileHelper.getDefaultApplicationDirectoryPath());
        }
        if (!FileHelper.getDeletedWalletFolderPath().toFile().isDirectory()) {
            FileHelper.createDir(FileHelper.getDeletedWalletFolderPath());
        }
        if (!FileHelper.getTkmTempFolderPath().toFile().isDirectory()) {
            FileHelper.createDir(FileHelper.getTkmTempFolderPath());
        }
        if (!FileHelper.logsDirectoryExists()) {
            FileHelper.createDir(FileHelper.getDefaultLogsDirectoryPath());
            log.info("Logs directory created");
        }
        if (!FileHelper.walletDirExists()) {
            FileHelper.createDir(FileHelper.getDefaultWalletDirectoryPath());
            log.info("Created wallet directory");
        }
        if (!FileHelper.publicKeyDirExists()) {
            FileHelper.createDir(FileHelper.getPublicKeyDirectoryPath());
            log.info("Created public keys directory");
        }
        if (!FileHelper.getReferenceKeysDatabaseFolder().toFile().isDirectory()) {
            FileHelper.createDir(FileHelper.getReferenceKeysDatabaseFolder());
        }
        if (!FileHelper.transactionsDirExists()) {
            FileHelper.createDir(FileHelper.getTransactionsDirectoryPath());
            log.info("Created transactions directory");
        }
        if (!FileHelper.walletEphemeralDirExists()) {
            FileHelper.createDir(FileHelper.getEphemeralWalletDirectoryPath());
        }
        if (!FileHelper.directoryExists(FileHelper.getSettingsPathFolder())) {
            FileHelper.createDir(FileHelper.getSettingsPathFolder());
        }
        if (!FileHelper.directoryExists(tboxCacheDir = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "tbox_cache_folder"))) {
            FileHelper.createDir(tboxCacheDir);
            log.info("cache dir created");
        }
        if (!FileHelper.directoryExists(globalStorageDir = FileHelper.getGlobalFolderPath())) {
            FileHelper.createDir(globalStorageDir);
            log.info("globalStorageDir dir created");
        }
        if (!FileHelper.directoryExists(userWalletFolder = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "user_wallets_folder"))) {
            FileHelper.createDir(userWalletFolder);
            log.info("user wallets dir created");
        }
        if (!FileHelper.getTransactionsDumpPathFolder().toFile().isDirectory()) {
            FileHelper.createDir(FileHelper.getTransactionsDumpPathFolder());
        }
        if (!FileHelper.getSimulationPathFolder().toFile().isDirectory()) {
            FileHelper.createDir(FileHelper.getSimulationPathFolder());
        }
        if (!FileHelper.getHotmokaFilesDirectoryPath().toFile().isDirectory()) {
            FileHelper.createDir(FileHelper.getHotmokaFilesDirectoryPath());
        }
        if (!FileHelper.directoryExists(FileHelper.getLiveStateFolter())) {
            FileHelper.createDir(FileHelper.getLiveStateFolter());
        }
        if (!FileHelper.directoryExists(FileHelper.getReferenceKeysDatabaseFolder())) {
            FileHelper.createDir(FileHelper.getReferenceKeysDatabaseFolder());
        }
        if (!FileHelper.getHotmokaTestDirectoryPath().toFile().isDirectory()) {
            FileHelper.createDir(FileHelper.getHotmokaTestDirectoryPath());
        }
        Path hotmokaTestDirectoryPath = FileHelper.getHotmokaTestDirectoryPath();
        Path settingsFolder = FileHelper.getSettingsPathFolder();
        Path settingsBookmarksFile = Paths.get(settingsFolder.toString(), "bookmarks.json");
        if (!FileHelper.directoryExists(settingsFolder)) {
            FileHelper.createDir(settingsFolder);
            log.info("settingsWalletFolder wallets dir created");
        }
    }

    public static final Path getGlobalFolderPath() {
        Path globalStorageDir = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "global_folder");
        return globalStorageDir;
    }

    public static final Path getJarStorage(String b64filename, FixedParameters.GLOBAL_FOLDER_FILES gff) {
        String fromB64ToHEX = TkmSignUtils.fromB64ToHEX(b64filename);
        Path globalStorageDir = Paths.get(FileHelper.getDefaultApplicationDirectoryPath().toString(), "global_folder", fromB64ToHEX + gff.getExtension());
        return globalStorageDir;
    }

    public static final Path getQteslaReferenceFolder() {
        Path defaultApplicationDirectoryPath = FileHelper.getDefaultApplicationDirectoryPath();
        Path folder = Paths.get(defaultApplicationDirectoryPath.toString(), "reference_qtesla_addresses");
        return folder;
    }

    public static final Path getQteslaReferenceAddressFolder(String addr) throws ThreadSafeUtilsException {
        if (TkmTextUtils.isNullOrBlank(addr)) {
            log.error("NULL ADDRESS VALUE");
            throw new ThreadSafeUtilsException("NULL ADDRESS VALUE");
        }
        if (addr.length() < DefaultInitParameters.QTESLA_COMPRESSED_ADDRESSES_FOLDER_LEVELS) {
            log.error("BAD ADDRESS LENGHT");
            throw new ThreadSafeUtilsException("BAD ADDRESS LENGHT");
        }
        String head = addr.substring(0, DefaultInitParameters.QTESLA_COMPRESSED_ADDRESSES_FOLDER_LEVELS);
        return Paths.get(FileHelper.getQteslaReferenceFolder().toString(), head);
    }

    public static final Path createIfNotExistQteslaReferenceFolder(String addr) throws ThreadSafeUtilsException, IOException {
        Path aFold = FileHelper.getQteslaReferenceAddressFolder(addr);
        if (aFold == null) {
            log.error("FOLDER ERROR");
            return null;
        }
        if (!FileHelper.directoryExists(aFold)) {
            FileHelper.createDir(aFold);
        }
        return aFold;
    }

    private static Path getQteslaRefenceAddrFilePathInternal(String refQaddrFraction) throws WalletException, ThreadSafeUtilsException {
        Path qRefAddrFold = FileHelper.getQteslaReferenceAddressFolder(refQaddrFraction);
        if (qRefAddrFold == null | TkmTextUtils.isNullOrBlank(refQaddrFraction)) {
            log.error("ERROR CREATING FILE PATH qFold " + qRefAddrFold + " qAddrFr " + refQaddrFraction);
            throw new WalletException("ERROR CREATING FILE PATH qFold " + qRefAddrFold + " qAddrFr " + refQaddrFraction);
        }
        return Paths.get(qRefAddrFold.toString(), refQaddrFraction);
    }

    public static final String deflateInflateAddress(String addr, boolean deflate) throws IOException, WalletException, ThreadSafeUtilsException {
        if (deflate) {
            return FileHelper.saveQteslaAddress(addr);
        }
        return FileHelper.retriveQaddrByReference(addr);
    }

    public static final String saveQteslaAddress(String qAddr) throws WalletException, ThreadSafeUtilsException, IOException {
        String refQAddrFraction;
        try {
            refQAddrFraction = TkmSignUtils.Hash256ToHex(qAddr);
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("CAN NOT CALCULATE HASH", (Throwable)ex);
            throw new WalletException("CAN NOT CALCULATE HASH", ex);
        }
        if (TkmTextUtils.isNullOrBlank(refQAddrFraction)) {
            log.error("ERROR IN REFERENCE ADDRESS");
            throw new WalletException("ERROR IN REFERENCE ADDRESS");
        }
        Path addrPath = FileHelper.createIfNotExistQteslaReferenceFolder(refQAddrFraction);
        if (addrPath == null) {
            log.error("ERROR CREATING ADDR PATH");
            throw new WalletException("ERROR IN ADDR PATH");
        }
        Path qRefFractAddrFilePath = FileHelper.getQteslaRefenceAddrFilePathInternal(refQAddrFraction);
        if (qRefFractAddrFilePath == null) {
            log.error("ERROR IN ADDR PATH");
            throw new WalletException("ERROR IN ADDR PATH");
        }
        if (!FileHelper.fileExists(qRefFractAddrFilePath)) {
            try {
                FileHelper.writeStringToFile(addrPath, refQAddrFraction, qAddr, true);
            }
            catch (IOException ex) {
                log.error("CAN NOT WRITE FILE!", (Throwable)ex);
                throw new WalletException("CAN NOT WRITE FILE!", ex);
            }
        } else {
            log.error("ADDRESS ALREADY PRESENT IN THE LIST");
        }
        return "r|" + refQAddrFraction;
    }

    public static final String getReferenceKeyStringNoSave(String qAddr) throws ThreadSafeUtilsException {
        String refQAddrFraction;
        try {
            refQAddrFraction = TkmSignUtils.Hash256ToHex(qAddr);
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("CAN NOT CALCULATE HASH", (Throwable)ex);
            throw new ThreadSafeUtilsException("CAN NOT CALCULATE HASH", ex);
        }
        return "r|" + refQAddrFraction;
    }

    public static final String retriveQaddrByReference(String refAddr) throws IOException, WalletException, ThreadSafeUtilsException {
        int prefixLength = "r|".length();
        if (TkmTextUtils.isNullOrBlank(refAddr)) {
            log.error("NULL REFADDR");
            throw new ThreadSafeUtilsException("NULL REFADDR");
        }
        if (refAddr.length() != prefixLength + 64) {
            log.error("WRONG ADDRESS LENGTH, missing prefix?");
            throw new ThreadSafeUtilsException("WRONG ADDRESS LENGTH, missing prefix?");
        }
        if (!refAddr.contains("r|")) {
            log.error("NOT A REFERENCE ADDRESS");
            throw new ThreadSafeUtilsException("NOT A REFERENCE ADDRESS");
        }
        String internalRefAddr = refAddr.substring(prefixLength, refAddr.length());
        Path qFile = FileHelper.getQteslaRefenceAddrFilePathInternal(internalRefAddr);
        if (!FileHelper.fileExists(qFile)) {
            log.error("MISSING QFILE, ADDRESS NOT IN LIST");
            throw new ThreadSafeUtilsException("MISSING QFILE, ADDRESS NOT IN LIST");
        }
        String readStringFromFile = FileHelper.readStringFromFile(qFile);
        return readStringFromFile;
    }

    public static final boolean fileExists(Path file) {
        boolean exists = file.toFile().isFile();
        return exists;
    }

    public static final boolean directoryExists(Path filePointer) {
        return filePointer.toFile().isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean writeStringToFile(Path directory, String fileName, String content, boolean overwrite) throws IOException {
        Object object = KEYLOCK;
        synchronized (object) {
            Path filePath = Paths.get(directory.toString(), fileName);
            log.info("File to be written " + filePath.toString());
            if (!FileHelper.fileExists(filePath)) {
                log.info("File does not exist");
                Files.createFile(filePath, new FileAttribute[0]);
                log.info("New empty file created");
            } else if (overwrite) {
                log.info("Content deleted");
                filePath.toFile().createNewFile();
                log.info("New empty file created");
            } else {
                log.info("File exist no overwriting, operation aborted");
                return false;
            }
            log.info("Writing content to file...");
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath.toFile()));
            writer.write(content);
            writer.close();
            log.info("content written and file closed");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean writeStringToFileUTF8(Path directory, String fileName, String content, boolean overwrite) throws IOException {
        Object object = KEYLOCK;
        synchronized (object) {
            Path filePath = Paths.get(directory.toString(), fileName);
            log.info("File to be written " + filePath.toString());
            if (!FileHelper.fileExists(filePath)) {
                log.info("File does not exist");
                Files.createFile(filePath, new FileAttribute[0]);
                log.info("New empty file created");
            } else if (overwrite) {
                log.info("Content deleted");
                filePath.toFile().createNewFile();
                log.info("New empty file created");
            } else {
                log.info("File exist no overwriting, operation aborted");
                return false;
            }
            log.info("Writing content to file...");
            byte[] utf8ByteContent = content.getBytes(StandardCharsets.UTF_8);
            Files.write(filePath, utf8ByteContent, StandardOpenOption.WRITE);
            log.info("content written and file closed");
            return true;
        }
    }

    public static final ArrayList<String> getWalletListInFolder(Path folderPath, String filter) {
        ArrayList<String> result = null;
        File folder = new File(folderPath.toString());
        File[] listOfFiles = folder.listFiles();
        result = new ArrayList<String>();
        for (File f : listOfFiles) {
            if (!f.isFile()) continue;
            if (!TkmTextUtils.isNullOrBlank(filter)) {
                String temp = f.getName().substring(0, f.getName().length() - DefaultInitParameters.WALLET_EXTENSION.length());
                if (!temp.toLowerCase().contains(filter.toLowerCase())) continue;
                result.add(f.getName());
                continue;
            }
            result.add(f.getName());
        }
        return result;
    }

    public static final ArrayList<String> getFilteredFileListInFolder(Path folderPath, String filter) {
        ArrayList<String> result = null;
        File folder = new File(folderPath.toString());
        File[] listOfFiles = folder.listFiles();
        result = new ArrayList<String>();
        for (File f : listOfFiles) {
            if (!f.isFile()) continue;
            if (!TkmTextUtils.isNullOrBlank(filter)) {
                String filename = f.getName();
                if (!filename.toLowerCase().contains(filter.toLowerCase())) continue;
                result.add(f.getName());
                continue;
            }
            result.add(f.getName());
        }
        return result;
    }

    public static final ArrayList<String> getFilteredFileListInFolderByType(Path folderPath, String filter) {
        ArrayList<String> result = null;
        File folder = new File(folderPath.toString());
        File[] listOfFiles = folder.listFiles();
        result = new ArrayList<String>();
        for (File f : listOfFiles) {
            if (!f.isFile()) continue;
            if (!TkmTextUtils.isNullOrBlank(filter)) {
                String filename = f.getName();
                if (!filename.toLowerCase().endsWith(filter.toLowerCase())) continue;
                result.add(f.getName());
                continue;
            }
            result.add(f.getName());
        }
        return result;
    }

    public static final ArrayList<String> getWalletList() {
        Path folderPath = FileHelper.getDefaultWalletDirectoryPath();
        ArrayList<String> result = null;
        File folder = new File(folderPath.toString());
        File[] listOfFiles = folder.listFiles();
        result = new ArrayList<String>();
        for (File f : listOfFiles) {
            if (!f.isFile()) continue;
            String fileName = f.getName().substring(0, f.getName().length() - DefaultInitParameters.WALLET_EXTENSION.length());
            result.add(fileName);
        }
        return result;
    }

    public static final File[] getFolderContent(Path folderPath) {
        File[] result = null;
        File folder = new File(folderPath.toString());
        result = folder.listFiles();
        return result;
    }

    public static final void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                FileHelper.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public static final void deleteSingleFile(Path filePath) {
        if (filePath.toFile().exists()) {
            boolean delete = filePath.toFile().delete();
            if (!delete) {
                log.error("file not deleted " + filePath.toString());
            }
        } else {
            log.error("not a file " + filePath.toString());
        }
    }

    public static final void delete(Path file) throws IOException {
        File f = new File(file.toString());
        if (f.isDirectory()) {
            throw new IOException("Failed, i can't deleate a direcotry: " + f);
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public static final void deleteFolderContent(File f) throws IOException {
        if (f.isFile()) {
            log.error("not a folder, do nothing " + f.toString());
        }
        if (f.isDirectory()) {
            for (File listFile : f.listFiles()) {
                try {
                    FileHelper.delete(listFile);
                }
                catch (Exception e) {
                    log.error("delete folder error", (Throwable)e);
                    throw new IOException("delete folder error", e);
                }
            }
        }
    }

    public static final String readStringFromFile(Path file) throws FileNotFoundException, IOException {
        if (!file.toFile().isFile()) {
            throw new FileNotFoundException();
        }
        String content = null;
        content = new String(Files.readAllBytes(file));
        return content;
    }

    public static final String readStringFromFileUTF8(Path file) throws FileNotFoundException, IOException {
        if (!file.toFile().isFile()) {
            throw new FileNotFoundException();
        }
        String content = null;
        byte[] readAllBytes = Files.readAllBytes(file);
        content = new String(readAllBytes, StandardCharsets.UTF_8);
        return content;
    }

    public static final void rename(Object sourcePath, Object targetPath, Boolean overwrite) throws IOException {
        File sourceFile = null;
        File targetFile = null;
        Boolean success = false;
        if (sourcePath instanceof String && targetPath instanceof String) {
            sourceFile = new File((String)sourcePath);
            targetFile = new File((String)targetPath);
        } else if (sourcePath instanceof Path && targetPath instanceof Path) {
            sourceFile = ((Path)sourcePath).toFile();
            targetFile = ((Path)targetPath).toFile();
        } else if (sourcePath instanceof File && targetPath instanceof File) {
            sourceFile = (File)sourcePath;
            targetFile = (File)targetPath;
        }
        if (overwrite.booleanValue() && targetFile.exists()) {
            FileHelper.delete(targetFile);
        }
        success = sourceFile.renameTo(targetFile);
    }

    public static final void copy(Path sources, Path destination) throws IOException {
        Files.copy(sources, destination, StandardCopyOption.REPLACE_EXISTING);
    }

    public static final void moveToSlot(int sourceEpoch, int sourceSlot, String sourceFile, int targetEpoch, int targetSlot, String targetFile) throws Exception {
        Path sourcePath = null;
        Path targetPath = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourceFile}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetFile})) {
            log.error("Either source or target file has not been specified");
            return;
        }
        if (FileHelper.epochDirectoryExists(sourceEpoch) && FileHelper.slotDirectoryExists(sourceEpoch, sourceSlot)) {
            sourcePath = FileHelper.getBlockPath(0, 0, sourceFile);
            targetPath = FileHelper.getBlockPath(0, 1, targetFile);
            if (!FileHelper.epochDirectoryExists(targetEpoch) || !FileHelper.slotDirectoryExists(targetEpoch, targetSlot)) {
                FileHelper.createSlotDirectory(targetEpoch, targetSlot);
                log.debug("Slot " + targetSlot + " created for epoch:" + targetEpoch);
            }
            FileHelper.rename(sourcePath, targetPath, true);
        } else {
            log.error("Could not find source folder.");
        }
    }

    public static final void deleteSettings(String option) throws IOException {
        Path settingsFolder = FileHelper.getSettingsPathFolder();
        Path settingsBookmarksFile = Paths.get(settingsFolder.toString(), option);
        FileHelper.delete(settingsBookmarksFile.toFile());
    }

    public static final void writeTransactionBoxToFile(Path path, Object input) throws IOException {
        try {
            FileOutputStream fout = null;
            fout = new FileOutputStream(path.toString());
            try (ObjectOutputStream oos = new ObjectOutputStream(fout);){
                oos.writeObject(input);
                oos.flush();
            }
            catch (IOException e) {
                throw new IOException("stream error", e);
            }
        }
        catch (IOException ex) {
            throw new IOException("file not found? ", ex);
        }
    }

    public static final void writeObjectToFile(Path path, String sithNumber, Object input) throws IOException {
        if (!path.toFile().isDirectory()) {
            FileHelper.createFolderAtPathIfNoneExist(path);
        }
        Path filePath = Paths.get(path.toString(), sithNumber);
        FileHelper.writeTransactionBoxToFile(filePath, input);
    }

    public static final Object readObjectFromFile(Path filePath) throws IOException {
        Object result = null;
        if (filePath.toFile().isFile()) {
            try (FileInputStream fileIn = new FileInputStream(filePath.toFile());
                 ObjectInputStream objectIn = new ObjectInputStream(fileIn);){
                result = objectIn.readObject();
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new IOException("read object stream error", ex);
            }
        }
        return result;
    }

    public static final Object readObjectFromFile(String filepath) throws IOException {
        Object result = null;
        try (FileInputStream fileIn = new FileInputStream(filepath);
             ObjectInputStream objectIn = new ObjectInputStream(fileIn);){
            result = objectIn.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IOException("stream read object error", ex);
        }
        return result;
    }

    public static final boolean testMandatoryStatusBean(int epoch, int slot, String uid) {
        if (TkmTextUtils.isNullOrBlank(uid)) {
            return false;
        }
        FixedParameters.HexKeyWriter[] kwTypes = FixedParameters.HexKeyWriter.values();
        Path slotDirectory = FileHelper.getSlotDirectory(epoch, slot);
        ConcurrentSkipListSet nuke = new ConcurrentSkipListSet();
        ((Stream)Arrays.stream(kwTypes).parallel()).forEach(hkw -> {
            Path index = null;
            switch (hkw) {
                case ACCEPTED_BET: {
                    index = Paths.get(slotDirectory.toString(), uid + "_." + hkw.name());
                    break;
                }
                case BALANCE: {
                    index = Paths.get(slotDirectory.toString(), uid + "_." + hkw.name());
                    break;
                }
                case BLOCKS: {
                    index = Paths.get(slotDirectory.toString(), uid + "_." + hkw.name());
                    break;
                }
                case NODE: {
                    index = Paths.get(slotDirectory.toString(), uid + "_." + hkw.name());
                    break;
                }
                case OVER_THE_LIMIT: {
                    index = Paths.get(slotDirectory.toString(), uid + "_." + hkw.name());
                    break;
                }
                case STAKE: {
                    index = Paths.get(slotDirectory.toString(), uid + "_." + hkw.name());
                    break;
                }
                case STAKE_UNDO: {
                    index = Paths.get(slotDirectory.toString(), uid + "_." + hkw.name());
                    break;
                }
                default: {
                    throw new RuntimeException("THIS SECTION MUST BE UPDATED TO TRACK CONSISTENCY OF DEFAULT STATE");
                }
            }
            if (!FileHelper.fileExists(index)) {
                log.error("DOES NOT EXIST " + index.toString());
                log.error("FOUND INCOSISTENCY IN DEFAULT STATE PROPOSAL");
                nuke.add(true);
            }
        });
        return !nuke.contains(true);
    }
}

