/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.beans;

import io.takamaka.wallet.beans.InternalTransactionBean;
import io.takamaka.wallet.beans.TransactionBean;
import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.TkmTextUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;

public class TransactionBox
implements Serializable,
Comparable<TransactionBox> {
    private String singleInclusionTransactionHash;
    private String transactionJson;
    private TransactionBean tb;
    private InternalTransactionBean itb;
    private boolean valid;

    public String getSingleInclusionTransactionHash() {
        return this.singleInclusionTransactionHash;
    }

    public void setSingleInclusionTransactionHash(String singleInclusionTransactionHash) {
        this.singleInclusionTransactionHash = singleInclusionTransactionHash;
    }

    public String getTransactionJson() {
        return this.transactionJson;
    }

    public void setTransactionJson(String transactionJson) {
        this.transactionJson = transactionJson;
    }

    public TransactionBean getTb() {
        return this.tb;
    }

    public void setTb(TransactionBean tb) {
        this.tb = tb;
    }

    public InternalTransactionBean getItb() {
        return this.itb;
    }

    public void setItb(InternalTransactionBean itb) {
        this.itb = itb;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String to() {
        return this.getItb().getTo();
    }

    public String from() {
        return this.getItb().getFrom();
    }

    public String messageInternalTB() {
        return this.getItb().getMessage();
    }

    public long notBeforeUNIX() {
        return this.getItb().getNotBefore().getTime();
    }

    public Date notBeforeDate() {
        return this.getItb().getNotBefore();
    }

    public BigInteger redValue() {
        return this.getItb().getRedValue();
    }

    public BigInteger greenValue() {
        return this.getItb().getGreenValue();
    }

    public KeyContexts.TransactionType type() {
        return this.getItb().getTransactionType();
    }

    public String transactionHash() {
        return this.getItb().getTransactionHash();
    }

    public Integer epoch() {
        return this.getItb().getEpoch();
    }

    public Integer slot() {
        return this.getItb().getSlot();
    }

    public String publicKey() {
        return this.tb.getPublicKey();
    }

    public String signature() {
        return this.tb.getSignature();
    }

    public String messageTB() {
        return this.tb.getMessage();
    }

    public String randomSeed() {
        return this.tb.getRandomSeed();
    }

    public KeyContexts.WalletCypher walletCypher() {
        return this.tb.getWalletCypher();
    }

    public String sith() {
        return this.getSingleInclusionTransactionHash();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.singleInclusionTransactionHash);
        hash = 71 * hash + Objects.hashCode(this.transactionJson);
        hash = 71 * hash + Objects.hashCode(this.tb);
        hash = 71 * hash + Objects.hashCode(this.itb);
        hash = 71 * hash + (this.valid ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionBox other = (TransactionBox)obj;
        if (this.valid != other.valid) {
            return false;
        }
        if (!Objects.equals(this.singleInclusionTransactionHash, other.singleInclusionTransactionHash)) {
            return false;
        }
        if (!Objects.equals(this.transactionJson, other.transactionJson)) {
            return false;
        }
        if (!Objects.equals(this.tb, other.tb)) {
            return false;
        }
        return Objects.equals(this.itb, other.itb);
    }

    @Override
    public int compareTo(TransactionBox t) {
        String externalObject = TkmTextUtils.getSortingString(t.getSingleInclusionTransactionHash());
        String internalObject = TkmTextUtils.getSortingString(this.getSingleInclusionTransactionHash());
        return internalObject.compareTo(externalObject);
    }
}

