/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.beans;

import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.TkmSignUtils;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyBean
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PublicKeyBean.class);
    private static final long serialVersionUID = 1L;
    private String hashHex;
    private KeyContexts.WalletCypher cypher;
    private String version;
    private String publicKey;

    public PublicKeyBean() {
    }

    public PublicKeyBean(KeyContexts.WalletCypher cypher, String version, String publicKey) {
        try {
            this.hashHex = TkmSignUtils.Hash256ToHex(publicKey);
            this.cypher = cypher;
            this.version = version;
            this.publicKey = publicKey;
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("public key bean instantiation error", (Throwable)ex);
        }
    }

    public String getHashHex() {
        return this.hashHex;
    }

    public void setHashHex(String hashHex) {
        this.hashHex = hashHex;
    }

    public KeyContexts.WalletCypher getCypher() {
        return this.cypher;
    }

    public void setCypher(KeyContexts.WalletCypher cypher) {
        this.cypher = cypher;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.hashHex);
        hash = 83 * hash + Objects.hashCode(this.publicKey);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicKeyBean other = (PublicKeyBean)obj;
        if (!Objects.equals(this.hashHex, other.hashHex)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.publicKey, other.publicKey)) {
            return false;
        }
        return this.cypher == other.cypher;
    }
}

