/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet.beans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.takamaka.wallet.beans.EncKeyBean;
import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.exceptions.QRNotFromJsonException;
import io.takamaka.wallet.exceptions.QRNullWordsException;
import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.TkmSignUtils;
import io.takamaka.wallet.utils.TkmTextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncWordsBean {
    private static final Logger log = LoggerFactory.getLogger(EncWordsBean.class);
    private EncKeyBean eb;
    private KeyContexts.QrType qType;
    private KeyContexts.CrcType cType;
    private transient String jsonReadedCrc;

    public EncKeyBean getEb() {
        return this.eb;
    }

    public void setEb(EncKeyBean eb) {
        this.eb = eb;
    }

    public String getCrc() {
        try {
            switch (this.cType) {
                case TYPE_1: {
                    return TkmSignUtils.Hash256ToHex(TkmTextUtils.toJson(this.eb));
                }
            }
            return null;
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("CRC error", (Throwable)ex);
            return null;
        }
    }

    public String getqType() {
        return this.qType.name();
    }

    public void setqType(KeyContexts.QrType qType) {
        this.qType = qType;
    }

    public String getcType() {
        return this.cType.getCRC();
    }

    public void setcType(KeyContexts.CrcType cType) {
        this.cType = cType;
    }

    @JsonIgnore
    public boolean isValid() throws QRNotFromJsonException, QRNullWordsException {
        if (TkmTextUtils.isNullOrBlank(this.jsonReadedCrc)) {
            throw new QRNotFromJsonException("null jsonReadedCrc");
        }
        if (TkmTextUtils.isNullOrBlank(TkmTextUtils.toJson(this.eb))) {
            throw new QRNullWordsException("null or empty words");
        }
        return this.jsonReadedCrc.equals(this.getCrc());
    }

    @JsonIgnore
    public String getJsonReadedCrc() {
        return this.jsonReadedCrc;
    }

    @JsonIgnore
    public void setJsonReadedCrc(String jsonReadedCrc) {
        this.jsonReadedCrc = jsonReadedCrc;
    }
}

